/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.jooq.pg.Tables;

public class JsonbFunctionCall {
    private final List<String> itemPathArray;
    private final String marker;
    private final String function;

    public JsonbFunctionCall(List<String> itemPathArray, String marker, String function) {
        this.itemPathArray = itemPathArray;
        this.function = function;
        this.marker = marker;
    }

    public List<String> resolve() {
        List<String> resultList = new ArrayList<String>();
        resultList.addAll(this.itemPathArray);
        while (resultList.contains(this.marker)) {
            resultList = this.resolveIterativeCall(resultList);
        }
        return resultList;
    }

    private List<String> resolveIterativeCall(List<String> itemPathArray) {
        ArrayList<String> resultList = new ArrayList<String>();
        int startList = 0;
        if (itemPathArray.contains(this.marker)) {
            StringBuilder expression = new StringBuilder();
            int markerPos = itemPathArray.indexOf(this.marker);
            expression.append("(");
            expression.append(this.function);
            expression.append("(");
            if (!itemPathArray.get(0).contains(this.function)) {
                expression.append("(");
                expression.append(Tables.ENTRY.ENTRY_);
                startList = 0;
            } else {
                expression.append(itemPathArray.get(0));
                startList = 1;
            }
            expression.append("#>>");
            expression.append("'{");
            expression.append(StringUtils.join((Object[])itemPathArray.subList(startList, markerPos).toArray(new String[0]), (String)","));
            expression.append("}'");
            expression.append(")");
            expression.append("::jsonb");
            expression.append(")");
            if (itemPathArray.subList(markerPos + 1, itemPathArray.size()).contains(this.marker)) {
                resultList.add(expression.toString());
                int endPos = markerPos + 1;
                resultList.addAll(itemPathArray.subList(endPos, itemPathArray.size()));
            } else {
                expression.append("#>>");
                expression.append("'");
                expression.append("{");
                int endPos = itemPathArray.size();
                expression.append(StringUtils.join((Object[])itemPathArray.subList(markerPos + 1, endPos).toArray(new String[0]), (String)","));
                expression.append("}");
                expression.append("'");
                expression.append(")");
                resultList.add(expression.toString());
            }
            return resultList;
        }
        return itemPathArray;
    }
}

