/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.TemplateId;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ArchetypeID;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ContextAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.jooq.SystemValue;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.query.AsyncSqlQuery;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.EntryType;
import org.ehrbase.jooq.pg.tables.records.EntryHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.EntryRecord;
import org.ehrbase.jooq.pg.tables.records.TerritoryRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.serialisation.dbencoding.RawJson;
import org.ehrbase.serialisation.dbencoding.rmobject.FeederAuditEncoding;
import org.ehrbase.serialisation.dbencoding.rmobject.LinksEncoding;
import org.ehrbase.service.RecordedDvCodedText;
import org.ehrbase.service.RecordedDvText;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.UpdateQuery;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryAccess
extends DataAccess
implements I_EntryAccess {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DB_INCONSISTENCY = "DB inconsistency:";
    private EntryRecord entryRecord;
    private Composition composition;

    public EntryAccess(I_DomainAccess domainAccess, String templateId, Integer sequence, UUID compositionId, Composition composition) {
        super(domainAccess.getContext(), domainAccess.getKnowledgeManager(), domainAccess.getIntrospectService(), domainAccess.getServerConfig());
        this.setFields(templateId, sequence, compositionId, composition);
    }

    private EntryAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public static List<I_EntryAccess> retrieveInstanceInComposition(I_DomainAccess domainAccess, I_CompositionAccess compositionAccess) {
        Result entryRecords = domainAccess.getContext().selectFrom((Table)Tables.ENTRY).where(Tables.ENTRY.COMPOSITION_ID.eq((Object)compositionAccess.getId())).fetch();
        HashMap<SystemValue, Object> values = new HashMap<SystemValue, Object>();
        values.put(SystemValue.COMPOSER, new PersistedPartyProxy(domainAccess).retrieve(compositionAccess.getComposerId()));
        Optional<I_ContextAccess> opContextAccess = compositionAccess.getContextId().map(id -> I_ContextAccess.retrieveInstance(domainAccess, id));
        opContextAccess.ifPresent(context -> values.put(SystemValue.CONTEXT, context.mapRmEventContext()));
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchOne((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        if (compositionAccess.getFeederAudit() != null) {
            values.put(SystemValue.FEEDER_AUDIT, new FeederAuditEncoding().fromDB(compositionAccess.getFeederAudit()));
        }
        if (compositionAccess.getLinks() != null) {
            values.put(SystemValue.LINKS, new LinksEncoding().fromDB(compositionAccess.getLinks()));
        }
        ArrayList<I_EntryAccess> content = new ArrayList<I_EntryAccess>();
        try {
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            for (EntryRecord record : entryRecords) {
                Integer version = I_CompositionAccess.getLastVersionNumber(domainAccess, compositionAccess.getId());
                values.put(SystemValue.UID, new ObjectVersionId(compositionAccess.getId().toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
                entryAccess.entryRecord = record;
                String value = record.getEntry().data();
                entryAccess.composition = (Composition)new RawJson().unmarshal(value, Composition.class);
                opContextAccess.map(I_ContextAccess::mapRmEventContext).ifPresent(ec -> values.put(SystemValue.CONTEXT, ec));
                values.put(SystemValue.CATEGORY, new RecordedDvCodedText().fromDB((Record)record, (Field<DvCodedTextRecord>)Tables.ENTRY.CATEGORY));
                EntryAccess.setCompositionAttributes(entryAccess.composition, values);
                EntryAccess.buildArchetypeDetails(entryAccess);
                content.add(entryAccess);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
        return content;
    }

    private static void buildArchetypeDetails(EntryAccess entryAccess) {
        Archetyped archetypeDetails = new Archetyped();
        TemplateId templateId = new TemplateId();
        templateId.setValue(entryAccess.getTemplateId());
        archetypeDetails.setTemplateId(templateId);
        archetypeDetails.setArchetypeId(new ArchetypeID(entryAccess.getArchetypeId()));
        archetypeDetails.setRmVersion(entryAccess.getRmVersion());
        entryAccess.composition.setArchetypeDetails(archetypeDetails);
    }

    public static List<I_EntryAccess> retrieveInstanceInCompositionVersion(I_DomainAccess domainAccess, I_CompositionAccess compositionHistoryAccess, int version) {
        Result entryHistoryRecords = domainAccess.getContext().selectFrom((Table)Tables.ENTRY_HISTORY).where(Tables.ENTRY_HISTORY.COMPOSITION_ID.eq((Object)compositionHistoryAccess.getId())).and(Tables.ENTRY_HISTORY.SYS_TRANSACTION.eq((Object)compositionHistoryAccess.getSysTransaction())).fetch();
        HashMap<SystemValue, Object> values = new HashMap<SystemValue, Object>();
        values.put(SystemValue.COMPOSER, new PersistedPartyProxy(domainAccess).retrieve(compositionHistoryAccess.getComposerId()));
        EventContext context = I_ContextAccess.retrieveHistoricalEventContext(domainAccess, compositionHistoryAccess.getId(), compositionHistoryAccess.getSysTransaction());
        if (context == null) {
            compositionHistoryAccess.getContextId().ifPresent(uuid -> I_ContextAccess.retrieveInstance(domainAccess, uuid).mapRmEventContext());
        }
        values.put(SystemValue.CONTEXT, context);
        values.put(SystemValue.LANGUAGE, new CodePhrase(new TerminologyId("ISO_639-1"), compositionHistoryAccess.getLanguageCode()));
        String territory2letters = ((TerritoryRecord)domainAccess.getContext().fetchOne((Table)Tables.TERRITORY, Tables.TERRITORY.CODE.eq((Object)compositionHistoryAccess.getTerritoryCode()))).getTwoletter();
        values.put(SystemValue.TERRITORY, new CodePhrase(new TerminologyId("ISO_3166-1"), territory2letters));
        values.put(SystemValue.FEEDER_AUDIT, new FeederAuditEncoding().fromDB(compositionHistoryAccess.getFeederAudit()));
        ArrayList<I_EntryAccess> content = new ArrayList<I_EntryAccess>();
        try {
            EntryAccess entryAccess = new EntryAccess(domainAccess);
            for (EntryHistoryRecord record : entryHistoryRecords) {
                UUID compositionId = compositionHistoryAccess.getId();
                values.put(SystemValue.UID, new ObjectVersionId(compositionId.toString() + "::" + domainAccess.getServerConfig().getNodename() + "::" + version));
                entryAccess.entryRecord = (EntryRecord)domainAccess.getContext().newRecord((Table)Tables.ENTRY);
                entryAccess.entryRecord.from((Object)record);
                entryAccess.composition = (Composition)new RawJson().unmarshal(record.getEntry().data(), Composition.class);
                EntryAccess.setCompositionAttributes(entryAccess.composition, values);
                EntryAccess.buildArchetypeDetails(entryAccess);
                content.add(entryAccess);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(DB_INCONSISTENCY + e);
        }
        return content;
    }

    public static Map<String, Object> queryJSON(I_DomainAccess domainAccess, String queryString) {
        return new AsyncSqlQuery(domainAccess, queryString).fetch();
    }

    private static void setCompositionAttributes(Composition composition, Map<SystemValue, Object> values) {
        if (values == null) {
            return;
        }
        block12: for (Map.Entry<SystemValue, Object> systemValue : values.entrySet()) {
            switch (systemValue.getKey()) {
                case CATEGORY: {
                    composition.setCategory((DvCodedText)systemValue.getValue());
                    continue block12;
                }
                case LANGUAGE: {
                    composition.setLanguage((CodePhrase)systemValue.getValue());
                    continue block12;
                }
                case TERRITORY: {
                    composition.setTerritory((CodePhrase)systemValue.getValue());
                    continue block12;
                }
                case COMPOSER: {
                    composition.setComposer((PartyProxy)systemValue.getValue());
                    continue block12;
                }
                case UID: {
                    composition.setUid((UIDBasedId)systemValue.getValue());
                    continue block12;
                }
                case CONTEXT: {
                    composition.setContext((EventContext)systemValue.getValue());
                    continue block12;
                }
                case NAME: {
                    composition.setName((DvText)systemValue.getValue());
                    continue block12;
                }
                case RM_VERSION: {
                    composition.getArchetypeDetails().setRmVersion((String)systemValue.getValue());
                    continue block12;
                }
                case FEEDER_AUDIT: {
                    composition.setFeederAudit((FeederAudit)systemValue.getValue());
                    continue block12;
                }
                case LINKS: {
                    composition.setLinks((List)systemValue.getValue());
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Could not handle composition attribute:" + (Object)((Object)systemValue.getKey()));
        }
    }

    private void setCompositionFields(EntryRecord record, Composition composition) {
        record.setCategory(record.getCategory());
        if (composition.getContent() != null && !composition.getContent().isEmpty()) {
            Object node = composition.getContent().get(0);
            if (node instanceof Section) {
                record.setItemType(EntryType.valueOf((String)"section"));
            } else if (node instanceof Evaluation || node instanceof Observation || node instanceof Instruction || node instanceof Action) {
                record.setItemType(EntryType.valueOf((String)"care_entry"));
            } else if (node instanceof AdminEntry) {
                record.setItemType(EntryType.valueOf((String)"admin"));
            }
        } else {
            record.setItemType(EntryType.valueOf((String)"admin"));
        }
        record.setArchetypeId(composition.getArchetypeNodeId());
        RawJson rawJson = new RawJson();
        record.setEntry(JSONB.valueOf((String)rawJson.marshal((RMObject)composition)));
    }

    private void setFields(String templateId, Integer sequence, UUID compositionId, Composition composition) {
        this.entryRecord = (EntryRecord)this.getContext().newRecord((Table)Tables.ENTRY);
        this.entryRecord.setTemplateId(templateId);
        this.entryRecord.setSequence(sequence);
        this.entryRecord.setCompositionId(compositionId);
        this.entryRecord.setRmVersion(composition.getArchetypeDetails().getRmVersion());
        new RecordedDvCodedText().toDB((Record)this.entryRecord, (Field<DvCodedTextRecord>)Tables.ENTRY.CATEGORY, composition.getCategory());
        this.setCompositionFields(this.entryRecord, composition);
        this.setCompositionName(composition.getName());
        this.composition = composition;
    }

    @Override
    public Composition getComposition() {
        return this.composition;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        Record result = this.getContext().insertInto((Table)Tables.ENTRY, (Field)Tables.ENTRY.SEQUENCE, (Field)Tables.ENTRY.COMPOSITION_ID, (Field)Tables.ENTRY.TEMPLATE_ID, (Field)Tables.ENTRY.ITEM_TYPE, (Field)Tables.ENTRY.ARCHETYPE_ID, (Field)Tables.ENTRY.CATEGORY, (Field)Tables.ENTRY.ENTRY_, (Field)Tables.ENTRY.SYS_TRANSACTION, (Field)Tables.ENTRY.NAME, (Field)Tables.ENTRY.RM_VERSION).values((Field)DSL.val((Integer)this.getSequence()), (Field)DSL.val((UUID)this.getCompositionId()), (Field)DSL.val((String)this.getTemplateId()), (Field)DSL.val((Object)EntryType.valueOf((String)this.getItemType())), (Field)DSL.val((String)this.getArchetypeId()), (Field)DSL.val((Object)this.getCategory()), (Field)DSL.val((Object)this.getEntryJson()), (Field)DSL.val((Timestamp)transactionTime), (Field)DSL.val((Object)this.getCompositionName()), (Field)DSL.val((String)this.getRmVersion())).returning(new SelectFieldOrAsterisk[]{Tables.ENTRY.ID}).fetchOne();
        return (UUID)result.getValue((Field)Tables.ENTRY.ID);
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new InternalServerException("INTERNAL: commit without transaction time is not legal");
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        this.logger.debug("updating entry with force flag:" + force + " and changed flag:" + this.entryRecord.changed());
        if (!force && !this.entryRecord.changed()) {
            this.logger.debug("No updateComposition took place, returning...");
            return false;
        }
        this.entryRecord.changed((Field)Tables.ENTRY.SYS_PERIOD, false);
        UpdateQuery updateQuery = this.getContext().updateQuery((Table)Tables.ENTRY);
        updateQuery.addValue((Field)Tables.ENTRY.COMPOSITION_ID, (Object)this.getCompositionId());
        updateQuery.addValue((Field)Tables.ENTRY.SEQUENCE, DSL.field((SelectField)DSL.val((Integer)this.getSequence())));
        updateQuery.addValue((Field)Tables.ENTRY.TEMPLATE_ID, DSL.field((SelectField)DSL.val((String)this.getTemplateId())));
        updateQuery.addValue((Field)Tables.ENTRY.ITEM_TYPE, DSL.field((SelectField)DSL.val((Object)EntryType.valueOf((String)this.getItemType()))));
        updateQuery.addValue((Field)Tables.ENTRY.ARCHETYPE_ID, DSL.field((SelectField)DSL.val((String)this.getArchetypeId())));
        updateQuery.addValue((Field)Tables.ENTRY.CATEGORY, DSL.field((SelectField)DSL.val((Object)this.getCategory())));
        updateQuery.addValue((Field)Tables.ENTRY.ENTRY_, DSL.field((SelectField)DSL.val((Object)this.getEntryJson())));
        updateQuery.addValue((Field)Tables.ENTRY.SYS_TRANSACTION, DSL.field((SelectField)DSL.val((Timestamp)transactionTime)));
        updateQuery.addValue((Field)Tables.ENTRY.NAME, DSL.field((SelectField)DSL.val((Object)this.getCompositionName())));
        updateQuery.addValue((Field)Tables.ENTRY.RM_VERSION, DSL.field((SelectField)DSL.val((String)this.getRmVersion())));
        updateQuery.addConditions(Tables.ENTRY.ID.eq((Object)this.getId()));
        this.logger.debug("Update done...");
        return updateQuery.execute() > 0;
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: Invalid updateComposition call to updateComposition without Transaction time and/or force flag arguments");
    }

    @Override
    public Integer delete() {
        if (this.entryRecord != null) {
            return this.entryRecord.delete();
        }
        return 0;
    }

    @Override
    public UUID getId() {
        return this.entryRecord.getId();
    }

    @Override
    public JSONB getEntryJson() {
        return this.entryRecord.getEntry();
    }

    @Override
    public DvCodedTextRecord getCategory() {
        return this.entryRecord.getCategory();
    }

    public DvCodedTextRecord getCompositionName() {
        return this.entryRecord.getName();
    }

    public void setCompositionName(DvText compositionName) {
        new RecordedDvText().toDB((Record)this.entryRecord, (Field<DvCodedTextRecord>)Tables.ENTRY.NAME, compositionName);
    }

    @Override
    public UUID getCompositionId() {
        return this.entryRecord.getCompositionId();
    }

    @Override
    public void setCompositionId(UUID compositionId) {
        this.entryRecord.setCompositionId(compositionId);
    }

    @Override
    public String getTemplateId() {
        return this.entryRecord.getTemplateId();
    }

    @Override
    public void setTemplateId(String templateId) {
        this.entryRecord.setTemplateId(templateId);
    }

    @Override
    public Integer getSequence() {
        return this.entryRecord.getSequence();
    }

    @Override
    public void setSequence(Integer sequence) {
        this.entryRecord.setSequence(sequence);
    }

    @Override
    public String getArchetypeId() {
        return this.entryRecord.getArchetypeId();
    }

    @Override
    public String getRmVersion() {
        return this.entryRecord.getRmVersion();
    }

    @Override
    public String getItemType() {
        return this.entryRecord.getItemType().getLiteral();
    }

    @Override
    public void setCompositionData(Composition composition) {
        this.setCompositionFields(this.entryRecord, composition);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

