/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.dao.access.interfaces.I_AttestationAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.jooq.AttestationAccess;
import org.ehrbase.response.ehrscape.CompositionDto;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.serialisation.flatencoding.FlatFormat;
import org.ehrbase.serialisation.flatencoding.FlatJasonProvider;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.serialisation.xmlencoding.CanonicalXML;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.templateprovider.TemplateProvider;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompositionServiceImp
extends BaseServiceImp
implements CompositionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationService validationService;
    private final KnowledgeCacheService knowledgeCacheService;
    private final EhrService ehrService;

    public CompositionServiceImp(KnowledgeCacheService knowledgeCacheService, ValidationService validationService, EhrService ehrService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.validationService = validationService;
        this.ehrService = ehrService;
        this.knowledgeCacheService = knowledgeCacheService;
    }

    public Optional<CompositionDto> create(UUID ehrId, Composition objData, UUID systemId, UUID committerId, String description) {
        UUID compositionId = this.internalCreate(ehrId, objData, systemId, committerId, description, null);
        return this.getCompositionDto(I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId));
    }

    public Optional<CompositionDto> create(UUID ehrId, Composition objData, UUID contribution) {
        UUID compositionId = this.internalCreate(ehrId, objData, null, null, null, contribution);
        return this.getCompositionDto(I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId));
    }

    public Optional<CompositionDto> create(UUID ehrId, Composition objData) {
        return this.create(ehrId, objData, this.getSystemUuid(), this.getUserUuid(), null);
    }

    private UUID internalCreate(UUID ehrId, Composition composition, UUID systemId, UUID committerId, String description, UUID contributionId) {
        UUID compositionId;
        try {
            this.validationService.check(composition);
        }
        catch (org.ehrbase.validation.ValidationException e) {
            throw new UnprocessableEntityException(e.getMessage());
        }
        catch (UnprocessableEntityException | ValidationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException((Exception)e);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (!this.ehrService.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.getNewInstance(this.getDataAccess(), composition, ehrId);
            I_EntryAccess entryAccess = I_EntryAccess.getNewInstance(this.getDataAccess(), Objects.requireNonNull(composition.getArchetypeDetails().getTemplateId()).getValue(), 0, compositionAccess.getId(), composition);
            compositionAccess.addContent(entryAccess);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                compositionId = compositionAccess.commit(LocalDateTime.now(), contributionId);
            } else {
                if (committerId == null || systemId == null) {
                    throw new InternalServerException("Error on internal contribution handling for composition creation.");
                }
                compositionId = compositionAccess.commit(LocalDateTime.now(), committerId, systemId, description);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        this.logger.debug("Composition created: id={}", (Object)compositionId);
        return compositionId;
    }

    public Optional<CompositionDto> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData, UUID systemId, UUID committerId, String description) {
        ObjectVersionId compoId = this.internalUpdate(UUID.fromString(targetObjId.getObjectId().getValue()), objData, systemId, committerId, description, null);
        return this.getCompositionDto(I_CompositionAccess.retrieveInstance(this.getDataAccess(), UUID.fromString(compoId.getObjectId().getValue())));
    }

    public Optional<CompositionDto> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData, UUID contribution) {
        ObjectVersionId compoId = this.internalUpdate(UUID.fromString(targetObjId.getObjectId().getValue()), objData, null, null, null, contribution);
        return this.getCompositionDto(I_CompositionAccess.retrieveInstance(this.getDataAccess(), UUID.fromString(compoId.getObjectId().getValue())));
    }

    public Optional<CompositionDto> update(UUID ehrId, ObjectVersionId targetObjId, Composition objData) {
        return this.update(ehrId, targetObjId, objData, this.getSystemUuid(), this.getUserUuid(), null);
    }

    private ObjectVersionId internalUpdate(UUID compositionId, Composition composition, UUID systemId, UUID committerId, String description, UUID contributionId) {
        boolean result;
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
            if (compositionAccess == null) {
                throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition: " + compositionId);
            }
            this.validationService.check(composition);
            String existingTemplateId = compositionAccess.getContent().get(0).getTemplateId();
            String inputTemplateId = composition.getArchetypeDetails().getTemplateId().getValue();
            if (!existingTemplateId.equals(inputTemplateId)) {
                if (!existingTemplateId.split("\\.")[0].equals(inputTemplateId.split("\\.")[0])) {
                    throw new InvalidApiParameterException("Can't update composition to have different template.");
                }
                int existingTemplateIdVersion = Integer.parseInt(existingTemplateId.split("\\.v")[1]);
                int inputTemplateIdVersion = Integer.parseInt(inputTemplateId.substring(inputTemplateId.lastIndexOf("\\.v") + 1));
                if (inputTemplateIdVersion < existingTemplateIdVersion) {
                    throw new InvalidApiParameterException("Can't update composition with wrong template version bump.");
                }
            }
            List<I_EntryAccess> contentList = compositionAccess.getContent();
            contentList.get(0).setCompositionData(composition);
            compositionAccess.setContent(contentList);
            compositionAccess.setComposition(composition);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                result = compositionAccess.update(LocalDateTime.now(), contributionId);
            } else {
                if (committerId == null || systemId == null) {
                    throw new InternalServerException("Failed to update composition, missing mandatory audit meta data.");
                }
                result = compositionAccess.update(LocalDateTime.now(), committerId, systemId, description, I_ConceptAccess.ContributionChangeType.MODIFICATION);
            }
        }
        catch (InvalidApiParameterException | ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (!result) {
            throw new InternalServerException("Update failed on composition:" + compositionId);
        }
        return new ObjectVersionId(compositionId.toString(), this.getServerConfig().getNodename(), this.getLastVersionNumber(compositionId).toString());
    }

    public boolean delete(UUID ehrId, ObjectVersionId targetObjId, UUID systemId, UUID committerId, String description) {
        return this.internalDelete(UUID.fromString(targetObjId.getObjectId().getValue()), systemId, committerId, description, null);
    }

    public boolean delete(UUID ehrId, ObjectVersionId targetObjId, UUID contribution) {
        return this.internalDelete(UUID.fromString(targetObjId.getObjectId().getValue()), null, null, null, contribution);
    }

    public boolean delete(UUID ehrId, ObjectVersionId targetObjId) {
        return this.delete(ehrId, targetObjId, this.getSystemUuid(), this.getUserUuid(), null);
    }

    private boolean internalDelete(UUID compositionId, UUID systemId, UUID committerId, String description, UUID contributionId) {
        int result;
        I_CompositionAccess compositionAccess;
        try {
            compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Error while retrieving composition", (Throwable)e);
        }
        if (compositionAccess == null) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition:" + compositionId);
        }
        if (contributionId != null) {
            compositionAccess.setContributionId(contributionId);
            try {
                result = compositionAccess.delete(LocalDateTime.now(), contributionId);
            }
            catch (Exception e) {
                throw new InternalServerException(e);
            }
        }
        try {
            if (committerId == null || systemId == null) {
                throw new InternalServerException("Failed to update composition, missing mandatory audit meta data.");
            }
            result = compositionAccess.delete(LocalDateTime.now(), committerId, systemId, description);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (result <= 0) {
            throw new InternalServerException("Delete failed on composition:" + compositionAccess.getId());
        }
        return true;
    }

    public Optional<CompositionDto> retrieve(UUID compositionId, Integer version) throws InternalServerException {
        I_CompositionAccess compositionAccess = version != null ? I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, version) : I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, this.getLastVersionNumber(compositionId));
        return this.getCompositionDto(compositionAccess);
    }

    public Optional<CompositionDto> retrieveByTimestamp(UUID compositionId, LocalDateTime timestamp) {
        I_CompositionAccess compositionAccess;
        try {
            compositionAccess = I_CompositionAccess.retrieveInstanceByTimestamp(this.getDataAccess(), compositionId, Timestamp.valueOf(timestamp));
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        return this.getCompositionDto(compositionAccess);
    }

    private Optional<CompositionDto> getCompositionDto(I_CompositionAccess compositionAccess) {
        if (compositionAccess == null) {
            return Optional.empty();
        }
        UUID ehrId = compositionAccess.getEhrid();
        return compositionAccess.getContent().stream().findAny().map(i -> new CompositionDto(i.getComposition(), i.getTemplateId(), i.getCompositionId(), ehrId));
    }

    public StructuredString serialize(CompositionDto composition, CompositionFormat format) {
        StructuredString compositionString;
        switch (format) {
            case XML: {
                compositionString = new StructuredString(new CanonicalXML().marshal((RMObject)composition.getComposition(), Boolean.valueOf(false)), StructuredStringFormat.XML);
                break;
            }
            case JSON: {
                compositionString = new StructuredString(new CanonicalJson().marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
                break;
            }
            case FLAT: {
                compositionString = new StructuredString(new FlatJasonProvider(new TemplateProvider(){

                    public Optional<OPERATIONALTEMPLATE> find(String s) {
                        return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                    }

                    public Optional<WebTemplate> buildIntrospect(String templateId) {
                        return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                    }
                }).buildFlatJson(FlatFormat.SIM_SDT, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
                break;
            }
            case STRUCTURED: {
                compositionString = new StructuredString(new FlatJasonProvider(new TemplateProvider(){

                    public Optional<OPERATIONALTEMPLATE> find(String s) {
                        return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                    }

                    public Optional<WebTemplate> buildIntrospect(String templateId) {
                        return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                    }
                }).buildFlatJson(FlatFormat.STRUCTURED, composition.getTemplateId()).marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return compositionString;
    }

    public Composition buildComposition(String content, CompositionFormat format, String templateId) {
        Composition composition;
        switch (format) {
            case XML: {
                composition = (Composition)new CanonicalXML().unmarshal(content, Composition.class);
                break;
            }
            case JSON: {
                composition = (Composition)new CanonicalJson().unmarshal(content, Composition.class);
                break;
            }
            case FLAT: {
                composition = new FlatJasonProvider(new TemplateProvider(){

                    public Optional<OPERATIONALTEMPLATE> find(String s) {
                        return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                    }

                    public Optional<WebTemplate> buildIntrospect(String templateId) {
                        return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                    }
                }).buildFlatJson(FlatFormat.SIM_SDT, templateId).unmarshal(content);
                break;
            }
            case STRUCTURED: {
                composition = new FlatJasonProvider(new TemplateProvider(){

                    public Optional<OPERATIONALTEMPLATE> find(String s) {
                        return CompositionServiceImp.this.knowledgeCacheService.retrieveOperationalTemplate(s);
                    }

                    public Optional<WebTemplate> buildIntrospect(String templateId) {
                        return Optional.ofNullable(CompositionServiceImp.this.knowledgeCacheService.getQueryOptMetaData(templateId));
                    }
                }).buildFlatJson(FlatFormat.STRUCTURED, templateId).unmarshal(content);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return composition;
    }

    public Integer getLastVersionNumber(UUID compositionId) throws InternalServerException {
        try {
            return I_CompositionAccess.getLastVersionNumber(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
    }

    public Integer getVersionByTimestamp(UUID compositionId, LocalDateTime timestamp) {
        int version;
        try {
            version = I_CompositionAccess.getVersionFromTimeStamp(this.getDataAccess(), compositionId, Timestamp.valueOf(timestamp));
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (version <= 0) {
            throw new InternalServerException("Invalid version number calculated.");
        }
        return version;
    }

    public String getUidFromInputComposition(String content, CompositionFormat format) throws IllegalArgumentException, InternalServerException, UnexpectedSwitchCaseException {
        Composition composition = this.buildComposition(content, format, null);
        if (composition.getUid() == null) {
            return null;
        }
        return composition.getUid().toString();
    }

    public String getTemplateIdFromInputComposition(String content, CompositionFormat format) {
        Composition composition = this.buildComposition(content, format, null);
        if (composition.getArchetypeDetails() == null || composition.getArchetypeDetails().getTemplateId() == null) {
            return null;
        }
        return composition.getArchetypeDetails().getTemplateId().getValue();
    }

    public boolean exists(UUID versionedObjectId) {
        return I_CompositionAccess.exists(this.getDataAccess(), versionedObjectId);
    }

    public boolean isDeleted(UUID versionedObjectId) {
        return I_CompositionAccess.isDeleted(this.getDataAccess(), versionedObjectId);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDelete(UUID compositionId) {
        I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
        if (compositionAccess != null) {
            compositionAccess.adminDelete();
        }
    }

    public VersionedComposition getVersionedComposition(UUID ehrId, UUID composition) {
        Optional<CompositionDto> dto = this.retrieve(composition, 1);
        VersionedComposition compo = new VersionedComposition();
        if (dto.isPresent()) {
            compo.setUid(new HierObjectId(dto.get().getUuid().toString()));
            compo.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(dto.get().getEhrId().toString()), "local", "ehr"));
            Map<Integer, I_CompositionAccess> compos = I_CompositionAccess.getVersionMapOfComposition(this.getDataAccess(), composition);
            if (compos.containsKey(1)) {
                compo.setTimeCreated(new DvDateTime((TemporalAccessor)OffsetDateTime.of(compos.get(1).getSysTransaction().toLocalDateTime(), OffsetDateTime.now().getOffset())));
            } else {
                throw new InternalServerException("Inconsistent composition data, no version 1 available");
            }
        }
        return compo;
    }

    public RevisionHistory getRevisionHistoryOfVersionedComposition(UUID composition) {
        int versions = this.getLastVersionNumber(composition);
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<Composition>> compoVersion = this.getOriginalVersionComposition(composition, i);
            compoVersion.ifPresent(compositionOriginalVersion -> revisionHistory.addItem(this.revisionHistoryItemFromComposition((OriginalVersion<Composition>)compositionOriginalVersion)));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromComposition(OriginalVersion<Composition> composition) {
        ObjectVersionId objectVersionId = composition.getUid();
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(composition.getCommitAudit());
        if (composition.getAttestations() != null) {
            for (Attestation a : composition.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    public Optional<OriginalVersion<Composition>> getOriginalVersionComposition(UUID versionedObjectUid, int version) {
        if (version == 0 || I_CompositionAccess.getLastVersionNumber(this.getDataAccess(), versionedObjectUid) < version) {
            throw new ObjectNotFoundException("versioned_composition", "No VERSIONED_COMPOSITION with given version: " + version);
        }
        I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), versionedObjectUid, version);
        if (compositionAccess == null) {
            return Optional.empty();
        }
        ObjectVersionId versionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + version);
        DvCodedText lifecycleState = new DvCodedText("complete", new CodePhrase("532"));
        AuditDetails commitAudit = compositionAccess.getAuditDetailsAccess().getAsAuditDetails();
        ObjectRef contribution = new ObjectRef((ObjectId)new HierObjectId(compositionAccess.getContributionId().toString()), "openehr", "contribution");
        List<UUID> attestationIdList = I_AttestationAccess.retrieveListOfAttestationsByRef(this.getDataAccess(), compositionAccess.getAttestationRef());
        ArrayList<Attestation> attestations = null;
        if (!attestationIdList.isEmpty()) {
            attestations = new ArrayList<Attestation>();
            for (UUID id : attestationIdList) {
                I_AttestationAccess a = new AttestationAccess(this.getDataAccess()).retrieveInstance(id);
                attestations.add(a.getAsAttestation());
            }
        }
        ObjectVersionId precedingVersionId = null;
        if (version > 1) {
            precedingVersionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + (version - 1));
        }
        Optional<CompositionDto> compositionDto = this.retrieve(versionedObjectUid, version);
        Composition composition = null;
        if (compositionDto.isPresent()) {
            composition = compositionDto.get().getComposition();
        }
        OriginalVersion versionComposition = new OriginalVersion(versionId, precedingVersionId, (Object)composition, lifecycleState, commitAudit, contribution, null, null, attestations);
        return Optional.of(versionComposition);
    }
}

