/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.dao.access.interfaces.I_AttestationAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.AttestationAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRef;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.EhrStatusDto;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.util.PartyUtils;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ehrService")
@Transactional
public class EhrServiceImp
extends BaseServiceImp
implements EhrService {
    public static final String DESCRIPTION = "description";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValidationService validationService;
    private UUID emptyParty;

    @Autowired
    public EhrServiceImp(KnowledgeCacheService knowledgeCacheService, ValidationService validationService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.validationService = validationService;
    }

    @PostConstruct
    public void init() {
        this.emptyParty = new PersistedPartyProxy(this.getDataAccess()).getOrCreate((PartyProxy)new PartySelf());
    }

    public UUID create(EhrStatus status, UUID ehrId) {
        UUID subjectUuid;
        try {
            this.validationService.check(status);
        }
        catch (Exception e) {
            if (e.getClass().equals(UnprocessableEntityException.class)) {
                throw (UnprocessableEntityException)((Object)e);
            }
            if (e.getClass().equals(IllegalArgumentException.class)) {
                throw new ValidationException(e);
            }
            if (e.getClass().equals(ValidationException.class)) {
                throw e;
            }
            throw new InternalServerException(e);
        }
        if (status == null) {
            status = new EhrStatus();
            status.setSubject(new PartySelf(null));
            status.setModifiable(true);
            status.setQueryable(true);
        }
        status.setUid((UIDBasedId)new HierObjectId(UUID.randomUUID().toString()));
        if (PartyUtils.isEmpty(status.getSubject())) {
            subjectUuid = this.emptyParty;
        } else {
            subjectUuid = new PersistedPartyProxy(this.getDataAccess()).getOrCreate((PartyProxy)status.getSubject());
            if (I_EhrAccess.checkExist(this.getDataAccess(), subjectUuid)) {
                throw new StateConflictException("Specified party has already an EHR set (partyId=" + subjectUuid + ")");
            }
        }
        UUID systemId = this.getSystemUuid();
        UUID committerId = this.getUserUuid();
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.getInstance(this.getDataAccess(), subjectUuid, systemId, null, null, ehrId);
            ehrAccess.setStatus(status);
            return ehrAccess.commit(committerId, systemId, DESCRIPTION);
        }
        catch (Exception e) {
            throw new InternalServerException("Could not create an EHR with given parameters.", e);
        }
    }

    public Optional<EhrStatusDto> getEhrStatusEhrScape(UUID ehrUuid, CompositionFormat format) {
        EhrStatusDto statusDto = new EhrStatusDto();
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUuid);
            if (ehrAccess == null) {
                return Optional.empty();
            }
            PartyProxy partyProxy = new PersistedPartyProxy(this.getDataAccess()).retrieve(ehrAccess.getParty());
            statusDto.setSubjectId(partyProxy.getExternalRef().getId().getValue());
            statusDto.setSubjectNamespace(partyProxy.getExternalRef().getNamespace());
            statusDto.setModifiable(ehrAccess.isModifiable().booleanValue());
            statusDto.setQueryable(ehrAccess.isQueryable().booleanValue());
            statusDto.setOtherDetails(new StructuredString(new CanonicalJson().marshal((RMObject)ehrAccess.getOtherDetails()), StructuredStringFormat.JSON));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
        return Optional.of(statusDto);
    }

    public Optional<EhrStatus> getEhrStatus(UUID ehrUuid) {
        if (!this.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUuid);
            if (ehrAccess == null) {
                return Optional.empty();
            }
            return Optional.of(ehrAccess.getStatus());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
    }

    public Optional<OriginalVersion<EhrStatus>> getEhrStatusAtVersion(UUID ehrUuid, UUID versionedObjectUid, int version) {
        if (!this.hasEhr(ehrUuid)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        if (version == 0 || I_StatusAccess.getLatestVersionNumber(this.getDataAccess(), versionedObjectUid) < version) {
            throw new ObjectNotFoundException("versioned_ehr_status", "No VERSIONED_EHR_STATUS with given version: " + version);
        }
        I_StatusAccess statusAccess = I_StatusAccess.getVersionMapOfStatus(this.getDataAccess(), versionedObjectUid).get(version);
        ObjectVersionId versionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + version);
        DvCodedText lifecycleState = new DvCodedText("complete", new CodePhrase("532"));
        AuditDetails commitAudit = statusAccess.getAuditDetailsAccess().getAsAuditDetails();
        ObjectRef contribution = new ObjectRef((ObjectId)new HierObjectId(statusAccess.getStatusRecord().getInContribution().toString()), "openehr", "contribution");
        List<UUID> attestationIdList = I_AttestationAccess.retrieveListOfAttestationsByRef(this.getDataAccess(), statusAccess.getStatusRecord().getAttestationRef());
        ArrayList<Attestation> attestations = null;
        if (!attestationIdList.isEmpty()) {
            attestations = new ArrayList<Attestation>();
            for (UUID id : attestationIdList) {
                I_AttestationAccess a = new AttestationAccess(this.getDataAccess()).retrieveInstance(id);
                attestations.add(a.getAsAttestation());
            }
        }
        ObjectVersionId precedingVersionId = null;
        if (version > 1) {
            precedingVersionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + (version - 1));
        }
        OriginalVersion versionStatus = new OriginalVersion(versionId, precedingVersionId, (Object)statusAccess.getStatus(), lifecycleState, commitAudit, contribution, null, null, attestations);
        return Optional.of(versionStatus);
    }

    public Optional<EhrStatus> updateStatus(UUID ehrId, EhrStatus status, UUID contributionId) {
        I_EhrAccess ehrAccess;
        try {
            this.validationService.check(status);
        }
        catch (Exception e) {
            if (e.getClass().equals(UnprocessableEntityException.class)) {
                throw (UnprocessableEntityException)((Object)e);
            }
            if (e.getClass().equals(IllegalArgumentException.class)) {
                throw new ValidationException(e);
            }
            if (e.getClass().equals(ValidationException.class)) {
                throw e;
            }
            throw new InternalServerException(e);
        }
        if (!this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (ehrAccess == null) {
            return Optional.empty();
        }
        if (status != null) {
            ehrAccess.setStatus(status);
        }
        if (ehrAccess.update(this.getUserUuid(), this.getSystemUuid(), contributionId, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, DESCRIPTION).equals(false)) {
            throw new InternalServerException("Problem updating EHR_STATUS");
        }
        return this.getEhrStatus(ehrId);
    }

    public Optional<UUID> findBySubject(String subjectId, String nameSpace) {
        UUID subjectUuid = new PersistedPartyRef(this.getDataAccess()).findInDB(subjectId, nameSpace);
        return Optional.ofNullable(I_EhrAccess.retrieveInstanceBySubject(this.getDataAccess(), subjectUuid));
    }

    public boolean doesEhrExist(UUID ehrId) {
        Optional<I_EhrAccess> ehrAccess = Optional.ofNullable(I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId));
        return ehrAccess.isPresent();
    }

    public DvDateTime getCreationTime(UUID ehrId) {
        if (!this.hasEhr(ehrId)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
            OffsetDateTime offsetDateTime = OffsetDateTime.from(LocalDateTime.from(ehrAccess.getEhrRecord().getDateCreated().toLocalDateTime()).atZone(ZoneId.of(ehrAccess.getEhrRecord().getDateCreatedTzid())));
            return new DvDateTime((TemporalAccessor)offsetDateTime);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
    }

    public Integer getEhrStatusVersionByTimestamp(UUID ehrUid, Timestamp timestamp) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        return ehrAccess.getStatusAccess().getEhrStatusVersionFromTimeStamp(timestamp);
    }

    public String getLatestVersionUidOfStatus(UUID ehrStatusId) {
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrStatusId);
            UUID statusId = ehrAccess.getStatusId();
            Integer version = I_StatusAccess.getLatestVersionNumber(this.getDataAccess(), statusId);
            return statusId.toString() + "::" + this.getServerConfig().getNodename() + "::" + version;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
    }

    public UUID getEhrStatusVersionedObjectUidByEhr(UUID ehrUid) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        return ehrAccess.getStatusId();
    }

    public boolean hasEhr(UUID ehrId) {
        return I_EhrAccess.hasEhr(this.getDataAccess(), ehrId);
    }

    public boolean hasStatus(UUID statusId) {
        return I_StatusAccess.exists(this.getDataAccess(), statusId);
    }

    public VersionedEhrStatus getVersionedEhrStatus(UUID ehrUid) {
        Optional<EhrStatus> ehrStatus = this.getEhrStatus(ehrUid);
        VersionedEhrStatus versionedEhrStatus = new VersionedEhrStatus();
        if (ehrStatus.isPresent()) {
            versionedEhrStatus.setUid(new HierObjectId(ehrStatus.get().getUid().getRoot().getValue()));
            versionedEhrStatus.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(ehrUid.toString()), "local", "EHR"));
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
            versionedEhrStatus.setTimeCreated(new DvDateTime((TemporalAccessor)OffsetDateTime.of(ehrAccess.getStatusAccess().getInitialTimeOfVersionedEhrStatus().toLocalDateTime(), OffsetDateTime.now().getOffset())));
        }
        return versionedEhrStatus;
    }

    public RevisionHistory getRevisionHistoryOfVersionedEhrStatus(UUID ehrUid) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        int versions = I_StatusAccess.getLatestVersionNumber(this.getDataAccess(), ehrAccess.getStatusId());
        UUID versionedObjectUid = this.getEhrStatusVersionedObjectUidByEhr(ehrUid);
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<EhrStatus>> ehrStatus = this.getEhrStatusAtVersion(ehrUid, versionedObjectUid, i);
            if (!ehrStatus.isPresent()) continue;
            revisionHistory.addItem(this.revisionHistoryItemFromEhrStatus(ehrStatus.get(), i));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemFromEhrStatus(OriginalVersion<EhrStatus> ehrStatus, int version) {
        String statusId = ehrStatus.getUid().getValue().split("::")[0];
        ObjectVersionId objectVersionId = new ObjectVersionId(statusId + "::" + this.getServerConfig().getNodename() + "::" + version);
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        auditDetailsList.add(ehrStatus.getCommitAudit());
        if (ehrStatus.getAttestations() != null) {
            for (Attestation a : ehrStatus.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    public UUID getDirectoryId(UUID ehrId) {
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
            return ehrAccess.getDirectoryId();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InternalServerException(e.getMessage(), e);
        }
    }

    public boolean removeDirectory(UUID ehrId) {
        try {
            return I_EhrAccess.removeDirectory(this.getDataAccess(), ehrId);
        }
        catch (Exception e) {
            this.logger.error(String.format("Could not remove directory from EHR with id %s.\nReason: %s", ehrId.toString(), e.getMessage()));
            throw new InternalServerException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteEhr(UUID ehrId) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        ehrAccess.adminDeleteEhr();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminPurgePartyIdentified() {
        this.getDataAccess().getContext().deleteFrom((Table)Tables.PARTY_IDENTIFIED).where(Routines.partyUsage((Field)Tables.PARTY_IDENTIFIED.ID).eq((Object)0L)).execute();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteOrphanHistory() {
        Routines.deleteOrphanHistory((Configuration)this.getDataAccess().getContext().configuration());
    }

    public UUID getSubjectUuid(String ehrId) {
        Optional<EhrStatus> status = this.getEhrStatus(UUID.fromString(ehrId));
        return status.map(ehrStatus -> new PersistedPartyProxy(this.getDataAccess()).getOrCreate((PartyProxy)ehrStatus.getSubject())).orElse(null);
    }

    public String getSubjectExtRef(String ehrId) {
        return Optional.ofNullable(new PersistedPartyProxy(this.getDataAccess()).retrieve(this.getSubjectUuid(ehrId)).getExternalRef()).map(p -> p.getId().getValue()).orElse(null);
    }
}

