/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ehrbase.aql.sql.queryimpl.IIterativeNode;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.ehr.util.LocatableHelper;
import org.ehrbase.service.IntrospectService;

public class IterativeNode
implements IIterativeNode {
    private List<String> ignoreIterativeNode;
    private final List<String> unbounded;
    private Integer depth;
    private final I_DomainAccess domainAccess;

    public IterativeNode(I_DomainAccess domainAccess, String templateId, IntrospectService introspectCache) {
        this.domainAccess = domainAccess;
        this.unbounded = introspectCache.multiValued(templateId);
        this.initAqlRuntimeParameters();
    }

    public Integer[] iterativeAt(List<String> segmentedPath) {
        TreeSet<Integer> retarray = new TreeSet<Integer>();
        if (this.unbounded.isEmpty()) {
            retarray.add(-1);
        } else {
            String path = "/" + String.join((CharSequence)"/", this.compact(segmentedPath));
            for (int i = this.unbounded.size() - 1; i >= 0; --i) {
                String aqlPath = this.unbounded.get(i);
                List<String> aqlPathSegments = LocatableHelper.dividePathIntoSegments(aqlPath);
                boolean ignoreThisAqlPath = false;
                if (this.ignoreIterativeNode != null && !this.ignoreIterativeNode.isEmpty()) {
                    for (String ignoreItemRegex : this.ignoreIterativeNode) {
                        if (!aqlPathSegments.get(aqlPathSegments.size() - 1).matches("^" + ignoreItemRegex + ".*")) continue;
                        ignoreThisAqlPath = true;
                        break;
                    }
                }
                if (ignoreThisAqlPath || !path.startsWith(aqlPath) || aqlPath.matches("^.*(value|name)$")) continue;
                int pos = this.aqlPathInJsonbArray(aqlPathSegments, segmentedPath);
                retarray.add(pos);
                if (retarray.size() >= this.depth) break;
            }
        }
        return retarray.toArray(new Integer[0]);
    }

    public List<String> clipInIterativeMarker(List<String> segmentedPath, Integer[] clipPos) {
        ArrayList<String> resultingPath = new ArrayList<String>(segmentedPath);
        Arrays.stream(clipPos).sorted(Comparator.reverseOrder()).collect(Collectors.toList()).forEach(pos -> {
            if (pos.intValue() == resultingPath.size()) {
                resultingPath.add("$AQL_NODE_ITERATIVE$");
            } else if (!((String)resultingPath.get((int)pos)).equals("$AQL_NODE_NAME_PREDICATE$")) {
                if (((String)resultingPath.get((int)pos)).equals("0")) {
                    resultingPath.set((int)pos, "$AQL_NODE_ITERATIVE$");
                } else {
                    resultingPath.add((int)pos, "$AQL_NODE_ITERATIVE$");
                }
            }
        });
        return resultingPath;
    }

    List<String> compact(List<String> segmentedPath) {
        ArrayList<String> resultPath = new ArrayList<String>();
        for (String item : segmentedPath) {
            try {
                Integer.parseInt(item);
            }
            catch (Exception e) {
                if (item.startsWith("/composition")) continue;
                if (item.startsWith("/")) {
                    if (item.equals("/events") || item.equals("/activities")) continue;
                    resultPath.add(item.substring(1));
                    continue;
                }
                resultPath.add(item);
            }
        }
        return resultPath;
    }

    int aqlPathInJsonbArray(List<String> aqlSegmented, List<String> jsonbSegmented) {
        int retval = 0;
        int aqlSegIndex = 0;
        int i = 0;
        while (aqlSegIndex < aqlSegmented.size()) {
            if (jsonbSegmented.get(i).startsWith("/composition")) {
                ++retval;
            } else {
                try {
                    Integer.parseInt(jsonbSegmented.get(i));
                    ++retval;
                }
                catch (Exception e) {
                    if (jsonbSegmented.get(retval).equals("/events") || jsonbSegmented.get(retval).equals("/activities")) {
                        ++retval;
                    }
                    try {
                        if (jsonbSegmented.get(retval).startsWith("/") ? !$assertionsDisabled && !jsonbSegmented.get(retval).substring(1).equals(aqlSegmented.get(aqlSegIndex)) : !$assertionsDisabled && !jsonbSegmented.get(retval).equals(aqlSegmented.get(aqlSegIndex))) {
                            throw new AssertionError();
                        }
                    }
                    catch (Exception e1) {
                        throw new IllegalArgumentException("Drift in locating array marker: aql:" + aqlSegmented.get(aqlSegIndex) + ", jsonb:" + jsonbSegmented.get(retval) + ", @index:" + retval);
                    }
                    ++retval;
                    ++aqlSegIndex;
                }
            }
            ++i;
        }
        return retval;
    }

    private void initAqlRuntimeParameters() {
        this.ignoreIterativeNode = new ArrayList<String>();
        if (System.getenv("aql.ignoreIterativeNodeList") != null) {
            this.ignoreIterativeNode = Arrays.asList(System.getenv("aql.ignoreIterativeNodeList").split(","));
        } else if (this.domainAccess.getServerConfig().getAqlIterationSkipList() != null && !this.domainAccess.getServerConfig().getAqlIterationSkipList().isBlank()) {
            this.ignoreIterativeNode.addAll(Arrays.asList(this.domainAccess.getServerConfig().getAqlIterationSkipList().split(",")));
        } else {
            this.ignoreIterativeNode = Arrays.asList("^/content.*", "^/events.*");
        }
        this.depth = System.getenv("aql.iterationScanDepth") != null ? Integer.valueOf(Integer.parseInt(System.getenv("aql.iterationScanDepth"))) : (this.domainAccess.getServerConfig().getAqlDepth() != null ? this.domainAccess.getServerConfig().getAqlDepth() : Integer.valueOf(1));
    }

    public List<String> iterativeForArrayAttributeValues(List<String> itemPathArray) {
        ArrayList<String> resultingPath = new ArrayList<String>();
        for (String node : itemPathArray) {
            if (node.contains("feeder_system_item_ids")) {
                List<String> faItems = Arrays.asList((String[])node.split(",").clone());
                if (faItems.size() > 2) {
                    for (String faNode : faItems) {
                        resultingPath.add(faNode);
                        if (!faNode.equals("feeder_system_item_ids")) continue;
                        resultingPath.add("$AQL_NODE_ITERATIVE$");
                    }
                    continue;
                }
                resultingPath.add(node);
                continue;
            }
            resultingPath.add(node);
        }
        return resultingPath;
    }
}

