/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.plugin;

import com.nedap.archie.rm.composition.Composition;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.plugin.dto.CompositionWithEhrId;
import org.ehrbase.plugin.extensionpoints.CompositionExtensionPointInterface;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;

@Component
@Aspect
@ConditionalOnProperty(prefix="plugin-manager", name={"enable"}, havingValue="true")
public class PluginAspect {
    public static final Comparator<Map.Entry<String, CompositionExtensionPointInterface>> EXTENSION_POINTS_COMPARATOR = ((Comparator)(e1, e2) -> AnnotationAwareOrderComparator.INSTANCE.compare(e1.getValue(), e2.getValue())).reversed().thenComparing(Map.Entry::getKey);
    private final ListableBeanFactory beanFactory;

    public PluginAspect(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Around(value="execution(* org.ehrbase.api.service.CompositionService.create(..))")
    public Object aroundCreateComposition(ProceedingJoinPoint pjp) {
        Chain<1> chain = this.buildChain(this.getCompositionExtensionPointInterfaceList(), new CompositionExtensionPointInterface(){});
        Object[] args = pjp.getArgs();
        CompositionWithEhrId input = new CompositionWithEhrId((Composition)args[1], (UUID)args[0]);
        return Optional.of(this.handleChain(chain, l -> (arg_0, arg_1) -> ((CompositionExtensionPointInterface)l).aroundCreation(arg_0, arg_1), input, i -> {
            args[1] = i.getComposition();
            args[0] = i.getEhrId();
            return (UUID)((Optional)this.proceed(pjp, args)).orElseThrow();
        }));
    }

    private Object proceed(ProceedingJoinPoint pjp, Object[] args) {
        try {
            return pjp.proceed(args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException("Expedition in Plugin Aspect ", e);
        }
        catch (Throwable e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    private List<CompositionExtensionPointInterface> getCompositionExtensionPointInterfaceList() {
        return this.beanFactory.getBeansOfType(CompositionExtensionPointInterface.class).entrySet().stream().sorted(EXTENSION_POINTS_COMPARATOR).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private <T> Chain<T> buildChain(Collection<T> extensionPointInterfaceList, T identity) {
        Chain chain = new Chain();
        chain.current = identity;
        Chain first = chain;
        for (T point : extensionPointInterfaceList) {
            Chain next = new Chain();
            next.current = point;
            chain.next = next;
            chain = next;
        }
        return first;
    }

    private <X, R, T> R handleChain(Chain<T> chain, Function<T, BiFunction<X, Function<X, R>, R>> around, X input, Function<X, R> compositionFunction) {
        if (chain.next != null) {
            return (R)this.handleChain(chain.next, around, input, i -> ((BiFunction)around.apply(chain.current)).apply(i, compositionFunction));
        }
        return around.apply(chain.current).apply(input, compositionFunction);
    }

    private static class Chain<T> {
        T current;
        Chain<T> next;

        private Chain() {
        }
    }
}

