/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.aql.containment.TemplateIdAqlTuple;
import org.ehrbase.aql.containment.TemplateIdQueryTuple;
import org.ehrbase.aql.sql.queryimpl.ItemInfo;
import org.ehrbase.cache.CacheOptions;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.util.TemplateUtils;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.NodeId;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KnowledgeCacheService
implements I_KnowledgeCache,
IntrospectService {
    public static final String ELEMENT = "ELEMENT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private final CacheOptions cacheOptions;
    private final Cache jsonPathQueryResultCache;
    private final Cache webTemplateCache;
    private final Cache fieldCache;
    private final Cache multivaluedCache;
    private final Map<UUID, String> idxCacheUuidToTemplateId = new ConcurrentHashMap<UUID, String>();
    private final Map<String, UUID> idxCacheTemplateIdToUuid = new ConcurrentHashMap<String, UUID>();
    @Value(value="${system.allow-template-overwrite:false}")
    private boolean allowTemplateOverwrite;

    public KnowledgeCacheService(TemplateStorage templateStorage, CacheManager cacheManager, CacheOptions cacheOptions) {
        this.templateStorage = templateStorage;
        this.cacheOptions = cacheOptions;
        this.webTemplateCache = cacheManager.getCache("introspectCache");
        this.jsonPathQueryResultCache = cacheManager.getCache("queryCache");
        this.fieldCache = cacheManager.getCache("fieldsCache");
        this.multivaluedCache = cacheManager.getCache("multivaluedCache");
    }

    public void initializeCaches() {
        HashSet<String> templateIds = new HashSet<String>();
        for (TemplateMetaData metadata : this.listAllOperationalTemplates()) {
            OPERATIONALTEMPLATE template = metadata.getOperationaltemplate();
            String templateId = TemplateUtils.getTemplateId(template);
            templateIds.add(templateId);
            try {
                this.putIntoCache(template);
            }
            catch (RuntimeException e) {
                this.log.error("An error occurred while caching template: {}", (Object)templateId, (Object)e);
            }
        }
        if (this.cacheOptions.isPreBuildQueries()) {
            ExecutorService executor = Executors.newFixedThreadPool(1);
            executor.submit(() -> {
                for (String templateId : templateIds) {
                    try {
                        this.precalculateQueries(templateId);
                    }
                    catch (RuntimeException e) {
                        this.log.error("An error occurred while calculating queries for template: {}", (Object)templateId, (Object)e);
                    }
                }
            });
        }
    }

    @Override
    public Set<String> getAllTemplateIds() {
        return this.templateStorage.findAllTemplateIds();
    }

    @Override
    public String addOperationalTemplate(byte[] content) {
        return this.addOperationalTemplateIntern(content, false);
    }

    public String addOperationalTemplateIntern(byte[] content, boolean overwrite) {
        String templateId;
        TemplateDocument document;
        try {
            document = TemplateDocument.Factory.parse((InputStream)new ByteArrayInputStream(content));
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
        OPERATIONALTEMPLATE template = document.getTemplate();
        this.validateTemplate(template);
        try {
            templateId = TemplateUtils.getTemplateId(template);
        }
        catch (IllegalArgumentException a) {
            throw new InvalidApiParameterException("Invalid template input content");
        }
        if (!this.allowTemplateOverwrite && !overwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists: " + templateId);
        }
        this.invalidateCache(template);
        this.templateStorage.storeTemplate(template);
        this.putIntoCache(template);
        if (this.cacheOptions.isPreBuildQueries()) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
            executor.submit(() -> {
                try {
                    this.precalculateQueries(templateId);
                }
                catch (RuntimeException e) {
                    this.log.error("An error occurred while processing template: {}", (Object)templateId);
                }
            });
        }
        return templateId;
    }

    private void putIntoCache(OPERATIONALTEMPLATE template) {
        String templateId = TemplateUtils.getTemplateId(template);
        UUID uid = TemplateUtils.getUid(template);
        try {
            this.idxCacheUuidToTemplateId.put(uid, templateId);
            this.idxCacheTemplateIdToUuid.put(templateId, uid);
            this.getQueryOptMetaData(templateId);
        }
        catch (RuntimeException e) {
            this.log.error("Invalid template {}", (Object)templateId);
            this.invalidateCache(template);
            throw e;
        }
    }

    private void precalculateQueries(String templateId) {
        this.getQueryOptMetaData(templateId).findAllContainmentCombinations().stream().filter(nodeIds -> !nodeIds.isEmpty() && nodeIds.size() <= this.cacheOptions.getPreBuildQueriesDepth()).forEach(nodeIds -> this.resolveForTemplate(templateId, (Collection<NodeId>)nodeIds));
    }

    public String adminUpdateOperationalTemplate(byte[] content) {
        return this.addOperationalTemplateIntern(content, true);
    }

    private void invalidateCache(OPERATIONALTEMPLATE template) {
        this.webTemplateCache.evict((Object)TemplateUtils.getUid(template));
        this.jsonPathQueryResultCache.invalidate();
        this.fieldCache.invalidate();
        this.multivaluedCache.invalidate();
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStorage.listAllOperationalTemplates();
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        return Optional.ofNullable(this.getOperationaltemplateFromFileStorage(key));
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID uuid) {
        String key = this.findTemplateIdByUuid(uuid);
        if (key == null) {
            return Optional.empty();
        }
        return this.retrieveOperationalTemplate(key);
    }

    @Override
    public boolean deleteOperationalTemplate(OPERATIONALTEMPLATE template) {
        boolean deleted = this.templateStorage.deleteTemplate(template.getTemplateId().getValue());
        if (deleted) {
            this.invalidateCache(template);
        }
        return deleted;
    }

    private String findTemplateIdByUuid(UUID uuid) {
        return this.idxCacheUuidToTemplateId.computeIfAbsent(uuid, templateUuid -> this.listAllOperationalTemplates().stream().filter(t -> t.getErrorList().isEmpty()).filter(t -> t.getOperationaltemplate().getUid().getValue().equals(templateUuid.toString())).map(t -> t.getOperationaltemplate().getTemplateId().getValue()).findFirst().orElse(null));
    }

    private UUID findUuidByTemplateId(String templateId) {
        return this.idxCacheTemplateIdToUuid.computeIfAbsent(templateId, id -> UUID.fromString(this.retrieveOperationalTemplate((String)id).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown template %s", templateId))).getUid().getValue()));
    }

    @Override
    public WebTemplate getQueryOptMetaData(UUID uuid) {
        WebTemplate retval = (WebTemplate)this.webTemplateCache.get((Object)uuid, WebTemplate.class);
        if (retval == null) {
            return this.buildAndCacheQueryOptMetaData(uuid);
        }
        return retval;
    }

    @Override
    public WebTemplate getQueryOptMetaData(String templateId) {
        return this.getQueryOptMetaData(this.findUuidByTemplateId(templateId));
    }

    private WebTemplate buildAndCacheQueryOptMetaData(UUID uuid) {
        Optional<Object> operationaltemplate = Optional.empty();
        try {
            operationaltemplate = this.retrieveOperationalTemplate(uuid);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (!operationaltemplate.isPresent()) {
            throw new IllegalArgumentException("Could not retrieve  knowledgeCacheService.getKnowledgeCache() cache for template Uid:" + uuid);
        }
        WebTemplate retval = this.buildAndCacheQueryOptMetaData((OPERATIONALTEMPLATE)operationaltemplate.get());
        return retval;
    }

    private WebTemplate buildAndCacheQueryOptMetaData(OPERATIONALTEMPLATE operationaltemplate) {
        WebTemplate visitor;
        this.log.info("Updating WebTemplate cache for template: {}", (Object)TemplateUtils.getTemplateId(operationaltemplate));
        try {
            visitor = new OPTParser(operationaltemplate).parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid template: %s", e.getMessage()));
        }
        this.webTemplateCache.put((Object)TemplateUtils.getUid(operationaltemplate), (Object)visitor);
        return visitor;
    }

    private OPERATIONALTEMPLATE getOperationaltemplateFromFileStorage(String filename) {
        Optional<OPERATIONALTEMPLATE> template = this.templateStorage.readOperationaltemplate(filename);
        template.ifPresent(existingTemplate -> this.idxCacheUuidToTemplateId.put(TemplateUtils.getUid(existingTemplate), filename));
        return template.orElse(null);
    }

    public int deleteAllOperationalTemplates() {
        List<TemplateMetaData> templateList = this.templateStorage.listAllOperationalTemplates();
        if (templateList.isEmpty()) {
            return 0;
        }
        int deleted = 0;
        for (TemplateMetaData metaData : templateList) {
            if (!this.deleteOperationalTemplate(metaData.getOperationaltemplate())) continue;
            ++deleted;
        }
        return deleted;
    }

    @Override
    public JsonPathQueryResult resolveForTemplate(String templateId, Collection<NodeId> nodeIds) {
        TemplateIdQueryTuple key = new TemplateIdQueryTuple(templateId, nodeIds);
        JsonPathQueryResult jsonPathQueryResult = (JsonPathQueryResult)this.jsonPathQueryResultCache.get((Object)key, JsonPathQueryResult.class);
        if (jsonPathQueryResult == null) {
            WebTemplate webTemplate = this.getQueryOptMetaData(templateId);
            List<Object> webTemplateNodeList = new ArrayList<WebTemplateNode>();
            webTemplateNodeList.add(webTemplate.getTree());
            for (NodeId nodeId : nodeIds) {
                webTemplateNodeList = webTemplateNodeList.stream().map(n -> n.findMatching(f -> {
                    if (f.getNodeId() == null) {
                        return false;
                    }
                    if (nodeId.getNodeId() == null) {
                        return nodeId.getClassName().equals(new NodeId(f.getNodeId()).getClassName());
                    }
                    return nodeId.equals((Object)new NodeId(f.getNodeId()));
                })).flatMap(Collection::stream).collect(Collectors.toList());
            }
            TreeSet<String> uniquePaths = new TreeSet<String>();
            webTemplateNodeList.stream().map(n -> n.getAqlPath(false)).forEach(uniquePaths::add);
            jsonPathQueryResult = !uniquePaths.isEmpty() ? new JsonPathQueryResult(templateId, uniquePaths) : new JsonPathQueryResult(null, Collections.emptyMap());
            this.jsonPathQueryResultCache.put((Object)key, (Object)jsonPathQueryResult);
        }
        if (jsonPathQueryResult.getTemplateId() != null) {
            return jsonPathQueryResult;
        }
        return null;
    }

    @Override
    public ItemInfo getInfo(String templateId, String aql) {
        TemplateIdAqlTuple key = new TemplateIdAqlTuple(templateId, aql);
        ItemInfo itemInfo = (ItemInfo)this.fieldCache.get((Object)key, ItemInfo.class);
        if (itemInfo == null) {
            WebTemplate webTemplate = this.getQueryOptMetaData(templateId);
            Optional node = webTemplate.findByAqlPath(aql);
            String type = node.isEmpty() ? null : (((WebTemplateNode)node.get()).getRmType().equals(ELEMENT) ? ((WebTemplateNode)((WebTemplateNode)node.get()).getChildren().get(0)).getRmType() : ((WebTemplateNode)node.get()).getRmType());
            String category = node.isEmpty() ? null : (aql.endsWith("/value") ? webTemplate.findByAqlPath(aql.replace("/value", "")).filter(n -> n.getRmType().equals(ELEMENT)).map(n -> ELEMENT).orElse("DATA_STRUCTURE") : "DATA_STRUCTURE");
            itemInfo = new ItemInfo(type, category);
            this.fieldCache.put((Object)key, (Object)itemInfo);
        }
        return itemInfo;
    }

    @Override
    public List<String> multiValued(String templateId) {
        List list = (List)this.multivaluedCache.get((Object)templateId, List.class);
        if (list == null) {
            list = this.getQueryOptMetaData(templateId).multiValued().stream().map(webTemplateNode -> webTemplateNode.getAqlPath(false)).collect(Collectors.toList());
            this.multivaluedCache.put((Object)templateId, list);
        }
        return list;
    }

    @Override
    public I_KnowledgeCache getKnowledge() {
        return this;
    }

    private void validateTemplate(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        if (!TemplateUtils.isSupported(template)) {
            throw new IllegalArgumentException(MessageFormat.format("The supplied template is not supported (unsupported types: {0})", String.join((CharSequence)",", TemplateUtils.UNSUPPORTED_RM_TYPES)));
        }
    }
}

