/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.response.ehrscape.CompositionFormat;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.response.ehrscape.TemplateMetaDataDto;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateServiceImp
extends BaseServiceImp
implements TemplateService {
    private final KnowledgeCacheService knowledgeCacheService;

    public TemplateServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.knowledgeCacheService = Objects.requireNonNull(knowledgeCacheService);
    }

    public List<TemplateMetaDataDto> getAllTemplates() {
        return this.knowledgeCacheService.listAllOperationalTemplates().stream().map(this::mapToDto).collect(Collectors.toList());
    }

    private TemplateMetaDataDto mapToDto(TemplateMetaData data) {
        TemplateMetaDataDto dto = new TemplateMetaDataDto();
        dto.setCreatedOn(data.getCreatedOn());
        Optional<OPERATIONALTEMPLATE> operationalTemplate = Optional.ofNullable(data.getOperationaltemplate());
        dto.setTemplateId((String)operationalTemplate.map(OPERATIONALTEMPLATE::getTemplateId).map(OBJECTID::getValue).orElse(null));
        dto.setArchetypeId((String)operationalTemplate.map(OPERATIONALTEMPLATE::getDefinition).map(CARCHETYPEROOT::getArchetypeId).map(OBJECTID::getValue).orElse(null));
        dto.setConcept((String)operationalTemplate.map(OPERATIONALTEMPLATE::getConcept).orElse(null));
        return dto;
    }

    public StructuredString buildExample(String templateId, CompositionFormat format) {
        return new StructuredString("", StructuredStringFormat.fromCompositionFormat((CompositionFormat)format));
    }

    public WebTemplate findTemplate(String templateId) {
        try {
            return this.knowledgeCacheService.getQueryOptMetaData(templateId);
        }
        catch (NullPointerException e) {
            throw new ObjectNotFoundException("template", "Template with the specified id does not exist", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalServerException("Could not generate web template", e);
        }
    }

    public String findOperationalTemplate(String templateId, OperationalTemplateFormat format) throws ObjectNotFoundException, InvalidApiParameterException, InternalServerException {
        if (format != OperationalTemplateFormat.XML) {
            throw new InvalidApiParameterException("Requested operational template type not supported");
        }
        Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
        return existingTemplate.map(template -> {
            XmlOptions opts = new XmlOptions();
            opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
            return template.xmlText(opts);
        }).orElseThrow(() -> new ObjectNotFoundException("template", "Template with the specified id does not exist"));
    }

    public String create(String content) {
        return this.knowledgeCacheService.addOperationalTemplate(content.getBytes(StandardCharsets.UTF_8));
    }

    public boolean adminDeleteTemplate(String templateId) {
        Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
        if (existingTemplate.isEmpty()) {
            throw new ObjectNotFoundException("ADMIN TEMPLATE", String.format("Operational template with id %s not found.", templateId));
        }
        return this.knowledgeCacheService.deleteOperationalTemplate(existingTemplate.get());
    }

    public String adminUpdateTemplate(String templateId, String content) {
        Optional<OPERATIONALTEMPLATE> existingTemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
        if (existingTemplate.isEmpty()) {
            throw new ObjectNotFoundException("ADMIN TEMPLATE UPDATE", String.format("Template with id %s does not exist", templateId));
        }
        return this.knowledgeCacheService.adminUpdateOperationalTemplate(content.getBytes(StandardCharsets.UTF_8));
    }

    public int adminDeleteAllTemplates() {
        return this.knowledgeCacheService.deleteAllOperationalTemplates();
    }
}

