/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.ehrbase.aql.containment.CommonTokenCompare;
import org.ehrbase.aql.containment.ContainOperator;
import org.ehrbase.aql.containment.ContainPropositions;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.ContainsExpressions;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.containment.SimpleClassExpressionIdentifier;
import org.ehrbase.aql.parser.AqlParser;

public class ContainsProposition {
    private final ParserRuleContext parserRuleContext;
    private final IdentifierMapper identifierMapper;

    public ContainsProposition(ParserRuleContext parserRuleContext, IdentifierMapper identifierMapper) {
        this.parserRuleContext = parserRuleContext;
        this.identifierMapper = identifierMapper;
    }

    public boolean isSingleChain() {
        if (!(this.parserRuleContext instanceof AqlParser.ContainsExpressionContext)) {
            return false;
        }
        return ((AqlParser.ContainsExpressionContext)this.parserRuleContext).AND() == null && ((AqlParser.ContainsExpressionContext)this.parserRuleContext).OR() == null && ((AqlParser.ContainsExpressionContext)this.parserRuleContext).XOR() == null;
    }

    public List<Object> develop(ContainPropositions containPropositions) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (ParseTree child : this.parserRuleContext.children) {
            String expressionLabel;
            if (child instanceof TerminalNode) {
                objects.add(new ContainOperator(child.getText()));
                continue;
            }
            if (new ContainsExpressions(child).isExplicitContainsClause()) {
                expressionLabel = new ContainsExpressions(child).containedItemLabel(true);
                objects.add(containPropositions.get(expressionLabel));
                continue;
            }
            expressionLabel = child.getText();
            objects.add(containPropositions.get(expressionLabel));
        }
        return objects;
    }

    private List<Containment> getChainedContainments() {
        ArrayList<Containment> containments = new ArrayList<Containment>();
        ParserRuleContext parentContainment = this.parserRuleContext.getParent();
        while (!(parentContainment instanceof AqlParser.FromContext)) {
            AqlParser.ContainsContext containsContext;
            if (!((parentContainment = parentContainment.getParent()) instanceof AqlParser.ContainsContext) || (containsContext = (AqlParser.ContainsContext)parentContainment).getChildCount() <= 1) continue;
            if (!new CommonTokenCompare(containsContext.getChild(1)).isEquals(17)) {
                throw new IllegalStateException("Invalid contains context:" + containsContext.getText());
            }
            if (!(containsContext.getChild(0) instanceof AqlParser.SimpleClassExprContext)) continue;
            AqlParser.SimpleClassExprContext simpleClassExprContext = (AqlParser.SimpleClassExprContext)containsContext.getChild(0);
            if (!simpleClassExprContext.IDENTIFIER().isEmpty()) {
                containments.add((Containment)this.identifierMapper.getContainer(new SimpleClassExpressionIdentifier(simpleClassExprContext).resolve()));
                continue;
            }
            String identifier = ((AqlParser.ArchetypedClassExprContext)simpleClassExprContext.getChild(0)).IDENTIFIER(1) != null ? ((AqlParser.ArchetypedClassExprContext)simpleClassExprContext.getChild(0)).IDENTIFIER(1).getText() : simpleClassExprContext.getChild(0).getText().toUpperCase();
            containments.add((Containment)this.identifierMapper.getContainer(identifier));
        }
        return containments;
    }

    public ContainmentSet containmentSet(Containment containment) {
        ContainmentSet containmentSet = new ContainmentSet(0, null);
        containmentSet.add(containment);
        List<Containment> containmentList = this.getChainedContainments();
        containmentSet.addAll(containmentList);
        return containmentSet;
    }
}

