/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.SortField;
import org.jooq.impl.DSL;

public class OrderByBinder {
    private List<OrderAttribute> orderAttributes;
    private final SelectQuery<Record> select;
    private final VariableDefinitions variableDefinitions;

    OrderByBinder(VariableDefinitions variableDefinitions, List<OrderAttribute> orderAttributes, SelectQuery<Record> select) {
        this.orderAttributes = orderAttributes;
        this.select = select;
        this.variableDefinitions = variableDefinitions;
    }

    List<SortField<Object>> getOrderByFields() {
        if (this.orderAttributes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SortField<Object>> orderFields = new ArrayList<SortField<Object>>();
        for (OrderAttribute orderAttribute : this.orderAttributes) {
            Object fieldIdentifier = null;
            if (this.variableDefinitions != null) {
                Iterator<I_VariableDefinition> localIterator = this.variableDefinitions.iterator();
                while (localIterator.hasNext()) {
                    I_VariableDefinition variableDefinition = localIterator.next();
                    if (orderAttribute.getVariableDefinition().getPath() != null && orderAttribute.getVariableDefinition().getPath().equals(variableDefinition.getPath())) {
                        if (variableDefinition.getAlias() != null) {
                            fieldIdentifier = variableDefinition.getAlias();
                            break;
                        }
                        fieldIdentifier = "/" + orderAttribute.getVariableDefinition().getPath();
                        break;
                    }
                    if (orderAttribute.getVariableDefinition().getAlias() == null) continue;
                    fieldIdentifier = orderAttribute.getVariableDefinition().getAlias();
                }
            }
            if (fieldIdentifier == null) {
                fieldIdentifier = orderAttribute.getVariableDefinition().getAlias() == null ? "/" + orderAttribute.getVariableDefinition().getPath() : orderAttribute.getVariableDefinition().getAlias();
                orderAttribute.getVariableDefinition().setHidden(true);
            }
            if (!((String)fieldIdentifier).startsWith("\"")) {
                fieldIdentifier = "\"" + (String)fieldIdentifier + "\"";
            }
            SortField field = orderAttribute.getDirection() != null && orderAttribute.getDirection().equals((Object)OrderAttribute.OrderDirection.DESC) ? DSL.field((String)fieldIdentifier).desc() : DSL.field((String)fieldIdentifier).asc();
            orderFields.add((SortField<Object>)field);
        }
        return orderFields;
    }

    public SelectQuery<Record> bind() {
        if (CollectionUtils.isNotEmpty(this.orderAttributes)) {
            this.select.addOrderBy(this.getOrderByFields());
        }
        return this.select;
    }
}

