/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.value_field;

import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISODateTime {
    String isoDateTimeZ8601regex = "^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:Z|[+-][01]\\d:[0-5]\\d)$";
    String isoDate8601regex = "^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)$";
    String isoTime8601regex = "^(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:Z|[+-][01]\\d:[0-5]\\d)$";
    String dateCandidate;

    public ISODateTime(String dateCandidate) {
        this.dateCandidate = dateCandidate;
    }

    public boolean isValidDateTimeExpression() {
        Pattern pattern = Pattern.compile(this.isoDateTimeZ8601regex);
        return pattern.matcher(this.dateCandidate).matches();
    }

    public boolean isValidDateExpression() {
        Pattern pattern = Pattern.compile(this.isoDate8601regex);
        return pattern.matcher(this.dateCandidate).matches();
    }

    public boolean isValidTimeExpression() {
        Pattern pattern = Pattern.compile(this.isoTime8601regex);
        return pattern.matcher(this.dateCandidate).matches();
    }

    public long toTimeStamp() {
        DateTimeFormatter parser = ISODateTimeFormat.dateTimeNoMillis();
        return parser.parseDateTime(this.dateCandidate).getMillis();
    }
}

