/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.PreconditionFailedException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.FolderService;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.dao.access.jooq.FolderAccess;
import org.ehrbase.dao.access.jooq.FolderHistoryAccess;
import org.ehrbase.dao.access.util.FolderUtils;
import org.ehrbase.response.ehrscape.FolderDto;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.serialisation.xmlencoding.CanonicalXML;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FolderServiceImp
extends BaseServiceImp
implements FolderService {
    private final EhrService ehrService;

    @Autowired
    FolderServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, EhrService ehrService) {
        super(knowledgeCacheService, context, serverConfig);
        this.ehrService = ehrService;
    }

    public Optional<FolderDto> create(UUID ehrId, Folder objData, UUID systemId, UUID committerId, String description) {
        return this.internalCreate(ehrId, objData, systemId, committerId, description, null);
    }

    public Optional<FolderDto> create(UUID ehrId, Folder objData, UUID contribution) {
        return this.internalCreate(ehrId, objData, null, null, null, contribution);
    }

    public Optional<FolderDto> create(UUID ehrId, Folder objData) {
        return this.create(ehrId, objData, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private Optional<FolderDto> internalCreate(UUID ehrId, Folder objData, UUID systemId, UUID committerId, String description, UUID contribution) {
        I_ContributionAccess contributionAccess;
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        if (this.ehrService.getDirectoryId(ehrId) != null) {
            throw new StateConflictException(String.format("EHR with id %s already contains a directory.", ehrId.toString()));
        }
        FolderUtils.checkSiblingNameConflicts(objData);
        Timestamp currentTimeStamp = Timestamp.from(Instant.now());
        if (contribution == null) {
            contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), ehrId);
        } else {
            contributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contribution);
            systemId = contributionAccess.getAuditsSystemId();
            committerId = contributionAccess.getAuditsCommitter();
            description = contributionAccess.getAuditsDescription();
        }
        if (systemId == null || committerId == null) {
            throw new InternalServerException("Error on contribution handling for folder creation.");
        }
        I_FolderAccess folderAccess = FolderAccess.buildNewFolderAccessHierarchy(this.getDataAccess(), objData, currentTimeStamp, ehrId, contributionAccess);
        ObjectVersionId folderId = contribution == null ? new ObjectVersionId(folderAccess.commit(LocalDateTime.now(), systemId, committerId, description).toString() + "::" + this.getServerConfig().getNodename() + "::1") : new ObjectVersionId(folderAccess.commit(LocalDateTime.now(), contribution).toString() + "::" + this.getServerConfig().getNodename() + "::1");
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        ehrAccess.setDirectory(FolderUtils.extractUuidFromObjectVersionId(folderId));
        ehrAccess.update(this.getCurrentUserId(), this.getSystemUuid(), null, null, I_ConceptAccess.ContributionChangeType.MODIFICATION, "description");
        return this.get(folderId, null);
    }

    public Optional<FolderDto> update(UUID ehrId, ObjectVersionId targetObjId, Folder objData, UUID systemId, UUID committerId, String description) {
        return this.internalUpdate(ehrId, targetObjId, objData, systemId, committerId, description, null);
    }

    public Optional<FolderDto> update(UUID ehrId, ObjectVersionId targetObjId, Folder objData, UUID contribution) {
        return this.internalUpdate(ehrId, targetObjId, objData, null, null, null, contribution);
    }

    public Optional<FolderDto> update(UUID ehrId, ObjectVersionId targetObjId, Folder objData) {
        return this.update(ehrId, targetObjId, objData, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private Optional<FolderDto> internalUpdate(UUID ehrId, ObjectVersionId targetObjId, Folder objData, UUID systemId, UUID committerId, String description, UUID contribution) {
        boolean success;
        LocalDateTime timestamp = LocalDateTime.now();
        this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
        this.checkFolderWithIdExistsInEhr(ehrId, targetObjId);
        FolderUtils.checkSiblingNameConflicts(objData);
        I_FolderAccess folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), targetObjId);
        FolderUtils.updateFolder(objData, folderAccess);
        if (contribution == null) {
            folderAccess.getSubfoldersList().forEach((sf, sa) -> this.internalDelete(ehrId, new ObjectVersionId(sf.toString()), systemId, committerId, description, null, false));
        } else {
            folderAccess.getSubfoldersList().forEach((sf, sa) -> this.internalDelete(ehrId, new ObjectVersionId(sf.toString()), null, null, null, contribution, false));
        }
        folderAccess.getSubfoldersList().clear();
        if (objData.getFolders() != null && !objData.getFolders().isEmpty()) {
            objData.getFolders().forEach(childFolder -> folderAccess.getSubfoldersList().put(UUID.randomUUID(), FolderAccess.buildNewFolderAccessHierarchy(this.getDataAccess(), childFolder, Timestamp.from(Instant.now()), ehrId, ((FolderAccess)folderAccess).getContributionAccess())));
        }
        if (success = contribution == null ? folderAccess.update(timestamp, systemId, committerId, description, I_ConceptAccess.ContributionChangeType.MODIFICATION) : folderAccess.update(timestamp, contribution)) {
            return this.createDto(folderAccess, this.getLastVersionNumber(targetObjId), true);
        }
        return Optional.empty();
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId, UUID systemId, UUID committerId, String description) {
        this.internalDelete(ehrId, targetObjId, systemId, committerId, description, null, true);
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId, UUID contribution) {
        this.internalDelete(ehrId, targetObjId, null, null, null, contribution, true);
    }

    public void delete(UUID ehrId, ObjectVersionId targetObjId) {
        this.delete(ehrId, targetObjId, this.getSystemUuid(), this.getCurrentUserId(), null);
    }

    private void internalDelete(UUID ehrId, ObjectVersionId folderId, UUID systemId, UUID committerId, String description, UUID contribution, boolean withEhrCheck) {
        if (withEhrCheck) {
            this.ehrService.checkEhrExistsAndIsModifiable(ehrId);
            this.checkFolderWithIdExistsInEhr(ehrId, folderId);
        }
        if (FolderUtils.uuidMatchesObjectVersionId(this.ehrService.getDirectoryId(ehrId), folderId)) {
            this.ehrService.removeDirectory(ehrId);
        }
        I_FolderAccess folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId);
        LocalDateTime timestamp = LocalDateTime.now();
        int result = contribution == null ? folderAccess.delete(timestamp, systemId, committerId, description) : folderAccess.delete(timestamp, contribution);
        if (result <= 0) {
            throw new InternalServerException("Error during deletion of folder " + folderId);
        }
    }

    private void checkFolderWithIdExistsInEhr(UUID ehrId, ObjectVersionId folderId) {
        UUID ehrRootDirectoryId = this.ehrService.getDirectoryId(ehrId);
        if (ehrRootDirectoryId == null) {
            throw new PreconditionFailedException(String.format("EHR with id %s does not contain a directory. Maybe it has been deleted?", ehrId.toString()));
        }
        I_FolderAccess folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), new ObjectVersionId(ehrRootDirectoryId.toString()));
        if (!FolderUtils.doesAnyIdInFolderStructureMatch(folderAccess, folderId)) {
            throw new PreconditionFailedException(String.format("Folder with id %s is not part of EHR with id %s", folderId.getValue(), ehrId));
        }
    }

    public Optional<FolderDto> get(ObjectVersionId folderId, String path) {
        I_FolderAccess folderAccess;
        Integer version = FolderUtils.extractVersionNumberFromObjectVersionId(folderId);
        if (version == null) {
            folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId);
            version = this.getLastVersionNumber(folderId);
        } else {
            Timestamp versionTimestamp = FolderAccess.getTimestampForVersion(this.getDataAccess(), folderId, version);
            folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId, versionTimestamp);
        }
        I_FolderAccess withExtractedPath = this.extractPath(folderAccess, path);
        return this.createDto(withExtractedPath, version, path == null || path.equals("/"));
    }

    public Optional<FolderDto> getByTimeStamp(ObjectVersionId folderId, Timestamp timestamp, String path) {
        I_FolderAccess withExtractedPath;
        I_FolderAccess latest = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId);
        if (latest == null) {
            throw new ObjectNotFoundException("FOLDER", String.format("Folder with id %s could not be found", folderId.toString()));
        }
        Integer version = FolderUtils.extractVersionNumberFromObjectVersionId(folderId);
        if (timestamp.after(latest.getFolderSysTransaction()) || timestamp.equals(latest.getFolderSysTransaction())) {
            if (version == null) {
                version = this.getLastVersionNumber(folderId);
            }
            withExtractedPath = this.extractPath(latest, path);
        } else {
            version = this.getVersionNumberForTimestamp(folderId, timestamp);
            I_FolderAccess versionAtTime = FolderHistoryAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId, timestamp);
            withExtractedPath = this.extractPath(versionAtTime, path);
        }
        return this.createDto(withExtractedPath, version, path == null || path.equals("/"));
    }

    public Optional<FolderDto> getLatest(ObjectVersionId folderId, String path) {
        I_FolderAccess folderAccess = I_FolderAccess.getInstanceForExistingFolder(this.getDataAccess(), folderId, Timestamp.from(Instant.now()));
        Integer version = FolderUtils.extractVersionNumberFromObjectVersionId(folderId);
        if (version == null) {
            version = this.getLastVersionNumber(folderId);
        }
        return this.createDto(folderAccess, version, path == null || path.equals("/"));
    }

    public StructuredString serialize(Folder folder, StructuredStringFormat format) {
        StructuredString folderString;
        switch (format) {
            case XML: {
                folderString = new StructuredString(new CanonicalXML().marshal((RMObject)folder, Boolean.valueOf(false)), StructuredStringFormat.XML);
                break;
            }
            case JSON: {
                folderString = new StructuredString(new CanonicalJson().marshal((RMObject)folder), StructuredStringFormat.JSON);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException("Unsupported target format for serialization of folders: " + format);
            }
        }
        return folderString;
    }

    public Integer getLastVersionNumber(ObjectVersionId folderId) {
        return FolderAccess.getLastVersionNumber(this.getDataAccess(), folderId);
    }

    public Integer getVersionNumberForTimestamp(ObjectVersionId folderId, Timestamp timestamp) {
        return FolderAccess.getVersionNumberAtTime(this.getDataAccess(), folderId, timestamp);
    }

    private Optional<FolderDto> createDto(I_FolderAccess folderAccess, int version, boolean isRoot) {
        if (folderAccess == null) {
            return Optional.empty();
        }
        Folder folder = this.createFolderObject(folderAccess);
        if (isRoot) {
            folder.setUid((UIDBasedId)new ObjectVersionId(String.format("%s::%s::%s", folderAccess.getFolderId().toString(), this.getServerConfig().getNodename(), version)));
        }
        return Optional.of(new FolderDto(folder));
    }

    private Folder createFolderObject(I_FolderAccess folderAccess) {
        Folder result = new Folder((UIDBasedId)new HierObjectId(String.format("%s::%s", folderAccess.getFolderId().toString(), this.getServerConfig().getNodename())), folderAccess.getFolderArchetypeNodeId(), new DvText(folderAccess.getFolderName()), folderAccess.getFolderDetails(), null, null, null, null, null, folderAccess.getItems(), null);
        if (!folderAccess.getSubfoldersList().isEmpty()) {
            result.setFolders(folderAccess.getSubfoldersList().values().stream().map(this::createFolderObject).collect(Collectors.toList()));
        }
        return result;
    }

    private I_FolderAccess extractPath(I_FolderAccess folderAccess, String path) {
        if (path != null && !"/".equals(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            folderAccess = FolderUtils.getPath(folderAccess, 0, path.split("/"));
        }
        return folderAccess;
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    public void adminDeleteFolder(UUID folderId) {
        I_FolderAccess folderAccess = I_FolderAccess.retrieveInstanceForExistingFolder(this.getDataAccess(), folderId);
        folderAccess.adminDeleteFolder();
    }
}

