/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.google.gson.JsonElement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.ehrbase.api.definitions.QueryMode;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.interfaces.I_StoredQueryAccess;
import org.ehrbase.dao.access.jooq.AqlQueryHandler;
import org.ehrbase.dao.access.jooq.StoredQueryAccess;
import org.ehrbase.response.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.response.ehrscape.QueryResultDto;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.response.ehrscape.query.ResultHolder;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class QueryServiceImp
extends BaseServiceImp
implements QueryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExternalTerminologyValidation tsAdapter;
    private static BiConsumer<Map<?, ?>, String> checkNonNull = (map, errMsg) -> {
        if (map == null) {
            throw new IllegalArgumentException((String)errMsg);
        }
    };
    private static final String ERR_MAP_NON_NULL = "Arg[%s] must not be null";

    @Autowired
    public QueryServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, ExternalTerminologyValidation tsAdapter) {
        super(knowledgeCacheService, context, serverConfig);
        this.tsAdapter = tsAdapter;
    }

    public QueryResultDto query(String queryString, Map<String, Object> parameters, QueryMode queryMode, boolean explain, Map<String, Set<Object>> auditResultMap) {
        switch (queryMode) {
            case SQL: {
                return this.querySql(queryString);
            }
            case AQL: {
                return this.queryAql(queryString, explain, () -> new AqlQueryHandler(this.getDataAccess(), this.tsAdapter).process(queryString, parameters), auditResultMap);
            }
        }
        throw new IllegalArgumentException("Invalid query mode:" + queryMode);
    }

    private QueryResultDto formatResult(AqlResult aqlResult, String queryString, boolean explain) {
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL(queryString);
        dto.setVariables(aqlResult.getVariables());
        ArrayList<ResultHolder> resultList = new ArrayList<ResultHolder>();
        for (Record record : aqlResult.getRecords()) {
            ResultHolder fieldMap = new ResultHolder();
            for (Field field : record.fields()) {
                if (!aqlResult.variablesContains(field.getName())) continue;
                if (record.getValue(field) instanceof JsonElement) {
                    fieldMap.putResult(field.getName(), (Object)new StructuredString(record.getValue(field).toString(), StructuredStringFormat.JSON));
                    continue;
                }
                fieldMap.putResult(field.getName(), record.getValue(field));
            }
            resultList.add(fieldMap);
        }
        dto.setResultSet(resultList);
        if (explain) {
            dto.setExplain(aqlResult.getExplain());
        }
        return dto;
    }

    private QueryResultDto queryAql(String queryString, boolean explain, Supplier<AqlResult> resultSupplier, Map<String, Set<Object>> auditResultMap) {
        checkNonNull.accept(auditResultMap, String.format(ERR_MAP_NON_NULL, "auditResultMap"));
        try {
            AqlResult aqlResult = resultSupplier.get();
            auditResultMap.putAll(aqlResult.getAuditResultMap());
            return this.formatResult(aqlResult, queryString, explain);
        }
        catch (RestClientException rce) {
            throw new BadGatewayException("Bad gateway exception: " + rce.getCause().getMessage());
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error: " + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not process query/stored-query, reason: " + e);
        }
    }

    private QueryResultDto querySql(String queryString) {
        Map<String, Object> result;
        try {
            result = I_EntryAccess.queryJSON(this.getDataAccess(), queryString);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException((Throwable)e);
        }
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL((String)result.get("executedAQL"));
        dto.setResultSet((List)result.get("resultSet"));
        dto.setExplain((List)result.get("explain"));
        return dto;
    }

    public List<QueryDefinitionResultDto> retrieveStoredQueries(String fullyQualifiedName) {
        ArrayList<QueryDefinitionResultDto> resultDtos = new ArrayList<QueryDefinitionResultDto>();
        try {
            if (fullyQualifiedName == null || fullyQualifiedName.isEmpty()) {
                for (I_StoredQueryAccess i_StoredQueryAccess : StoredQueryAccess.retrieveQualifiedList(this.getDataAccess())) {
                    resultDtos.add(this.mapToQueryDefinitionDto(i_StoredQueryAccess));
                }
            } else {
                for (I_StoredQueryAccess i_StoredQueryAccess : StoredQueryAccess.retrieveQualifiedList(this.getDataAccess(), fullyQualifiedName)) {
                    resultDtos.add(this.mapToQueryDefinitionDto(i_StoredQueryAccess));
                }
            }
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason:" + e);
        }
        return resultDtos;
    }

    public QueryDefinitionResultDto retrieveStoredQuery(String qualifiedName, String version) {
        StoredQueryAccess storedQueryAccess;
        String queryQualifiedName = qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : "");
        try {
            storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), queryQualifiedName);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
        return this.mapToQueryDefinitionDto(storedQueryAccess);
    }

    public QueryDefinitionResultDto createStoredQuery(String qualifiedName, String version, String queryString) {
        try {
            new AqlExpression().parse(queryString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid query, reason:" + e);
        }
        try {
            String queryQualifiedName = qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : "");
            StoredQueryAccess storedQueryAccess = new StoredQueryAccess(this.getDataAccess(), queryQualifiedName, queryString);
            storedQueryAccess.commit();
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    public QueryDefinitionResultDto updateStoredQuery(String qualifiedName, String version, String queryString) {
        try {
            StoredQueryAccess storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : ""));
            storedQueryAccess.setQueryText(queryString);
            storedQueryAccess.update(Timestamp.from(Instant.now()));
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    public QueryDefinitionResultDto deleteStoredQuery(String qualifiedName, String version) {
        try {
            StoredQueryAccess storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : ""));
            storedQueryAccess.delete();
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    private QueryDefinitionResultDto mapToQueryDefinitionDto(I_StoredQueryAccess storedQueryAccess) {
        QueryDefinitionResultDto dto = new QueryDefinitionResultDto();
        dto.setSaved(storedQueryAccess.getCreationDate().toInstant().atZone(ZoneId.systemDefault()));
        dto.setQualifiedName(storedQueryAccess.getReverseDomainName() + "::" + storedQueryAccess.getSemanticId());
        dto.setVersion(storedQueryAccess.getSemver());
        dto.setQueryText(storedQueryAccess.getQueryText());
        dto.setType(storedQueryAccess.getQueryType());
        return dto;
    }
}

