/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.binding.CompositionAttribute;
import org.ehrbase.aql.sql.binding.ContextualAttribute;
import org.ehrbase.aql.sql.binding.FieldConstantHandler;
import org.ehrbase.aql.sql.binding.LocatableItem;
import org.ehrbase.aql.sql.queryimpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;

public class ExpressionField {
    private final I_VariableDefinition variableDefinition;
    private final JsonbEntryQuery jsonbEntryQuery;
    private final CompositionAttributeQuery compositionAttributeQuery;

    public ExpressionField(I_VariableDefinition variableDefinition, JsonbEntryQuery jsonbEntryQuery, CompositionAttributeQuery compositionAttributeQuery) {
        this.variableDefinition = variableDefinition;
        this.jsonbEntryQuery = jsonbEntryQuery;
        this.compositionAttributeQuery = compositionAttributeQuery;
    }

    MultiFields toSql(String className, String templateId, String identifier, IQueryImpl.Clause clause) {
        MultiFields aqlFields;
        if (new FieldConstantHandler(this.variableDefinition).isConstant()) {
            return new MultiFields(this.variableDefinition, new FieldConstantHandler(this.variableDefinition).field(), templateId);
        }
        switch (className) {
            case "COMPOSITION": {
                CompositionAttribute compositionAttribute = new CompositionAttribute(this.compositionAttributeQuery, this.jsonbEntryQuery, clause);
                aqlFields = compositionAttribute.toSql(this.variableDefinition, templateId, identifier);
                break;
            }
            case "EHR": {
                aqlFields = this.compositionAttributeQuery.makeField(templateId, identifier, this.variableDefinition, clause);
                break;
            }
            default: {
                if (this.compositionAttributeQuery.isCompositionAttributeItemStructure(templateId, this.variableDefinition.getIdentifier())) {
                    ContextualAttribute contextualAttribute = new ContextualAttribute(this.compositionAttributeQuery, this.jsonbEntryQuery, clause);
                    aqlFields = contextualAttribute.toSql(templateId, this.variableDefinition);
                    break;
                }
                LocatableItem locatableItem = new LocatableItem(this.compositionAttributeQuery, this.jsonbEntryQuery, clause);
                aqlFields = locatableItem.toSql(templateId, this.variableDefinition);
                if (aqlFields.isEmpty()) break;
                aqlFields.setUseEntryTable(true);
            }
        }
        return aqlFields;
    }
}

