/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.definition.LateralVariable;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.I_TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.LateralJoins;
import org.ehrbase.aql.sql.binding.SetReturningFunction;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.WhereJsQueryExpression;
import org.ehrbase.aql.sql.queryimpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMap;
import org.ehrbase.aql.sql.queryimpl.VariablePath;
import org.ehrbase.aql.sql.queryimpl.value_field.ISODateTime;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class WhereBinder {
    private static final String VALUETYPE_EXPR_VALUE = "/value,value";
    public static final String EXISTS = "EXISTS";
    public static final String MATCHES = "MATCHES";
    public static final String NOT = "NOT";
    public static final String IS = "IS";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String NULL = "NULL";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String DISTINCT = "DISTINCT";
    public static final String FROM = "FROM";
    public static final String BETWEEN = "BETWEEN";
    private static final Set<String> sqloperators = new HashSet<String>(Arrays.asList("=", "!=", ">", ">=", "<", "<=", "MATCHES", "EXISTS", "NOT", "IS", "TRUE", "FALSE", "NULL", "UNKNOWN", "DISTINCT", "FROM", "BETWEEN", "(", ")", "{", "}"));
    public static final String COMPOSITION = "COMPOSITION";
    public static final String CONTENT = "content";
    public static final String EHR = "EHR";
    public static final String OR = "OR";
    public static final String XOR = "XOR";
    public static final String AND = "AND";
    public static final String IN = "IN";
    public static final String ANY = "ANY";
    public static final String SOME = "SOME";
    public static final String ALL = "ALL";
    private final I_DomainAccess domainAccess;
    private CompositionAttributeQuery compositionAttributeQuery;
    private final List<Object> whereClause;
    private PathResolver pathResolver;
    private boolean isWholeComposition = false;
    private String compositionName = null;
    private String sqlConditionalFunctionalOperatorRegexp = "(?i)(like|ilike|substr|in|not in)";
    private boolean requiresJSQueryClosure = false;
    private boolean isFollowedBySQLConditionalOperator = false;

    public WhereBinder(I_DomainAccess domainAccess, CompositionAttributeQuery compositionAttributeQuery, List<Object> whereClause, PathResolver pathResolver) {
        this.compositionAttributeQuery = compositionAttributeQuery;
        this.whereClause = whereClause;
        this.pathResolver = pathResolver;
        this.domainAccess = domainAccess;
    }

    private TaggedStringBuilder encodeWhereVariable(int whereCursor, MultiFieldsMap multiFieldsMap, I_VariableDefinition variableDefinition) {
        String identifier = variableDefinition.getIdentifier();
        String className = this.pathResolver.classNameOf(identifier);
        if (className == null) {
            throw new IllegalArgumentException("Could not bind identifier in WHERE clause:'" + identifier + "'");
        }
        Field<?> field = multiFieldsMap.get(variableDefinition.getIdentifier(), variableDefinition.getPath()).getQualifiedFieldOrLast(whereCursor).getSQLField();
        if (field == null) {
            return null;
        }
        return new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.SQLQUERY);
    }

    private TaggedStringBuilder buildWhereCondition(int whereCursor, MultiFieldsMap multiFieldsMap, TaggedStringBuilder taggedBuffer, List<Object> item) {
        for (Object part : item) {
            TaggedStringBuilder taggedStringBuilder;
            if (part instanceof String) {
                taggedBuffer.append((String)part);
                continue;
            }
            if (part instanceof VariableDefinition) {
                taggedStringBuilder = this.encodeWhereVariable(whereCursor, multiFieldsMap, (VariableDefinition)part);
                if (taggedStringBuilder == null) continue;
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(part instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(whereCursor, multiFieldsMap, taggedBuffer, (List)part);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        return taggedBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Condition bind(String templateId, int whereCursor, MultiFieldsMap multiWhereFieldsMap, MultiFieldsMap multiSelectFieldsMap) {
        boolean unresolvedVariable = false;
        if (this.whereClause.isEmpty()) {
            return null;
        }
        TaggedStringBuilder taggedBuffer = new TaggedStringBuilder();
        ArrayList<Object> whereItems = new ArrayList<Object>(this.whereClause);
        boolean notExists = false;
        boolean inSubqueryOperator = false;
        for (int cursor = 0; cursor < whereItems.size(); ++cursor) {
            TaggedStringBuilder taggedStringBuilder;
            Object e = whereItems.get(cursor);
            if (e instanceof String) {
                switch (((String)e).trim().toUpperCase()) {
                    case "OR": 
                    case "XOR": 
                    case "AND": {
                        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
                        taggedBuffer.append(" " + e + " ");
                        break;
                    }
                    case "NOT": {
                        if (whereItems.get(cursor + 1).toString().equalsIgnoreCase(EXISTS)) {
                            notExists = true;
                            break;
                        }
                        taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
                        taggedBuffer.append(" " + e + " ");
                        break;
                    }
                    case "IN": 
                    case "ANY": 
                    case "SOME": 
                    case "ALL": {
                        if (((String)e).trim().toUpperCase().matches("ANY|SOME|ALL")) {
                            inSubqueryOperator = true;
                        }
                        taggedBuffer.append((String)e);
                        break;
                    }
                    case "EXISTS": {
                        whereItems.add(cursor + 2, notExists ? "IS " : "IS NOT ");
                        whereItems.add(cursor + 3, NULL);
                        notExists = false;
                        break;
                    }
                    default: {
                        ISODateTime isoDateTime = new ISODateTime(((String)e).replace("'", ""));
                        if (isoDateTime.isValidDateTimeExpression()) {
                            long timestamp = isoDateTime.toTimeStamp() / 1000L;
                            int lastValuePos = taggedBuffer.lastIndexOf(VALUETYPE_EXPR_VALUE);
                            if (lastValuePos > 0) {
                                taggedBuffer.replaceLast(VALUETYPE_EXPR_VALUE, "/value,epoch_offset");
                            }
                            this.isFollowedBySQLConditionalOperator = true;
                            Object object = this.hackItem(taggedBuffer, Long.toString(timestamp), "numeric");
                            taggedBuffer.append((String)object);
                            break;
                        }
                        Object object = this.hackItem(taggedBuffer, (String)e, null);
                        taggedBuffer.append((String)object);
                        break;
                    }
                }
                continue;
            }
            if (e instanceof Long) {
                Object object = this.hackItem(taggedBuffer, e.toString(), null);
                taggedBuffer.append(object.toString());
                continue;
            }
            if (e instanceof I_VariableDefinition) {
                block39: {
                    taggedStringBuilder = new TaggedStringBuilder();
                    if (this.isFollowedBySQLConditionalOperator(cursor)) {
                        TaggedStringBuilder encodedVar = this.encodeWhereVariable(whereCursor, multiWhereFieldsMap, (I_VariableDefinition)e);
                        String expanded = this.expandForLateral(templateId, encodedVar, (I_VariableDefinition)e, multiSelectFieldsMap);
                        if (StringUtils.isNotBlank((CharSequence)expanded)) {
                            taggedStringBuilder.append(expanded);
                            break block39;
                        } else {
                            unresolvedVariable = true;
                            break;
                        }
                    }
                    if (((I_VariableDefinition)e).getPath() != null && this.isWholeComposition) {
                        if (this.compositionName == null) {
                            this.compositionName = this.compositionNameValue(((I_VariableDefinition)e).getIdentifier());
                        }
                        if (this.compositionName == null) {
                            throw new IllegalArgumentException("A composition name/value is required to resolve where statement when querying for a whole composition");
                        }
                        taggedStringBuilder = this.encodeWhereVariable(whereCursor, multiWhereFieldsMap, (I_VariableDefinition)e);
                    } else {
                        if (new VariablePath(((I_VariableDefinition)e).getPath()).hasPredicate()) {
                            String expanded = this.expandForLateral(templateId, this.encodeWhereVariable(whereCursor, multiWhereFieldsMap, (I_VariableDefinition)e), (I_VariableDefinition)e, multiSelectFieldsMap);
                            if (StringUtils.isNotBlank((CharSequence)expanded)) {
                                taggedStringBuilder.append(this.encodeForSubquery(expanded, inSubqueryOperator));
                                inSubqueryOperator = false;
                                this.isFollowedBySQLConditionalOperator = true;
                                this.requiresJSQueryClosure = false;
                                break block39;
                            } else {
                                unresolvedVariable = true;
                                break;
                            }
                        }
                        String expanded = this.expandForLateral(templateId, this.encodeWhereVariable(whereCursor, multiWhereFieldsMap, (I_VariableDefinition)e), (I_VariableDefinition)e, multiSelectFieldsMap);
                        if (StringUtils.isNotBlank((CharSequence)expanded)) {
                            taggedStringBuilder.append(this.encodeForSubquery(expanded, inSubqueryOperator));
                            inSubqueryOperator = false;
                        } else {
                            unresolvedVariable = true;
                            break;
                        }
                    }
                }
                if (taggedStringBuilder == null) continue;
                taggedBuffer.append(taggedStringBuilder.toString());
                taggedBuffer.setTagField(taggedStringBuilder.getTagField());
                continue;
            }
            if (!(e instanceof List)) continue;
            taggedStringBuilder = this.buildWhereCondition(whereCursor, multiWhereFieldsMap, taggedBuffer, (List)e);
            taggedBuffer.append(taggedStringBuilder.toString());
            taggedBuffer.setTagField(taggedStringBuilder.getTagField());
        }
        if (!unresolvedVariable) {
            taggedBuffer = new WhereJsQueryExpression(taggedBuffer, this.requiresJSQueryClosure, this.isFollowedBySQLConditionalOperator).closure();
            return DSL.condition((String)taggedBuffer.toString());
        }
        return DSL.falseCondition();
    }

    private String encodeForSubquery(String sqlExpression, boolean inSubqueryOperator) {
        if (inSubqueryOperator) {
            return "(SELECT " + sqlExpression + ")";
        }
        return sqlExpression;
    }

    private boolean isFollowedBySQLConditionalOperator(int cursor) {
        Object nextToken;
        if (cursor < this.whereClause.size() - 1 && (nextToken = this.whereClause.get(cursor + 1)) instanceof String && ((String)nextToken).trim().matches(this.sqlConditionalFunctionalOperatorRegexp)) {
            this.isFollowedBySQLConditionalOperator = true;
            return true;
        }
        this.isFollowedBySQLConditionalOperator = false;
        return false;
    }

    private String compositionNameValue(String symbol) {
        String token = null;
        for (int lcursor = 0; lcursor < this.whereClause.size() - 1; ++lcursor) {
            if (!(this.whereClause.get(lcursor) instanceof VariableDefinition) || !((VariableDefinition)this.whereClause.get(lcursor)).getIdentifier().equals(symbol) || !((VariableDefinition)this.whereClause.get(lcursor)).getPath().equals("name/value")) continue;
            Object nextToken = this.whereClause.get(lcursor + 1);
            if (nextToken instanceof String && !nextToken.equals("=")) {
                throw new IllegalArgumentException("name/value for CompositionAttribute must be an equality");
            }
            nextToken = this.whereClause.get(lcursor + 2);
            if (!(nextToken instanceof String)) continue;
            token = (String)nextToken;
            break;
        }
        return token;
    }

    private Object hackItem(TaggedStringBuilder taggedBuffer, String item, String castAs) {
        if (castAs != null) {
            int variableInitial;
            int variableClosure;
            if (this.isFollowedBySQLConditionalOperator && (variableClosure = taggedBuffer.lastIndexOf("}'")) > 0 && (variableInitial = taggedBuffer.lastIndexOf("\"ehr\".\"entry\".\"entry\" #>>")) >= 0 && variableInitial < variableClosure) {
                taggedBuffer.insert(variableClosure + "}'".length(), ")::" + castAs);
                taggedBuffer.insert(variableInitial, "(");
            }
            return item;
        }
        if (sqloperators.contains(item.toUpperCase())) {
            return " " + item + " ";
        }
        if (taggedBuffer.toString().contains("composition_join") && item.contains("::")) {
            return item.split("::")[0] + "'";
        }
        if (this.requiresJSQueryClosure && !this.isFollowedBySQLConditionalOperator && taggedBuffer.indexOf("#") > 0 && item.contains("'")) {
            return item.replace("'", "\"");
        }
        return item;
    }

    private String expandForCondition(TaggedStringBuilder taggedStringBuilder) {
        Object wrapped;
        if (taggedStringBuilder == null) {
            return null;
        }
        switch (taggedStringBuilder.getTagField()) {
            case JSQUERY: {
                wrapped = JsonbEntryQuery.JSQUERY_COMPOSITION_OPEN + taggedStringBuilder.toString();
                this.requiresJSQueryClosure = true;
                break;
            }
            case SQLQUERY: {
                wrapped = taggedStringBuilder.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Uninitialized tag passed in query expression");
            }
        }
        return wrapped;
    }

    private String expandForLateral(String templateId, TaggedStringBuilder encodedVar, I_VariableDefinition variableDefinition, MultiFieldsMap multiSelectFieldsMap) {
        String expanded = this.expandForCondition(encodedVar);
        if (new SetReturningFunction(expanded).isUsed()) {
            MultiFields selectFields = multiSelectFieldsMap.get(variableDefinition.getIdentifier(), variableDefinition.getPath());
            if (selectFields != null && selectFields.getVariableDefinition().getLateralJoinDefinitions(templateId) != null) {
                LateralJoinDefinition lateralJoinDefinition = this.reconciliateWithAliasedTable(expanded, selectFields.getVariableDefinition(), templateId);
                if (lateralJoinDefinition == null) {
                    return null;
                }
                variableDefinition.setLateralJoinTable(templateId, lateralJoinDefinition);
                variableDefinition.setAlias(new LateralVariable(lateralJoinDefinition.getTable().getName(), lateralJoinDefinition.getLateralVariable()).alias());
            } else {
                new LateralJoins().create(templateId, encodedVar, variableDefinition, IQueryImpl.Clause.WHERE);
            }
            expanded = variableDefinition.getAlias();
        }
        return expanded;
    }

    private LateralJoinDefinition reconciliateWithAliasedTable(String expanded, I_VariableDefinition variableDefinition, String templateId) {
        Set<LateralJoinDefinition> definedLateralJoins = variableDefinition.getLateralJoinDefinitions(templateId);
        for (LateralJoinDefinition lateralJoinDefinition : definedLateralJoins) {
            if (!lateralJoinDefinition.getSqlExpression().replace("\n", "").replace(" ", "").contains(expanded.substring(0, expanded.length() - 1).substring(1).replace("\n", "").replace(" ", ""))) continue;
            return lateralJoinDefinition;
        }
        return null;
    }
}

