/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.compiler.AqlExpressionWithParameters;
import org.ehrbase.aql.compiler.AuditVariables;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.aql.sql.QueryProcessor;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.jooq.Record;
import org.jooq.Result;
import org.springframework.lang.Nullable;

public class AqlQueryHandler
extends DataAccess {
    private ExternalTerminologyValidation tsAdapter;
    private Map<String, Set<Object>> auditResultMap = new HashMap<String, Set<Object>>();

    public AqlQueryHandler(I_DomainAccess domainAccess, ExternalTerminologyValidation tsAdapter) {
        super(domainAccess);
        this.tsAdapter = tsAdapter;
    }

    public AqlResult process(String query, @Nullable Map<String, Object> parameters) {
        AqlExpression aqlExpression = MapUtils.isEmpty(parameters) ? new AqlExpression().parse(query) : new AqlExpressionWithParameters().parse(query, parameters);
        return this.execute(aqlExpression);
    }

    private AqlResult execute(AqlExpression aqlExpression) {
        AuditVariables auditVariables = new AuditVariables();
        Contains contains = new Contains(aqlExpression.getParseTree(), (KnowledgeCacheService)this.getDataAccess().getIntrospectService()).process();
        Statements statements = new Statements(aqlExpression.getParseTree(), contains.getIdentifierMapper(), this.tsAdapter).process();
        QueryProcessor queryProcessor = new QueryProcessor(this, this.getIntrospectService(), contains, statements, this.getDataAccess().getServerConfig().getNodename());
        AqlResult aqlResult = queryProcessor.execute();
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        Iterator<I_VariableDefinition> iterator = statements.getVariables().iterator();
        int serial = 0;
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (auditVariables.isAuditVariable(variableDefinition)) {
                auditVariables.addResults(this.auditResultMap, variableDefinition.getPath(), this.resultSetForVariable(variableDefinition, aqlResult.getRecords()));
            }
            if (variableDefinition.isHidden()) continue;
            variables.put((String)(variableDefinition.getAlias() == null || variableDefinition.isVoidAlias() ? "#" + serial++ : variableDefinition.getAlias()), (String)(StringUtils.isNotBlank((CharSequence)variableDefinition.getPath()) ? "/" + variableDefinition.getPath() : variableDefinition.getIdentifier()));
        }
        aqlResult.setVariables(variables);
        aqlResult.setAuditResultMap(this.auditResultMap);
        return aqlResult;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    public Set<Object> resultSetForVariable(I_VariableDefinition variableDefinition, Result<Record> recordResult) {
        HashSet<Object> resultSet = new HashSet<Object>();
        Object columnIdentifier = variableDefinition.getAlias() != null ? variableDefinition.getAlias() : "/" + variableDefinition.getPath();
        for (Record record : recordResult) {
            if (variableDefinition.getAlias() != null && variableDefinition.getAlias().startsWith("_FCT")) continue;
            resultSet.add(record.get((String)columnIdentifier));
        }
        return resultSet;
    }

    public Map<String, Set<Object>> getAuditResultMap() {
        return this.auditResultMap;
    }
}

