/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartyRelated;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PartyIdentifiers;
import org.ehrbase.dao.access.jooq.party.PartyRefValue;
import org.ehrbase.dao.access.jooq.party.PersistedParty;
import org.ehrbase.dao.access.jooq.party.PersistedPartyIdentified;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRef;
import org.ehrbase.dao.access.jooq.rmdatavalue.JooqDvCodedText;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.service.PersistentCodePhrase;
import org.ehrbase.service.PersistentTermMapping;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.impl.DSL;

class PersistedPartyRelated
extends PersistedParty {
    private static final BiFunction<PartyIdentified, PartyIdentifiedRecord, PartyProxy> partyIdentConvert = (pId, pIdRec) -> {
        PartyRelated partyRelated = new PartyRelated();
        partyRelated.setExternalRef(pId.getExternalRef());
        partyRelated.setName(pId.getName());
        partyRelated.setIdentifiers(pId.getIdentifiers());
        partyRelated.setRelationship(new JooqDvCodedText(pIdRec.getRelationship()).toRmInstance());
        return partyRelated;
    };
    Supplier<PersistedPartyIdentified> persistedPartyIdentifiedCreator = () -> new PersistedPartyIdentified(this.getDomainAccess());

    PersistedPartyRelated(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public PartyProxy render(PartyIdentifiedRecord partyIdentifiedRecord) {
        return partyIdentConvert.apply((PartyIdentified)new PersistedPartyIdentified(this.domainAccess).render(partyIdentifiedRecord), partyIdentifiedRecord);
    }

    private I_DomainAccess getDomainAccess() {
        return this.domainAccess;
    }

    @Override
    public List<PartyProxy> renderMultiple(Collection<PartyIdentifiedRecord> partyIdentifiedRecords) {
        List<PartyProxy> renderMultiple = this.persistedPartyIdentifiedCreator.get().renderMultiple(partyIdentifiedRecords);
        return renderMultiple.stream().map(pp -> (PartyIdentified)pp).map(pi -> partyIdentifiedRecords.stream().filter(pir -> pir.getName().equals(pi.getName())).findFirst().map(pir -> partyIdentConvert.apply((PartyIdentified)pi, (PartyIdentifiedRecord)pir)).orElseThrow(() -> new IllegalStateException())).collect(Collectors.toList());
    }

    @Override
    public UUID store(PartyProxy partyProxy) {
        PartyRefValue partyRefValue = new PartyRefValue(partyProxy).attributes();
        UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)this.domainAccess.getContext().insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.NAME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE, (Field)Tables.PARTY_IDENTIFIED.PARTY_TYPE, (Field)Tables.PARTY_IDENTIFIED.OBJECT_ID_TYPE, (Field)Tables.PARTY_IDENTIFIED.RELATIONSHIP).values((Object)((PartyIdentified)partyProxy).getName(), (Object)partyRefValue.getNamespace(), (Object)partyRefValue.getValue(), (Object)partyRefValue.getScheme(), (Object)partyRefValue.getType(), (Object)PartyType.party_related, (Object)partyRefValue.getObjectIdType(), (Object)this.relationshipAsRecord(partyProxy)).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        new PartyIdentifiers(this.domainAccess).store((PartyIdentified)partyProxy, partyIdentifiedUuid);
        return partyIdentifiedUuid;
    }

    @Override
    public UUID findInDB(PartyProxy partyProxy) {
        Record record;
        UUID uuid = new PersistedPartyRef(this.domainAccess).findInDB(partyProxy.getExternalRef());
        if (uuid == null && partyProxy.getExternalRef() == null && (record = this.domainAccess.getContext().fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.isNull().and(Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME.isNull()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE.isNull()).and(Tables.PARTY_IDENTIFIED.NAME.eq((Object)((PartyIdentified)partyProxy).getName())).and(DSL.field((String)("(" + Tables.PARTY_IDENTIFIED.RELATIONSHIP + ").value")).eq((Object)this.relationshipAsRecord(partyProxy).getValue())).and(Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_related)))) != null) {
            uuid = ((PartyIdentifiedRecord)record).getId();
            if (!new PartyIdentifiers(this.domainAccess).compare((PartyIdentifiedRecord)record, (List<DvIdentifier>)((PartyRelated)partyProxy).getIdentifiers())) {
                uuid = null;
            }
        }
        return uuid;
    }

    private DvCodedTextRecord relationshipAsRecord(PartyProxy partyProxy) {
        DvCodedText relationship = ((PartyRelated)partyProxy).getRelationship();
        return new DvCodedTextRecord(relationship.getValue(), new PersistentCodePhrase(relationship.getDefiningCode()).encode(), relationship.getFormatting(), new PersistentCodePhrase(relationship.getLanguage()).encode(), new PersistentCodePhrase(relationship.getEncoding()).encode(), new PersistentTermMapping().termMappingRepresentation(relationship.getMappings()));
    }
}

