/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.BaseService;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyIdentified;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImp
implements BaseService {
    public static final String DEMOGRAPHIC = "DEMOGRAPHIC";
    public static final String PARTY = "PARTY";
    private final ServerConfig serverConfig;
    private final KnowledgeCacheService knowledgeCacheService;
    private final DSLContext context;
    private UUID systemId;
    @Autowired
    private IAuthenticationFacade authenticationFacade;

    public BaseServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        this.knowledgeCacheService = knowledgeCacheService;
        this.context = context;
        this.serverConfig = serverConfig;
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, this.knowledgeCacheService, this.knowledgeCacheService, this.serverConfig);
    }

    public UUID getSystemUuid() {
        if (this.systemId == null) {
            this.systemId = I_SystemAccess.createOrRetrieveLocalSystem(this.getDataAccess());
        }
        return this.systemId;
    }

    protected UUID getCurrentUserId() {
        String username = this.authenticationFacade.getAuthentication().getName();
        Optional<UUID> existingUser = new PersistedPartyIdentified(this.getDataAccess()).findInternalUserId(username);
        if (existingUser.isEmpty()) {
            return this.createInternalUser(username);
        }
        return existingUser.get();
    }

    protected UUID createInternalUser(String username) {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(username);
        identifier.setIssuer("EHRbase");
        identifier.setAssigner("EHRbase");
        identifier.setType("EHRbase Security Authentication User");
        PartyRef externalRef = new PartyRef((ObjectId)new GenericId(UUID.randomUUID().toString(), DEMOGRAPHIC), "User", PARTY);
        PartyIdentified user = new PartyIdentified(externalRef, "EHRbase Internal " + username, List.of(identifier));
        return new PersistedPartyIdentified(this.getDataAccess()).store((PartyProxy)user);
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

