/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import javax.sql.DataSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.SQLDialect;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@org.springframework.context.annotation.Configuration
@EnableTransactionManagement
public class PersistenceConfig {
    @Qualifier(value="dataSource")
    @Autowired
    private DataSource dataSource;

    public TransactionAwareDataSourceProxy transactionAwareDataSource() {
        return new TransactionAwareDataSourceProxy(this.dataSource);
    }

    @Bean
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public DataSourceConnectionProvider connectionProvider() {
        return new DataSourceConnectionProvider((DataSource)this.transactionAwareDataSource());
    }

    @Bean
    public ExceptionTranslator exceptionTransformer() {
        return new ExceptionTranslator();
    }

    @Bean
    @Primary
    public DefaultDSLContext dsl() {
        return new DefaultDSLContext((Configuration)this.configuration());
    }

    @Bean
    public DefaultConfiguration configuration() {
        DefaultConfiguration jooqConfiguration = new DefaultConfiguration();
        jooqConfiguration.set((ConnectionProvider)this.connectionProvider());
        jooqConfiguration.set(new ExecuteListenerProvider[]{new DefaultExecuteListenerProvider((ExecuteListener)this.exceptionTransformer())});
        SQLDialect dialect = SQLDialect.POSTGRES;
        jooqConfiguration.set(dialect);
        return jooqConfiguration;
    }

    static class ExceptionTranslator
    extends DefaultExecuteListener {
        ExceptionTranslator() {
        }

        public void exception(ExecuteContext context) {
            SQLDialect dialect = context.configuration().dialect();
            SQLErrorCodeSQLExceptionTranslator translator = new SQLErrorCodeSQLExceptionTranslator(dialect.name());
            context.exception((RuntimeException)translator.translate("Access database using Jooq", context.sql(), context.sqlException()));
        }
    }
}

