/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.queryimpl.DataTypeFromTemplate;
import org.ehrbase.aql.sql.queryimpl.DefaultColumnId;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.IterativeNode;
import org.ehrbase.aql.sql.queryimpl.JqueryPath;
import org.ehrbase.aql.sql.queryimpl.JsonbFunctionCall;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiPath;
import org.ehrbase.aql.sql.queryimpl.NodePredicateCall;
import org.ehrbase.aql.sql.queryimpl.NormalizedRmAttributePath;
import org.ehrbase.aql.sql.queryimpl.ObjectQuery;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;
import org.ehrbase.aql.sql.queryimpl.WebTemplateAqlPath;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonbEntryQuery
extends ObjectQuery
implements IQueryImpl {
    public static final String MAGNITUDE = "magnitude";
    Logger logger = LoggerFactory.getLogger(JsonbEntryQuery.class);
    private static final String JSONB_PATH_SELECTOR_EXPR = " #>> '{";
    private static final String JSONB_AT_AT_SELECTOR_EXPR = " @@ '";
    private static final String JSONB_SELECTOR_COMPOSITION_OPEN = Tables.ENTRY.ENTRY_ + " #>> '{";
    public static final String JSQUERY_COMPOSITION_OPEN = Tables.ENTRY.ENTRY_ + " @@ '";
    public static final String COMPOSITION = "composition";
    public static final String CONTENT = "content";
    public static final String ACTIVITIES = "activities";
    public static final String EVENTS = "events";
    public static final String ITEMS = "items";
    public static final String PROTOCOL = "protocol";
    public static final String DATA = "data";
    public static final String DESCRIPTION = "description";
    public static final String INSTRUCTION = "instruction";
    public static final String ACTIVITY = "activity";
    public static final String ENTRY1 = "entry";
    public static final String EVALUATION = "evaluation";
    public static final String OBSERVATION = "observation";
    public static final String ACTION = "action";
    public static final String VALUE = "value";
    public static final String DEFINING_CODE = "definingCode";
    public static final String TIME = "time";
    public static final String NAME = "name";
    public static final String ORIGIN = "origin";
    public static final String MAPPINGS = "mappings";
    public static final String PURPOSE = "purpose";
    public static final String TARGET = "target";
    public static final String TERMINOLOGY_ID = "terminologyId";
    private static final String JSONB_SELECTOR_CLOSE = "}'";
    public static final String JSQUERY_CLOSE = " '::jsquery";
    public static final String TAG_ACTIVITIES = "/activities";
    public static final String TAG_EVENTS = "/events";
    public static final String TAG_COMPOSITION = "/composition";
    public static final String TAG_CONTENT = "/content";
    public static final String TAG_ITEMS = "/items";
    private static final String[] listIdentifier = new String[]{"/content", "/items", "/activities", "/events"};
    private boolean ignoreUnresolvedIntrospect = false;
    private static final String ENV_IGNORE_UNRESOLVED_INTROSPECT = "aql.ignoreUnresolvedIntrospect";
    private final IntrospectService introspectCache;

    public JsonbEntryQuery(I_DomainAccess domainAccess, IntrospectService introspectCache, PathResolver pathResolver) {
        super(domainAccess, pathResolver);
        this.introspectCache = introspectCache;
        this.ignoreUnresolvedIntrospect = Boolean.parseBoolean(System.getProperty(ENV_IGNORE_UNRESOLVED_INTROSPECT, "false"));
    }

    private int retrieveIndex(String nodeId) {
        if (nodeId.contains("#")) {
            return Integer.parseInt(nodeId.split("#")[1].split("']")[0]);
        }
        return 0;
    }

    @Override
    public MultiFields makeField(String templateId, String identifier, I_VariableDefinition variableDefinition, IQueryImpl.Clause clause) throws UnknownVariableException {
        String alias;
        Set<String> pathSet;
        boolean setReturningFunctionInWhere = false;
        boolean isRootContent = false;
        DataType castTypeAs = null;
        if (this.pathResolver.entryRoot(templateId) == null) {
            return null;
        }
        if (variableDefinition.getPath() != null && variableDefinition.getPath().startsWith(CONTENT)) {
            pathSet = new MultiPath().asSet("/" + variableDefinition.getPath());
            isRootContent = true;
        } else {
            pathSet = this.pathResolver.pathOf(templateId, variableDefinition.getIdentifier());
        }
        String string = alias = clause.equals((Object)IQueryImpl.Clause.WHERE) ? null : variableDefinition.getAlias();
        if (pathSet == null || pathSet.isEmpty()) {
            throw new UnknownVariableException(variableDefinition.getPath());
        }
        ArrayList<QualifiedAqlField> fieldList = new ArrayList<QualifiedAqlField>();
        WebTemplate webTemplate = this.introspectCache.getQueryOptMetaData(templateId);
        if (webTemplate == null) {
            throw new UnknownVariableException("unknown template:" + templateId);
        }
        for (String path : pathSet) {
            boolean isSetReturningFunction;
            if (!WebTemplateAqlPath.isValid(webTemplate, path, variableDefinition.getPath())) {
                if (clause.equals((Object)IQueryImpl.Clause.WHERE)) continue;
                throw new UnknownVariableException(path);
            }
            String rightMostJsonbExpression = null;
            List<String> itemPathArray = new ArrayList<String>();
            itemPathArray.add(this.pathResolver.entryRoot(templateId));
            if (!path.startsWith(TAG_COMPOSITION) && !isRootContent) {
                itemPathArray.addAll(new JqueryPath(PATH_PART.IDENTIFIER_PATH_PART, path, "0").evaluate());
            }
            JqueryPath jqueryPath = new JqueryPath(PATH_PART.VARIABLE_PATH_PART, variableDefinition.getPath(), "0");
            itemPathArray.addAll(new NormalizedRmAttributePath(jqueryPath.evaluate()).transformStartingAt(1));
            try {
                IterativeNode iterativeNode = new IterativeNode(this.domainAccess, templateId, this.introspectCache);
                itemPathArray = iterativeNode.insertIterativeMarkers(itemPathArray);
                if (clause.equals((Object)IQueryImpl.Clause.WHERE)) {
                    setReturningFunctionInWhere = true;
                }
            }
            catch (Exception iterativeNode) {
                // empty catch block
            }
            this.resolveArrayIndex(itemPathArray);
            ArrayList<String> referenceItemPathArray = new ArrayList<String>(itemPathArray);
            Collections.replaceAll(referenceItemPathArray, "$AQL_NODE_ITERATIVE$", "0");
            if (itemPathArray.contains("$AQL_NODE_NAME_PREDICATE$")) {
                itemPathArray = new NodePredicateCall(itemPathArray).resolve();
                isSetReturningFunction = false;
            } else if (itemPathArray.contains("$AQL_NODE_ITERATIVE$")) {
                JsonbFunctionCall jsonbFunctionCall = new JsonbFunctionCall(itemPathArray, "$AQL_NODE_ITERATIVE$", "ehr.xjsonb_array_elements");
                itemPathArray = jsonbFunctionCall.resolve();
                if (jsonbFunctionCall.hasRightMostJsonbExpression()) {
                    rightMostJsonbExpression = jsonbFunctionCall.getRightMostJsonbExpression();
                }
                isSetReturningFunction = true;
            } else {
                isSetReturningFunction = false;
            }
            String itemPath = String.join((CharSequence)",", itemPathArray);
            if (!itemPath.startsWith("ehr.aql_node_name_predicate") && !itemPath.contains("ehr.xjsonb_array_elements")) {
                itemPath = JsonbEntryQuery.wrapQuery(itemPath);
            }
            DataTypeFromTemplate dataTypeFromTemplate = new DataTypeFromTemplate(this.introspectCache, this.ignoreUnresolvedIntrospect, clause);
            dataTypeFromTemplate.evaluate(templateId, referenceItemPathArray);
            Field fieldPathItem = null;
            castTypeAs = isSetReturningFunction ? null : dataTypeFromTemplate.getIdentifiedType();
            variableDefinition.setSelectType(dataTypeFromTemplate.getIdentifiedType());
            if (clause.equals((Object)IQueryImpl.Clause.SELECT)) {
                if (StringUtils.isNotEmpty((CharSequence)alias)) {
                    fieldPathItem = this.buildFieldWithCast(itemPath, castTypeAs, alias);
                } else {
                    String tempAlias = DefaultColumnId.value(variableDefinition);
                    fieldPathItem = this.buildFieldWithCast(itemPath, castTypeAs, tempAlias);
                }
            } else if (clause.equals((Object)IQueryImpl.Clause.WHERE)) {
                fieldPathItem = this.buildFieldWithCast(itemPath, castTypeAs, null);
                if (itemPathArray.contains("$AQL_NODE_ITERATIVE$")) {
                    fieldPathItem = DSL.field((Select)DSL.select(fieldPathItem));
                }
            }
            if (setReturningFunctionInWhere) {
                fieldPathItem = DSL.select(fieldPathItem).asField();
            }
            QualifiedAqlField aqlField = new QualifiedAqlField(fieldPathItem, dataTypeFromTemplate.getItemType(), dataTypeFromTemplate.getItemCategory(), rightMostJsonbExpression);
            fieldList.add(aqlField);
        }
        return new MultiFields(variableDefinition, fieldList, templateId);
    }

    private Field<?> buildFieldWithCast(String itemPath, DataType castTypeAs, String alias) {
        Field fieldPathItem = castTypeAs != null ? DSL.field((String)itemPath, String.class).cast(castTypeAs).as(alias) : DSL.field((String)itemPath, String.class).as(alias);
        if (alias != null) {
            fieldPathItem = fieldPathItem.as(alias);
        }
        return fieldPathItem;
    }

    @Override
    public MultiFields whereField(String templateId, String identifier, I_VariableDefinition variableDefinition) {
        Set<String> pathSet = this.pathResolver.pathOf(templateId, variableDefinition.getIdentifier());
        ArrayList<QualifiedAqlField> fieldList = new ArrayList<QualifiedAqlField>();
        for (String path : pathSet) {
            ArrayList<String> itemPathArray = new ArrayList<String>();
            if (this.pathResolver.entryRoot(templateId) == null) {
                throw new IllegalArgumentException("a name/value expression for composition must be specified, where clause cannot be built without");
            }
            itemPathArray.add(this.pathResolver.entryRoot(templateId));
            if (path != null && !path.startsWith(TAG_COMPOSITION)) {
                itemPathArray.addAll(new JqueryPath(PATH_PART.IDENTIFIER_PATH_PART, path, "#").evaluate());
            }
            JqueryPath jqueryPath = new JqueryPath(PATH_PART.VARIABLE_PATH_PART, variableDefinition.getPath(), "#");
            itemPathArray.addAll(jqueryPath.evaluate());
            String jsqueryPath = itemPathArray.stream().map(p -> {
                switch (p) {
                    case "0": 
                    case "#": {
                        return "#";
                    }
                }
                return "\"" + p + "\"";
            }).collect(Collectors.joining("."));
            Field fieldPathItem = DSL.field((String)jsqueryPath, String.class);
            QualifiedAqlField qualifiedAqlField = new QualifiedAqlField(fieldPathItem);
            fieldList.add(qualifiedAqlField);
        }
        return new MultiFields(variableDefinition, fieldList, templateId);
    }

    private void resolveArrayIndex(List<String> itemPathArray) {
        for (int i = 0; i < itemPathArray.size(); ++i) {
            String nodeId = itemPathArray.get(i);
            if (!nodeId.contains("#")) continue;
            int index = this.retrieveIndex(nodeId);
            if (i - 1 >= 0) {
                itemPathArray.set(i - 1, Integer.toString(index));
            }
            itemPathArray.set(i, nodeId);
        }
    }

    private static String wrapQuery(String itemPath) {
        if (itemPath.contains("/item_count")) {
            Object[] segments = itemPath.split("(?=(,[0-9]*,))");
            String pathPart = StringUtils.join((Object[])segments, null, (int)0, (int)(segments.length - 1));
            return "ehr.xjsonb_array_elements(content #> '{" + pathPart + "}')";
        }
        return JSONB_SELECTOR_COMPOSITION_OPEN + itemPath + JSONB_SELECTOR_CLOSE;
    }

    public static enum OTHER_ITEM {
        OTHER_DETAILS,
        OTHER_CONTEXT;

    }

    public static enum PATH_PART {
        IDENTIFIER_PATH_PART,
        VARIABLE_PATH_PART;

    }
}

