/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.impl.DSL;

public class NodePredicateCall {
    List<String> itemPathArray;

    public NodePredicateCall(List<String> itemPathArray) {
        this.itemPathArray = itemPathArray;
    }

    public List<String> resolve() {
        List<String> resultList = new ArrayList<String>();
        resultList.addAll(this.patchItemArray(this.itemPathArray));
        while (resultList.contains("$AQL_NODE_NAME_PREDICATE$")) {
            resultList = this.resolveNodePredicateCall(resultList);
        }
        return resultList;
    }

    private List<String> resolveNodePredicateCall(List<String> itemPathArray) {
        int startList;
        long namePredicateCount = IterableUtils.countMatches(itemPathArray, "$AQL_NODE_NAME_PREDICATE$"::equals);
        if (namePredicateCount == 0L) {
            return itemPathArray;
        }
        StringBuilder expression = new StringBuilder();
        expression.append("ehr.aql_node_name_predicate");
        expression.append("(");
        if (!itemPathArray.get(0).startsWith("(ehr.aql_node_name_predicate")) {
            expression.append(Tables.ENTRY.ENTRY_);
            startList = 0;
        } else {
            expression.append(itemPathArray.get(0));
            startList = 1;
        }
        expression.append(",");
        int markerPos = itemPathArray.subList(startList, itemPathArray.size()).indexOf("$AQL_NODE_NAME_PREDICATE$");
        markerPos = markerPos < 0 ? itemPathArray.size() : (markerPos += startList);
        expression.append(itemPathArray.get(markerPos + 1));
        expression.append(",");
        expression.append("'");
        expression.append(itemPathArray.subList(startList, markerPos).stream().collect(Collectors.joining(",")));
        expression.append("'");
        expression.append(")");
        ArrayList<String> resultList = new ArrayList<String>();
        if (namePredicateCount > 1L) {
            int endPos = markerPos + 1 + itemPathArray.subList(markerPos + 1, itemPathArray.size()).indexOf("$AQL_NODE_NAME_PREDICATE$");
            this.appendRightPathExpression(itemPathArray, expression, markerPos, endPos, false);
            resultList.add(DSL.field((String)("(" + expression.toString() + ")::jsonb")).toString());
            resultList.addAll(itemPathArray.subList(endPos, itemPathArray.size()));
        } else {
            int endPos = itemPathArray.size();
            if (markerPos + 2 < endPos) {
                this.appendRightPathExpression(itemPathArray, expression, markerPos, endPos, true);
            }
            resultList.add(expression.toString());
        }
        return resultList;
    }

    private StringBuilder appendRightPathExpression(List<String> itemPathArray, StringBuilder expression, int from, int to, boolean resolveAsText) {
        expression.append(resolveAsText ? "#>>" : "#>");
        expression.append("'");
        expression.append("{");
        expression.append(StringUtils.join((Object[])itemPathArray.subList(itemPathArray.get(from + 2).matches("[0-9]*|#") ? from + 3 : from + 2, to).toArray(String[]::new), (String)","));
        expression.append("}");
        expression.append("'");
        return expression;
    }

    private List<String> patchItemArray(List<String> itemPathArray) {
        ArrayList<String> items = new ArrayList<String>();
        for (String item : itemPathArray) {
            if (item.equals("$AQL_NODE_ITERATIVE$")) {
                items.add("0");
                continue;
            }
            items.add(item);
        }
        return items;
    }
}

