/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.dao.access.jooq.AdminApiUtils;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.FolderHistoryAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.dao.access.util.FolderUtils;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.jooq.binding.OtherDetailsJsonbBinder;
import org.ehrbase.jooq.binding.SysPeriodBinder;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionChangeType;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.Folder;
import org.ehrbase.jooq.pg.tables.FolderHierarchy;
import org.ehrbase.jooq.pg.tables.FolderItems;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.jooq.pg.tables.records.FolderHierarchyRecord;
import org.ehrbase.jooq.pg.tables.records.FolderHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.FolderItemsRecord;
import org.ehrbase.jooq.pg.tables.records.FolderRecord;
import org.ehrbase.jooq.pg.tables.records.ObjectRefRecord;
import org.ehrbase.util.UuidGenerator;
import org.joda.time.DateTime;
import org.jooq.Attachable;
import org.jooq.Condition;
import org.jooq.Converter;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record9;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.IdentityConverter;

public class FolderAccess
extends DataAccess
implements I_FolderAccess,
Comparable<FolderAccess> {
    public static final String SUBFOLDERS = "subfolders";
    public static final String PARENT_FOLDER = "parent_folder";
    public static final String CHILD_FOLDER = "child_folder";
    public static final String CALLED_INVALID_ACCESS_LAYER_METHOD = "Called invalid access layer method.";
    private final List<ObjectRef<? extends ObjectId>> items = new ArrayList<ObjectRef<? extends ObjectId>>();
    private final Map<UUID, I_FolderAccess> subfoldersList = new TreeMap<UUID, I_FolderAccess>();
    private I_ContributionAccess contributionAccess;
    private I_AuditDetailsAccess auditDetailsAccess;
    private UUID ehrId;
    private FolderRecord folderRecord;
    private static final String ERR_NO_FOLDER = "No folder[%s] found";

    public static boolean isDeleted(I_DomainAccess domainAccess, UUID versionedObjectId) {
        if (domainAccess.getContext().fetchExists((Table)Tables.FOLDER, Tables.FOLDER.ID.eq((Object)versionedObjectId))) {
            return false;
        }
        if (!domainAccess.getContext().fetchExists((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)versionedObjectId))) {
            throw new ObjectNotFoundException("folder", String.format(ERR_NO_FOLDER, versionedObjectId));
        }
        Result historyRecordsRes = domainAccess.getContext().selectFrom((Table)Tables.FOLDER_HISTORY).where(Tables.FOLDER_HISTORY.ID.eq((Object)versionedObjectId)).orderBy((OrderField)Tables.FOLDER_HISTORY.SYS_TRANSACTION.desc()).fetch();
        AuditDetailsRecord audit = (AuditDetailsRecord)domainAccess.getContext().fetchOne((Table)Tables.AUDIT_DETAILS, Tables.AUDIT_DETAILS.ID.eq((Object)((FolderHistoryRecord)historyRecordsRes.get(0)).getHasAudit()));
        if (audit == null) {
            throw new InternalServerException("DB inconsistency: couldn't retrieve referenced audit");
        }
        if (audit.getChangeType().equals((Object)ContributionChangeType.deleted)) {
            return true;
        }
        throw new InternalServerException("Problem processing FolderAccess.isDeleted(..)");
    }

    FolderAccess(I_DomainAccess domainAccess, String tenantIdentifier) {
        super(domainAccess);
        this.init(null, tenantIdentifier);
    }

    private FolderAccess(I_DomainAccess domainAccess, UUID ehrId, I_ContributionAccess contributionAccess, String tenantIdentifier) {
        super(domainAccess);
        this.ehrId = ehrId;
        this.init(contributionAccess, tenantIdentifier);
    }

    private void init(I_ContributionAccess contributionAccess, String tenantIdentifier) {
        this.folderRecord = (FolderRecord)this.getContext().newRecord((Table)Folder.FOLDER);
        if (contributionAccess != null) {
            this.contributionAccess = contributionAccess;
            this.folderRecord.setNamespace(contributionAccess.getNamespace());
        } else {
            this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrId, tenantIdentifier);
            this.folderRecord.setNamespace(tenantIdentifier);
        }
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess(), tenantIdentifier);
    }

    @Override
    public boolean update(LocalDateTime transactionTime, UUID systemId, UUID committerId, String description, I_ConceptAccess.ContributionChangeType changeType) {
        UUID oldContribution = this.folderRecord.getInContribution();
        UUID contributionAccessEhrId = this.contributionAccess.getEhrId();
        if (this.contributionAccess.getEhrId() == null) {
            ContributionRecord rec = (ContributionRecord)this.getContext().fetchOne((Table)Tables.CONTRIBUTION, Tables.CONTRIBUTION.ID.eq((Object)oldContribution));
            contributionAccessEhrId = rec.getEhrId();
        }
        this.contributionAccess.setEhrId(contributionAccessEhrId);
        this.contributionAccess.commit(Timestamp.valueOf(transactionTime), committerId, systemId, ContributionDataType.folder, ContributionDef.ContributionState.COMPLETE, changeType, description);
        this.getFolderRecord().setInContribution(this.contributionAccess.getId());
        UUID newContribution = this.folderRecord.getInContribution();
        return this.internalUpdate(Timestamp.valueOf(transactionTime), true, null, oldContribution, newContribution, systemId, committerId, description, changeType);
    }

    @Override
    public boolean update(LocalDateTime transactionTime, UUID contribution) {
        UUID oldContribution = this.folderRecord.getInContribution();
        this.getFolderRecord().setInContribution(contribution);
        UUID newContribution = this.folderRecord.getInContribution();
        I_ContributionAccess newContributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), newContribution);
        UUID systemId = newContributionAccess.getAuditsSystemId();
        UUID committerId = newContributionAccess.getAuditsCommitter();
        String description = newContributionAccess.getAuditsDescription();
        I_ConceptAccess.ContributionChangeType changeType = newContributionAccess.getAuditsChangeType();
        return this.internalUpdate(Timestamp.valueOf(transactionTime), true, null, oldContribution, newContribution, systemId, committerId, description, changeType);
    }

    private Boolean internalUpdate(Timestamp transactionTime, boolean rootFolder, UUID parentFolder, UUID oldContribution, UUID newContribution, UUID systemId, UUID committerId, String description, I_ConceptAccess.ContributionChangeType contributionChangeType) {
        boolean result;
        UUID oldFolderId = this.getFolderId();
        this.setInContribution(newContribution);
        this.auditDetailsAccess = new AuditDetailsAccess(this, this.getFolderRecord().getNamespace());
        this.auditDetailsAccess.setSystemId(systemId);
        this.auditDetailsAccess.setCommitter(committerId);
        this.auditDetailsAccess.setDescription(description);
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType));
        UUID auditId = this.auditDetailsAccess.commit();
        if (rootFolder) {
            this.folderRecord.setInContribution(newContribution);
            this.folderRecord.setSysTransaction(transactionTime);
            this.getContext().attach(new Attachable[]{this.folderRecord});
            result = this.folderRecord.update() > 0;
        } else {
            FolderRecord updatedFolderRecord = new FolderRecord();
            updatedFolderRecord.setInContribution(newContribution);
            updatedFolderRecord.setName(this.getFolderName());
            updatedFolderRecord.setArchetypeNodeId(this.getFolderArchetypeNodeId());
            updatedFolderRecord.setActive(Boolean.valueOf(this.isFolderActive()));
            updatedFolderRecord.setDetails(this.getFolderDetails());
            updatedFolderRecord.setSysTransaction(transactionTime);
            updatedFolderRecord.setSysPeriod(this.getFolderSysPeriod());
            updatedFolderRecord.setHasAudit(auditId);
            updatedFolderRecord.setNamespace(this.getFolderRecord().getNamespace());
            this.getContext().attach(new Attachable[]{updatedFolderRecord});
            result = updatedFolderRecord.insert() > 0;
            this.folderRecord = updatedFolderRecord;
            FolderHierarchyRecord updatedFhR = new FolderHierarchyRecord();
            updatedFhR.setParentFolder(parentFolder);
            updatedFhR.setChildFolder(updatedFolderRecord.getId());
            updatedFhR.setInContribution(newContribution);
            updatedFhR.setSysTransaction(transactionTime);
            updatedFhR.setSysPeriod(this.folderRecord.getSysPeriod());
            updatedFhR.setNamespace(this.getFolderRecord().getNamespace());
            this.getContext().attach(new Attachable[]{updatedFhR});
            updatedFhR.store();
        }
        UUID updatedFolderId = this.folderRecord.getId();
        this.getDataAccess().getContext().delete((Table)FolderItems.FOLDER_ITEMS).where(FolderItems.FOLDER_ITEMS.FOLDER_ID.eq((Object)oldFolderId)).execute();
        this.saveFolderItems(updatedFolderId, oldContribution, newContribution, transactionTime, this.getContext(), this.getFolderRecord().getNamespace());
        boolean anySubfolderModified = this.getSubfoldersList().values().stream().map(subfolder -> ((FolderAccess)subfolder).internalUpdate(transactionTime, false, updatedFolderId, oldContribution, newContribution, systemId, committerId, description, contributionChangeType)).reduce((b1, b2) -> b1 != false || b2 != false).orElse(false);
        return result || anySubfolderModified;
    }

    private void saveFolderItems(UUID folderId, UUID oldContribution, UUID newContribution, Timestamp transactionTime, DSLContext context, String tenantIdentifier) {
        for (ObjectRef<? extends ObjectId> or : this.getItems()) {
            ObjectRefRecord orr = new ObjectRefRecord(or.getNamespace(), or.getType(), UUID.fromString(or.getId().getValue()), newContribution, transactionTime, this.folderRecord.getSysPeriod(), tenantIdentifier);
            context.attach(new Attachable[]{orr});
            orr.store();
            FolderItemsRecord fir = new FolderItemsRecord(folderId, UUID.fromString(or.getId().getValue()), newContribution, transactionTime, this.folderRecord.getSysPeriod(), tenantIdentifier);
            context.attach(new Attachable[]{fir});
            fir.store();
        }
    }

    @Override
    public UUID commit(LocalDateTime transactionTime, UUID systemId, UUID committerId, String description) {
        this.contributionAccess.commit(Timestamp.valueOf(transactionTime), committerId, systemId, ContributionDataType.folder, ContributionDef.ContributionState.COMPLETE, I_ConceptAccess.ContributionChangeType.CREATION, description);
        return this.commit(transactionTime, this.contributionAccess.getContributionId());
    }

    @Override
    public UUID commit(LocalDateTime transactionTime, UUID contributionId) {
        this.getFolderRecord().setInContribution(contributionId);
        I_ContributionAccess inputContributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId);
        this.auditDetailsAccess = new AuditDetailsAccess(this, this.getFolderRecord().getNamespace());
        this.auditDetailsAccess.setSystemId(inputContributionAccess.getAuditsSystemId());
        this.auditDetailsAccess.setCommitter(inputContributionAccess.getAuditsCommitter());
        this.auditDetailsAccess.setDescription(inputContributionAccess.getAuditsDescription());
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        UUID auditId = this.auditDetailsAccess.commit();
        this.setAudit(auditId);
        this.getFolderRecord().store();
        this.saveFolderItems(this.getFolderRecord().getId(), contributionId, contributionId, Timestamp.valueOf(transactionTime), this.getContext(), this.getFolderRecord().getNamespace());
        this.getSubfoldersList().values().forEach(child -> {
            child.commit(transactionTime, contributionId);
            FolderHierarchyRecord fhRecord = this.buildFolderHierarchyRecord(this.getFolderRecord().getId(), ((FolderAccess)child).getFolderRecord().getId(), contributionId, Timestamp.valueOf(transactionTime));
            fhRecord.store();
        });
        return this.getFolderRecord().getId();
    }

    public static I_FolderAccess retrieveInstanceForExistingFolder(I_DomainAccess domainAccess, UUID folderId) {
        Table sfTable = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY));
        Table folderTable = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER)).as("t_folder1");
        Table folderTable2 = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER)).as("t_folder2");
        Table initialTable = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY).where(Tables.FOLDER_HIERARCHY.PARENT_FOLDER.eq((Object)folderId)));
        Field subfolderChildFolder = DSL.field((String)"subfolders.{0}", (DataType)Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getDataType(), (QueryPart[])new QueryPart[]{Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getUnqualifiedName()});
        Result folderSelectedRecordSub = domainAccess.getContext().withRecursive(SUBFOLDERS).as((ResultQuery)DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])ArrayUtils.addAll((Object[])initialTable.fields(), (Object[])folderTable.fields()))).from((TableLike)initialTable).leftJoin((TableLike)folderTable).on(initialTable.field(PARENT_FOLDER, Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(folderTable.field("id", Tables.FOLDER.ID.getType()))).union((Select)DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])ArrayUtils.addAll((Object[])sfTable.fields(), (Object[])folderTable2.fields()))).from((TableLike)sfTable).innerJoin(SUBFOLDERS).on(sfTable.field(PARENT_FOLDER, Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(subfolderChildFolder)).leftJoin((TableLike)folderTable2).on(folderTable2.field("id", Tables.FOLDER.ID.getType()).eq(subfolderChildFolder)))).select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((Name)DSL.name((String)SUBFOLDERS))).fetch();
        TreeMap<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap = new TreeMap<UUID, Map<UUID, I_FolderAccess>>();
        for (Record rec : folderSelectedRecordSub) {
            if (!fHierarchyMap.containsKey(rec.getValue(PARENT_FOLDER, UUID.class))) {
                fHierarchyMap.put((UUID)rec.getValue(PARENT_FOLDER), new TreeMap());
            }
            ((Map)fHierarchyMap.get(rec.getValue(PARENT_FOLDER, UUID.class))).put((UUID)rec.getValue(CHILD_FOLDER), FolderAccess.buildFolderAccessFromFolderId((UUID)rec.getValue(CHILD_FOLDER), domainAccess, (Result<Record>)folderSelectedRecordSub));
        }
        return FolderAccess.buildFolderAccessHierarchy(fHierarchyMap, folderId, null, (Result<Record>)folderSelectedRecordSub, domainAccess);
    }

    public static Set<ObjectVersionId> retrieveFolderVersionIdsInContribution(I_DomainAccess domainAccess, UUID contribution, String nodeName) {
        HashSet folders = new HashSet();
        domainAccess.getContext().select((SelectField)Tables.FOLDER.ID).from((TableLike)Tables.FOLDER).where(Tables.FOLDER.IN_CONTRIBUTION.eq((Object)contribution)).fetch().forEach(rec -> folders.add((UUID)rec.value1()));
        domainAccess.getContext().select((SelectField)Tables.FOLDER_HISTORY.ID).from((TableLike)Tables.FOLDER_HISTORY).where(Tables.FOLDER_HISTORY.IN_CONTRIBUTION.eq((Object)contribution)).fetch().forEach(rec -> folders.add((UUID)rec.value1()));
        HashSet<ObjectVersionId> result = new HashSet<ObjectVersionId>();
        for (UUID folderId : folders) {
            Map<Record, Integer> map = FolderAccess.getVersionMapOfFolder(domainAccess, folderId);
            for (Map.Entry<Record, Integer> entry : map.entrySet()) {
                FolderRecord rec2;
                if (entry.getKey().getClass().equals(FolderRecord.class)) {
                    rec2 = (FolderRecord)entry.getKey();
                    if (!rec2.getInContribution().equals(contribution)) continue;
                    result.add(new ObjectVersionId(rec2.getId().toString() + "::" + nodeName + "::" + entry.getValue()));
                    continue;
                }
                if (!entry.getKey().getClass().equals(FolderHistoryRecord.class) || !(rec2 = (FolderHistoryRecord)entry.getKey()).getInContribution().equals(contribution)) continue;
                result.add(new ObjectVersionId(rec2.getId().toString() + "::" + nodeName + "::" + entry.getValue()));
            }
        }
        return result;
    }

    public static I_FolderAccess retrieveByVersion(I_DomainAccess domainAccess, UUID folderId, int version) {
        Integer lastestVersion = FolderAccess.getLastVersionNumber(domainAccess, folderId);
        if (lastestVersion == version) {
            return FolderAccess.retrieveInstanceForExistingFolder(domainAccess, folderId);
        }
        Map<Integer, Record> allVersions = FolderAccess.getVersionMapOfFolder(domainAccess, folderId).entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getValue(), e -> (Record)e.getKey()));
        if (!allVersions.containsKey(version)) {
            return null;
        }
        Record record = allVersions.get(version);
        Timestamp timestamp = (Timestamp)record.get((Field)Folder.FOLDER.SYS_TRANSACTION);
        I_FolderAccess retrieveInstanceForExistingFolder = FolderHistoryAccess.retrieveInstanceForExistingFolder(domainAccess, folderId, timestamp);
        return retrieveInstanceForExistingFolder;
    }

    private static Map<Record, Integer> getVersionMapOfFolder(I_DomainAccess domainAccess, UUID folderId) {
        HashMap<Record, Integer> versionMap = new HashMap<Record, Integer>();
        Integer versionCounter = FolderAccess.getLastVersionNumber(domainAccess, folderId);
        FolderRecord rec = (FolderRecord)domainAccess.getContext().fetchOne((Table)Tables.FOLDER, Tables.FOLDER.ID.eq((Object)folderId));
        if (rec != null) {
            versionMap.put((Record)rec, versionCounter);
            Integer n = versionCounter;
            versionCounter = versionCounter - 1;
            Integer n2 = versionCounter;
        }
        Result historyRecords = domainAccess.getContext().selectFrom((Table)Tables.FOLDER_HISTORY).where(Tables.FOLDER_HISTORY.ID.eq((Object)folderId)).orderBy((OrderField)Tables.FOLDER_HISTORY.SYS_TRANSACTION.desc()).fetch();
        for (FolderHistoryRecord historyRecord : historyRecords) {
            versionMap.put((Record)historyRecord, versionCounter);
            Integer n = versionCounter;
            Integer n3 = versionCounter = Integer.valueOf(versionCounter - 1);
        }
        if (versionCounter != 0) {
            throw new InternalServerException("Version Map generation failed");
        }
        return versionMap;
    }

    public static I_FolderAccess getNewFolderAccessInstance(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, DateTime dateTime, UUID ehrId, String tenantIdentifier) {
        return FolderAccess.buildFolderAccessTreeRecursively(domainAccess, folder, null, dateTime, ehrId, null, tenantIdentifier);
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID systemId, UUID committerId, String description) {
        this.contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), this.contributionAccess.getEhrId(), this.getFolderRecord().getNamespace());
        UUID contribution = this.contributionAccess.commit(TransactionTime.millis(), committerId, systemId, null, ContributionDef.ContributionState.COMPLETE, I_ConceptAccess.ContributionChangeType.DELETED, description);
        return this.delete(this.getFolderId(), contribution, systemId, committerId, description);
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID contribution) {
        I_ContributionAccess newContributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contribution);
        UUID systemId = newContributionAccess.getAuditsSystemId();
        UUID committerId = newContributionAccess.getAuditsCommitter();
        String description = newContributionAccess.getAuditsDescription();
        return this.delete(this.getFolderId(), contribution, systemId, committerId, description);
    }

    private Integer delete(UUID folderId, UUID contribution, UUID systemId, UUID committerId, String description) {
        if (folderId == null) {
            throw new IllegalArgumentException("The folder UID provided for performing a delete operation cannot be null.");
        }
        I_AuditDetailsAccess delAudit = I_AuditDetailsAccess.getInstance(this, systemId, committerId, I_ConceptAccess.ContributionChangeType.DELETED, description, this.folderRecord.getNamespace());
        UUID delAuditId = delAudit.commit();
        Result hierarchyRecord = this.getContext().fetch((Table)Tables.FOLDER_HIERARCHY, Tables.FOLDER_HIERARCHY.PARENT_FOLDER.eq((Object)folderId).or(Tables.FOLDER_HIERARCHY.CHILD_FOLDER.eq((Object)folderId)));
        Result itemsRecord = this.getContext().fetch((Table)Tables.FOLDER_ITEMS, Tables.FOLDER_ITEMS.FOLDER_ID.eq((Object)folderId));
        int result = 0;
        for (FolderHierarchyRecord rec : hierarchyRecord) {
            if (rec.getParentFolder().equals(folderId)) {
                result += this.delete(rec.getChildFolder(), contribution, systemId, committerId, description).intValue();
            }
            rec.delete();
        }
        for (FolderHierarchyRecord rec : itemsRecord) {
            rec.delete();
        }
        FolderRecord folderRec = (FolderRecord)this.getContext().fetchOne((Table)Tables.FOLDER, Tables.FOLDER.ID.eq((Object)folderId));
        this.newOrUpdate(folderRec, delAuditId, contribution);
        return result += folderRec.delete();
    }

    private void newOrUpdate(FolderRecord folderRecord, UUID delAuditId, UUID contrib) {
        Condition condition = Tables.FOLDER_HISTORY.ID.eq((Object)folderRecord.getId()).and(Tables.FOLDER_HISTORY.IN_CONTRIBUTION.eq((Object)contrib));
        FolderHistoryRecord record = (FolderHistoryRecord)this.getDataAccess().getContext().fetchOne((Table)Tables.FOLDER_HISTORY, condition);
        if (record == null) {
            this.populateChangesAndPersist((FolderHistoryRecord)this.getDataAccess().getContext().newRecord((Table)Tables.FOLDER_HISTORY), folderRecord, delAuditId, contrib);
        } else {
            this.populateChangesAndPersist(record, folderRecord, delAuditId, contrib);
        }
    }

    private void populateChangesAndPersist(FolderHistoryRecord trgt, FolderRecord src, UUID delAuditId, UUID contrib) {
        trgt.setId(src.getId());
        trgt.setInContribution(contrib);
        trgt.setName(src.getName());
        trgt.setArchetypeNodeId(src.getArchetypeNodeId());
        trgt.setNamespace(src.getNamespace());
        trgt.setActive(src.getActive());
        trgt.setDetails(src.getDetails());
        trgt.setHasAudit(delAuditId);
        trgt.setSysTransaction(TransactionTime.millis());
        trgt.setSysPeriod(new AbstractMap.SimpleEntry<OffsetDateTime, Object>(OffsetDateTime.now(), null));
        if (trgt.store() != 1) {
            throw new InternalServerException("DB inconsistency");
        }
    }

    private static I_FolderAccess buildFolderAccessHierarchy(Map<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap, UUID currentFolder, I_FolderAccess parentFa, Result<Record> folderSelectedRecordSub, I_DomainAccess domainAccess) {
        if (parentFa != null && parentFa.getSubfoldersList().containsKey(currentFolder)) {
            return parentFa.getSubfoldersList().get(currentFolder);
        }
        FolderAccess folderAccess = FolderAccess.buildFolderAccessFromFolderId(currentFolder, domainAccess, folderSelectedRecordSub);
        if (parentFa != null) {
            parentFa.getSubfoldersList().put(currentFolder, folderAccess);
        }
        if (fHierarchyMap.get(currentFolder) != null) {
            for (UUID newChild : fHierarchyMap.get(currentFolder).keySet()) {
                FolderAccess.buildFolderAccessHierarchy(fHierarchyMap, newChild, folderAccess, folderSelectedRecordSub, domainAccess);
            }
        }
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromGenericRecord(Record folderRecord, I_DomainAccess domainAccess) {
        UUID folderId = (UUID)folderRecord.get((Field)Folder.FOLDER.ID);
        UUID contributionId = (UUID)folderRecord.get((Field)Folder.FOLDER.IN_CONTRIBUTION);
        String tenantIdentifier = (String)folderRecord.get((Field)Folder.FOLDER.NAMESPACE);
        FolderAccess folderAccess = new FolderAccess(domainAccess, tenantIdentifier);
        folderAccess.folderRecord = new FolderRecord();
        folderAccess.folderRecord.setNamespace(tenantIdentifier);
        folderAccess.setFolderId(folderId);
        folderAccess.setInContribution(contributionId);
        folderAccess.setFolderName((String)folderRecord.get((Field)Folder.FOLDER.NAME));
        folderAccess.setFolderNArchetypeNodeId((String)folderRecord.get((Field)Folder.FOLDER.ARCHETYPE_NODE_ID));
        folderAccess.setIsFolderActive((Boolean)folderRecord.get((Field)Folder.FOLDER.ACTIVE));
        Object object = folderRecord.get(Folder.FOLDER.DETAILS.getName());
        if (object instanceof ItemStructure) {
            folderAccess.setFolderDetails((ItemStructure)folderRecord.get(Folder.FOLDER.DETAILS.getName(), (Converter)new IdentityConverter(ItemStructure.class)));
        } else {
            folderAccess.setFolderDetails((ItemStructure)folderRecord.get(Folder.FOLDER.DETAILS.getName(), new OtherDetailsJsonbBinder().converter()));
        }
        folderAccess.setFolderSysTransaction((Timestamp)folderRecord.get((Field)Folder.FOLDER.SYS_TRANSACTION));
        folderAccess.setFolderSysPeriod((AbstractMap.SimpleEntry)folderRecord.get(Folder.FOLDER.SYS_PERIOD.getName(), new SysPeriodBinder().converter()));
        folderAccess.getItems().addAll(FolderAccess.retrieveItemsByFolderAndContributionId(folderId, contributionId, domainAccess));
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromFolderRecord(FolderRecord folderRecord, I_DomainAccess domainAccess) {
        FolderAccess folderAccess = new FolderAccess(domainAccess, folderRecord.getNamespace());
        folderAccess.folderRecord = folderRecord;
        folderAccess.getItems().addAll(FolderAccess.retrieveItemsByFolderAndContributionId(folderRecord.getId(), folderRecord.getInContribution(), domainAccess));
        return folderAccess;
    }

    private static FolderAccess buildFolderAccessFromFolderId(UUID id, I_DomainAccess domainAccess, Result<Record> folderSelectedRecordSub) {
        for (Record current : folderSelectedRecordSub) {
            if (!current.getValue(PARENT_FOLDER).equals(id)) continue;
            return FolderAccess.buildFolderAccessFromGenericRecord(current, domainAccess);
        }
        FolderRecord folderSelectedRecord = (FolderRecord)domainAccess.getContext().selectFrom((Table)Tables.FOLDER).where(Tables.FOLDER.ID.eq((Object)id)).fetchOne();
        if (folderSelectedRecord == null || folderSelectedRecord.size() < 1) {
            throw new ObjectNotFoundException("folder", "Folder with id " + id + " could not be found");
        }
        return FolderAccess.buildFolderAccessFromFolderRecord(folderSelectedRecord, domainAccess);
    }

    public static I_FolderAccess buildPlainFolderAccess(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, Timestamp timestamp, UUID ehrId, I_ContributionAccess contributionAccess, String tenantIdentifier) {
        FolderAccess folderAccessInstance = new FolderAccess(domainAccess, ehrId, contributionAccess, tenantIdentifier);
        folderAccessInstance.setEhrId(ehrId);
        if (folder.getUid() != null) {
            UIDBasedId uid = folder.getUid();
            int i = uid.getValue().indexOf("::");
            String uidString = i < 0 ? uid.getValue() : uid.getValue().substring(0, i);
            folderAccessInstance.setFolderId(UUID.fromString(uidString));
        }
        folderAccessInstance.setInContribution(folderAccessInstance.getContributionAccess().getId());
        folderAccessInstance.setFolderName(folder.getName().getValue());
        folderAccessInstance.setFolderNArchetypeNodeId(folder.getArchetypeNodeId());
        folderAccessInstance.setIsFolderActive(true);
        folderAccessInstance.setFolderDetails(folder.getDetails());
        if (folder.getItems() != null && !folder.getItems().isEmpty()) {
            folderAccessInstance.getItems().addAll(folder.getItems());
        }
        folderAccessInstance.setFolderSysTransaction(new Timestamp(DateTime.now().getMillis()));
        return folderAccessInstance;
    }

    private static List<ObjectRef<?>> retrieveItemsByFolderAndContributionId(UUID folderId, UUID inContribution, I_DomainAccess domainAccess) {
        Result retrievedRecords = domainAccess.getContext().with("folderItemsSelect").as((ResultQuery)DSL.select((SelectField)Tables.FOLDER_ITEMS.OBJECT_REF_ID.as("object_ref_id"), (SelectField)Tables.FOLDER_ITEMS.IN_CONTRIBUTION.as("item_in_contribution")).from((TableLike)Tables.FOLDER_ITEMS).where(Tables.FOLDER_ITEMS.FOLDER_ID.eq((Object)folderId))).select(new SelectFieldOrAsterisk[0]).from(new TableLike[]{Tables.OBJECT_REF, DSL.table((Name)DSL.name((String)"folderItemsSelect"))}).where(DSL.field((Name)DSL.name((String)"object_ref_id"), (Class)Tables.FOLDER_ITEMS.OBJECT_REF_ID.getType()).eq((Field)Tables.OBJECT_REF.ID).and(DSL.field((Name)DSL.name((String)"item_in_contribution"), (Class)Tables.FOLDER_ITEMS.IN_CONTRIBUTION.getType()).eq((Field)Tables.OBJECT_REF.IN_CONTRIBUTION))).fetch();
        ArrayList result = new ArrayList();
        for (Record recordRecord : retrievedRecords) {
            Record9 recordParam = (Record9)recordRecord;
            ObjectRefRecord objectRef = new ObjectRefRecord();
            objectRef.setIdNamespace((String)recordParam.value1());
            objectRef.setType((String)recordParam.value2());
            objectRef.setId((UUID)recordParam.value3());
            objectRef.setInContribution((UUID)recordParam.value4());
            objectRef.setSysTransaction((Timestamp)recordParam.value5());
            objectRef.setSysPeriod((AbstractMap.SimpleEntry)new SysPeriodBinder().converter().from(recordParam.value6()));
            objectRef.setNamespace((String)recordParam.value7());
            objectRef.setId((UUID)recordParam.value8());
            result.add(FolderAccess.parseObjectRefRecordIntoObjectRef(objectRef));
        }
        return result;
    }

    private static ObjectRef<ObjectVersionId> parseObjectRefRecordIntoObjectRef(ObjectRefRecord objectRefRecord) {
        ObjectRef result = new ObjectRef();
        ObjectRefId oref = new ObjectRefId(objectRefRecord.getId().toString());
        result.setId((ObjectId)new ObjectVersionId(oref.getValue()));
        result.setType(objectRefRecord.getType());
        result.setNamespace(objectRefRecord.getIdNamespace());
        return result;
    }

    private static I_FolderAccess buildFolderAccessTreeRecursively(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder current, FolderAccess parent, DateTime dateTime, UUID ehrId, I_ContributionAccess contributionAccess, String tenantIdentifier) {
        if (parent != null && parent.getSubfoldersList().containsKey(UUID.fromString(current.getUid().getValue()))) {
            return parent.getSubfoldersList().get(current.getUid());
        }
        I_FolderAccess folderAccess = FolderAccess.buildPlainFolderAccess(domainAccess, current, Timestamp.from(Instant.now()), ehrId, contributionAccess, tenantIdentifier);
        if (parent != null) {
            parent.getSubfoldersList().put(((FolderAccess)folderAccess).getFolderRecord().getId(), folderAccess);
        }
        for (com.nedap.archie.rm.directory.Folder child : current.getFolders()) {
            FolderAccess.buildFolderAccessTreeRecursively(domainAccess, child, (FolderAccess)folderAccess, dateTime, ehrId, ((FolderAccess)folderAccess).getContributionAccess(), tenantIdentifier);
        }
        return folderAccess;
    }

    public static I_FolderAccess buildNewFolderAccessHierarchy(I_DomainAccess domainAccess, com.nedap.archie.rm.directory.Folder folder, Timestamp timeStamp, UUID ehrId, I_ContributionAccess contributionAccess, String tenantIdentifier) {
        I_FolderAccess folderAccess = FolderAccess.buildPlainFolderAccess(domainAccess, folder, timeStamp, ehrId, contributionAccess, tenantIdentifier);
        if (folder.getFolders() != null && !folder.getFolders().isEmpty()) {
            folder.getFolders().forEach(child -> {
                I_FolderAccess childFolderAccess = FolderAccess.buildNewFolderAccessHierarchy(domainAccess, child, timeStamp, ehrId, contributionAccess, tenantIdentifier);
                folderAccess.getSubfoldersList().put(UuidGenerator.randomUUID(), childFolderAccess);
            });
        }
        return folderAccess;
    }

    private FolderHierarchyRecord buildFolderHierarchyRecord(UUID parentFolder, UUID childFolder, UUID inContribution, Timestamp sysTransaction) {
        FolderHierarchyRecord fhRecord = (FolderHierarchyRecord)this.getContext().newRecord((Table)FolderHierarchy.FOLDER_HIERARCHY);
        fhRecord.setParentFolder(parentFolder);
        fhRecord.setChildFolder(childFolder);
        fhRecord.setInContribution(inContribution);
        fhRecord.setSysTransaction(sysTransaction);
        fhRecord.setNamespace(this.getFolderRecord().getNamespace());
        return fhRecord;
    }

    public static Integer getLastVersionNumber(I_DomainAccess domainAccess, ObjectVersionId folderId) {
        UUID folderUuid = FolderUtils.extractUuidFromObjectVersionId(folderId);
        return FolderAccess.getLastVersionNumber(domainAccess, folderUuid);
    }

    private static Integer getLastVersionNumber(I_DomainAccess domainAccess, UUID folderUuid) {
        if (!FolderAccess.hasPreviousVersion(domainAccess, folderUuid)) {
            return 1;
        }
        int versionCount = domainAccess.getContext().fetchCount((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderUuid));
        return versionCount + 1;
    }

    public static boolean hasPreviousVersion(I_DomainAccess domainAccess, UUID folderId) {
        return domainAccess.getContext().fetchExists((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderId));
    }

    public static int getVersionNumberAtTime(I_DomainAccess domainAccess, ObjectVersionId rootFolderId, Timestamp sysTransaction) {
        UUID folderUuid = FolderUtils.extractUuidFromObjectVersionId(rootFolderId);
        int folderCount = domainAccess.getContext().fetchCount((Table)Tables.FOLDER, Tables.FOLDER.ID.equal((Object)folderUuid).and(Tables.FOLDER.SYS_TRANSACTION.lessOrEqual((Object)sysTransaction)));
        int folderHistoryCount = domainAccess.getContext().fetchCount((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.equal((Object)folderUuid).and(Tables.FOLDER_HISTORY.SYS_TRANSACTION.lessOrEqual((Object)sysTransaction)));
        if (folderHistoryCount <= 0) {
            if (folderCount <= 0) {
                throw new ObjectNotFoundException("directory", "No folder found for " + rootFolderId + " at time " + sysTransaction.toLocalDateTime().toString());
            }
            return folderCount;
        }
        return folderHistoryCount + folderCount;
    }

    public static Timestamp getTimestampForVersion(I_DomainAccess domainAccess, ObjectVersionId rootFolderId, Integer version) {
        Result folderHistoryRecords;
        Timestamp timestamp = new Timestamp(new Date().getTime());
        UUID rootFolderUuid = FolderUtils.extractUuidFromObjectVersionId(rootFolderId);
        int currentVersion = FolderAccess.getVersionNumberAtTime(domainAccess, rootFolderId, timestamp);
        if (currentVersion > version && !(folderHistoryRecords = domainAccess.getContext().selectFrom((Table)Tables.FOLDER_HISTORY).where(Tables.FOLDER_HISTORY.ID.equal((Object)rootFolderUuid)).orderBy((OrderField)Tables.FOLDER_HISTORY.SYS_TRANSACTION.desc()).limit(currentVersion - version).fetch()).isEmpty()) {
            timestamp = (Timestamp)((FolderHistoryRecord)folderHistoryRecords.get(folderHistoryRecords.size() - 1)).get((Field)Tables.FOLDER_HISTORY.SYS_TRANSACTION);
        }
        return timestamp;
    }

    @Override
    public UUID getEhrId() {
        return this.ehrId;
    }

    public void setEhrId(UUID ehrId) {
        this.ehrId = ehrId;
    }

    public I_ContributionAccess getContributionAccess() {
        return this.contributionAccess;
    }

    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    FolderRecord getFolderRecord() {
        return this.folderRecord;
    }

    @Override
    public Map<UUID, I_FolderAccess> getSubfoldersList() {
        return this.subfoldersList;
    }

    @Override
    public List<ObjectRef<? extends ObjectId>> getItems() {
        return this.items;
    }

    @Override
    public UUID getFolderId() {
        return this.folderRecord.getId();
    }

    @Override
    public void setFolderId(UUID folderId) {
        this.folderRecord.setId(folderId);
    }

    @Override
    public UUID getInContribution() {
        return this.folderRecord.getInContribution();
    }

    @Override
    public void setInContribution(UUID inContribution) {
        this.folderRecord.setInContribution(inContribution);
    }

    @Override
    public String getFolderName() {
        return this.folderRecord.getName();
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderRecord.setName(folderName);
    }

    @Override
    public String getFolderArchetypeNodeId() {
        return this.folderRecord.getArchetypeNodeId();
    }

    @Override
    public void setFolderNArchetypeNodeId(String folderArchetypeNodeId) {
        this.folderRecord.setArchetypeNodeId(folderArchetypeNodeId);
    }

    @Override
    public boolean isFolderActive() {
        return this.folderRecord.getActive();
    }

    @Override
    public void setIsFolderActive(boolean folderActive) {
        this.folderRecord.setActive(Boolean.valueOf(folderActive));
    }

    @Override
    public ItemStructure getFolderDetails() {
        return this.folderRecord.getDetails();
    }

    @Override
    public void setFolderDetails(ItemStructure folderDetails) {
        this.folderRecord.setDetails(folderDetails);
    }

    @Override
    public void setFolderSysTransaction(Timestamp folderSysTransaction) {
        this.folderRecord.setSysTransaction(folderSysTransaction);
    }

    @Override
    public Timestamp getFolderSysTransaction() {
        return this.folderRecord.getSysTransaction();
    }

    @Override
    public AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> getFolderSysPeriod() {
        return this.folderRecord.getSysPeriod();
    }

    @Override
    public void setFolderSysPeriod(AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> folderSysPeriod) {
        this.folderRecord.setSysPeriod(folderSysPeriod);
    }

    @Override
    public UUID getAudit() {
        return this.getFolderRecord().getHasAudit();
    }

    @Override
    public void setAudit(UUID auditId) {
        this.getFolderRecord().setHasAudit(auditId);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public int compareTo(FolderAccess o) {
        return o.getFolderRecord().getId().compareTo(this.folderRecord.getId());
    }

    @Override
    public void adminDeleteFolder() {
        AdminApiUtils adminApi = new AdminApiUtils(this.getContext());
        adminApi.deleteFolder(this.getFolderId(), true);
    }

    @Override
    public Timestamp getSysTransaction() {
        return this.getFolderSysTransaction();
    }

    @Override
    public UUID getContributionId() {
        return this.getInContribution();
    }

    @Override
    public UUID getId() {
        return this.getFolderId();
    }

    public static class ObjectRefId
    extends ObjectId {
        public ObjectRefId(String value) {
            super(value);
        }
    }
}

