/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;

public class AsyncSqlQuery
implements Supplier<Map<String, Object>> {
    private final I_DomainAccess domainAccess;
    private final String queryString;

    public AsyncSqlQuery(I_DomainAccess domainAccess, String queryString) {
        this.domainAccess = domainAccess;
        this.queryString = queryString;
    }

    public Result<Record> fetchQueryResults() {
        try {
            return this.domainAccess.getContext().fetch(this.queryString);
        }
        catch (DataAccessException e) {
            throw new IllegalArgumentException("Error occurred while executing the SQL statement", e);
        }
    }

    public Map<String, Object> toJson(Result<Record> records) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("executedSQL", this.queryString);
        ArrayList resultList = new ArrayList();
        for (Record current : records) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (Field field : records.fields()) {
                fieldMap.put(field.getName(), current.getValue(field));
            }
            resultList.add(fieldMap);
        }
        resultMap.put("resultSet", resultList);
        return resultMap;
    }

    @Override
    public Map<String, Object> get() {
        Result<Record> records = this.fetchQueryResults();
        if (records != null && !records.isEmpty()) {
            return this.toJson(records);
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> fetch() throws InternalServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        CompletableFuture<Map<String, Object>> fetch = CompletableFuture.supplyAsync(this, executorService);
        try {
            return fetch.get();
        }
        catch (ExecutionException e) {
            throw new InternalServerException("fetching of async SQL query failed", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalServerException("ThreadDeath", (Throwable)e);
        }
    }
}

