/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.lang.management.ManagementFactory;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.StatusService;
import org.ehrbase.dao.access.interfaces.I_DatabaseStatusAccess;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StatusServiceImp
extends BaseServiceImp
implements StatusService {
    @Autowired
    private BuildProperties buildProperties;

    @Autowired
    public StatusServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext dslContext, ServerConfig serverConfig) {
        super(knowledgeCacheService, dslContext, serverConfig);
    }

    public String getOperatingSystemInformation() {
        return String.format("%s %s %s", ManagementFactory.getOperatingSystemMXBean().getName(), ManagementFactory.getOperatingSystemMXBean().getArch(), ManagementFactory.getOperatingSystemMXBean().getVersion());
    }

    public String getJavaVMInformation() {
        return String.format("%s %s", ManagementFactory.getRuntimeMXBean().getVmVendor(), ManagementFactory.getRuntimeMXBean().getSystemProperties().get("java.runtime.version"));
    }

    public String getDatabaseInformation() {
        return I_DatabaseStatusAccess.retrieveDatabaseVersion(this.getDataAccess());
    }

    public String getEhrbaseVersion() {
        return this.buildProperties.getVersion();
    }

    public String getArchieVersion() {
        return this.buildProperties.get("archie.version");
    }

    public String getOpenEHR_SDK_Version() {
        return this.buildProperties.get("openEHR_SDK.version");
    }
}

