/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.tenant.extraction;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.api.tenant.TenantIdExtractionStrategy;
import org.ehrbase.tenant.DefaultTenantAuthentication;

public class DefaultExtractionStrategy
implements TenantIdExtractionStrategy<String> {
    public boolean accept(Object ... args) {
        return true;
    }

    public Optional<TenantAuthentication<String>> extract(Object ... args) {
        String token = JWT.create().withClaim("tnt", TenantAuthentication.getDefaultTenantId()).sign((Algorithm)new NoneAlgorithm());
        return Optional.of(DefaultTenantAuthentication.ofToken(token));
    }

    public int priority() {
        return 0;
    }

    private static class NoneAlgorithm
    extends Algorithm {
        NoneAlgorithm() {
            super("none", "none");
        }

        public void verify(DecodedJWT jwt) throws SignatureVerificationException {
            byte[] signatureBytes = Base64.decodeBase64((String)jwt.getSignature());
            if (signatureBytes.length > 0) {
                throw new SignatureVerificationException((Algorithm)this);
            }
        }

        public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
            return new byte[0];
        }
    }
}

