/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import java.security.SecureRandom;
import java.util.UUID;

public class UuidGenerator {
    private static final int UUID_BYTECOUNT = 16;
    private static final ThreadLocal<UuidGenerator> GENERATORS = ThreadLocal.withInitial(UuidGenerator::new);
    private final SecureRandom numberGenerator = new SecureRandom();
    private final byte[] data = new byte[512];
    private int nextUuid = this.data.length;

    private UuidGenerator() {
    }

    public static UUID randomUUID() {
        return GENERATORS.get().randomUUIDInternal();
    }

    private UUID randomUUIDInternal() {
        this.ensureBatchAvailable();
        int pos = this.nextUuid;
        this.nextUuid += 16;
        return UuidGenerator.createUuid(this.data, pos);
    }

    private void ensureBatchAvailable() {
        if (this.nextUuid >= this.data.length) {
            this.numberGenerator.nextBytes(this.data);
            this.nextUuid = 0;
        }
    }

    private static UUID createUuid(byte[] data, int pos) {
        int i;
        UuidGenerator.engraveV4Bytes(data, pos);
        long msb = 0L;
        long lsb = 0L;
        int m = i + 8;
        for (i = pos; i < m; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        m = i + 8;
        while (i < m) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        return new UUID(msb, lsb);
    }

    private static void engraveV4Bytes(byte[] data, int offset) {
        int p8;
        int p6;
        int n = p6 = offset + 6;
        data[n] = (byte)(data[n] & 0xF);
        int n2 = p6;
        data[n2] = (byte)(data[n2] | 0x40);
        int n3 = p8 = offset + 8;
        data[n3] = (byte)(data[n3] & 0x3F);
        int n4 = p8;
        data[n4] = (byte)(data[n4] | 0x80);
    }
}

