/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ehrbase.aql.compiler.AqlExpression;

public class AqlExpressionWithParameters
extends AqlExpression {
    public static final String PARAMETERS_KEY = "query-parameters";

    public AqlExpressionWithParameters parse(String query, Map<String, Object> parameterValues) {
        String query1 = this.substitute(query, parameterValues);
        super.parse(query1);
        return this;
    }

    @Override
    public AqlExpressionWithParameters parse(String expression, String jsonParameterMap) {
        Gson gson = new GsonBuilder().create();
        Map parameterMap = (Map)gson.fromJson(jsonParameterMap, Map.class);
        if (!parameterMap.containsKey(PARAMETERS_KEY)) {
            throw new IllegalArgumentException("Json map does not contain query-parameters");
        }
        parameterMap = (Map)parameterMap.get(PARAMETERS_KEY);
        return this.parse(expression, parameterMap);
    }

    public String substitute(String query, Map<String, Object> parameterValues) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = Pattern.compile("\\$([\\w|\\-|_|]+)").matcher(query);
        while (matcher.find()) {
            String variable = matcher.group();
            if (parameterValues.get(variable.substring(1)) == null) {
                throw new IllegalArgumentException("Could not substitute parameter in AQL expression: '" + variable + "'");
            }
            Object parameterValue = parameterValues.get(variable.substring(1));
            if (this.isSingleQuotedArgument(parameterValue)) {
                parameterValue = "'" + parameterValue + "'";
            }
            matcher.appendReplacement(stringBuffer, String.valueOf(parameterValue));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private boolean isSingleQuotedArgument(Object parameterValue) {
        return parameterValue instanceof UUID || parameterValue instanceof String;
    }
}

