/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.ehrbase.aql.compiler.QueryCompilerPass1;
import org.ehrbase.aql.containment.ContainPropositions;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.service.KnowledgeCacheService;

public class Contains {
    private ParseTree parseTree;
    private IdentifierMapper identifierMapper;
    private Set<String> templates;
    private final KnowledgeCacheService knowledgeCache;
    private boolean requiresTemplateWhereClause = false;
    private boolean hasContains;

    public Contains(ParseTree parseTree, KnowledgeCacheService knowledgeCache) {
        this.parseTree = parseTree;
        this.knowledgeCache = knowledgeCache;
    }

    public Contains process() {
        QueryCompilerPass1 queryCompilerPass1 = new QueryCompilerPass1();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)queryCompilerPass1, this.parseTree);
        ContainPropositions containPropositions = queryCompilerPass1.containPropositions();
        containPropositions.evaluate(this.knowledgeCache);
        this.templates = containPropositions.resolvedTemplates();
        this.identifierMapper = queryCompilerPass1.getIdentifierMapper();
        this.requiresTemplateWhereClause = containPropositions.requiresTemplateWhereClause();
        this.hasContains = containPropositions.hasContains();
        return this;
    }

    public Set<String> getTemplates() {
        return this.templates;
    }

    public IdentifierMapper getIdentifierMapper() {
        return this.identifierMapper;
    }

    public boolean requiresTemplateWhereClause() {
        return this.requiresTemplateWhereClause;
    }

    public boolean hasContains() {
        return this.hasContains;
    }
}

