/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.compiler.TopAttributes;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.definition.Variables;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.aql.sql.QuerySteps;
import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.binding.LimitBinding;
import org.ehrbase.aql.sql.binding.OrderByField;
import org.ehrbase.aql.sql.binding.SelectBinder;
import org.ehrbase.aql.sql.binding.SuperQuery;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.binding.WhereMultiFields;
import org.ehrbase.aql.sql.postprocessing.RawJsonTransform;
import org.ehrbase.aql.sql.queryimpl.DurationFormatter;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMap;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMultiMap;
import org.ehrbase.aql.sql.queryimpl.TemplateMetaData;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.service.IntrospectService;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.JoinType;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
extends TemplateMetaData {
    public static final String NIL_TEMPLATE = "*";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final I_DomainAccess domainAccess;
    private final Contains contains;
    private Statements statements;
    private final String serverNodeId;
    private JoinSetup joinSetup = new JoinSetup();

    public QueryProcessor(I_DomainAccess domainAccess, IntrospectService introspectCache, Contains contains, Statements statements, String serverNodeId) {
        super(introspectCache);
        this.domainAccess = domainAccess;
        this.contains = contains;
        this.statements = statements;
        this.serverNodeId = serverNodeId;
    }

    public AqlResult execute() {
        AqlSelectQuery aqlSelectQuery = this.buildAqlSelectQuery();
        Result<Record> result = this.fetchResultSet((Select<?>)aqlSelectQuery.getSelectQuery(), null);
        RawJsonTransform.toRawJson(result);
        DurationFormatter.toISO8601(result);
        List<List<String>> explainList = this.buildExplain((Select<?>)aqlSelectQuery.getSelectQuery());
        return new AqlResult(result, explainList);
    }

    public AqlSelectQuery buildAqlSelectQuery() {
        LinkedHashMap<String, List<QuerySteps>> cacheQuery = new LinkedHashMap<String, List<QuerySteps>>();
        boolean containsJson = false;
        this.statements = new OrderByField(this.statements).merge();
        if (this.contains.getTemplates().isEmpty()) {
            if (this.contains.hasContains() && this.contains.requiresTemplateWhereClause()) {
                try {
                    cacheQuery.put(NIL_TEMPLATE, this.buildNullSelect());
                }
                catch (UnknownVariableException unknownVariableException) {}
            } else {
                try {
                    cacheQuery.put(NIL_TEMPLATE, this.buildQuerySteps(NIL_TEMPLATE));
                }
                catch (UnknownVariableException unknownVariableException) {}
            }
        } else {
            for (String templateId : this.contains.getTemplates()) {
                try {
                    cacheQuery.put(templateId, this.buildQuerySteps(templateId));
                }
                catch (UnknownVariableException e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Template {}: {}", (Object)templateId, (Object)e.getMessage());
                }
            }
        }
        SelectQuery<?> unionSetQuery = this.domainAccess.getContext().selectQuery();
        boolean first = true;
        for (List queryStepList : cacheQuery.values()) {
            for (QuerySteps queryStep : queryStepList) {
                Condition whereCondition;
                SelectQuery<?> select = queryStep.getSelectQuery();
                if (!queryStep.getTemplateId().equalsIgnoreCase(NIL_TEMPLATE)) {
                    this.joinSetup.setUseEntry(true);
                }
                JoinBinder joinBinder = new JoinBinder(this.domainAccess, this.joinSetup);
                select.addFrom((TableLike)joinBinder.initialFrom());
                select = joinBinder.addJoinClause(select);
                select = this.setLateralJoins(queryStep.getLateralJoins(), select);
                if (!queryStep.getTemplateId().equals(NIL_TEMPLATE)) {
                    select.addConditions(Tables.ENTRY.TEMPLATE_ID.eq((Object)queryStep.getTemplateId()));
                }
                if ((whereCondition = queryStep.getWhereCondition()) != null) {
                    select.addConditions(Operator.AND, whereCondition);
                }
                if (first) {
                    unionSetQuery = select;
                    first = false;
                    continue;
                }
                unionSetQuery.unionAll(select);
            }
        }
        SuperQuery superQuery = new SuperQuery(this.domainAccess, this.statements.getVariables(), unionSetQuery, containsJson);
        if (new Variables(this.statements.getVariables()).hasDefinedDistinct() || new Variables(this.statements.getVariables()).hasDefinedFunction()) {
            unionSetQuery = superQuery.select();
            if (this.statements.getOrderAttributes() != null && !this.statements.getOrderAttributes().isEmpty()) {
                unionSetQuery = superQuery.setOrderBy(this.statements.getOrderAttributes(), unionSetQuery);
            }
            containsJson = superQuery.isOutputWithJson();
        } else if (this.statements.getOrderAttributes() != null && !this.statements.getOrderAttributes().isEmpty()) {
            unionSetQuery = superQuery.selectOrderBy(this.statements.getOrderAttributes());
            containsJson = superQuery.isOutputWithJson();
        }
        LimitBinding limitBinding = new LimitBinding(Optional.ofNullable(this.statements.getTopAttributes()).map(TopAttributes::getWindow).orElse(this.statements.getLimitAttribute()), this.statements.getOffsetAttribute(), unionSetQuery);
        unionSetQuery = limitBinding.bind();
        return new AqlSelectQuery(unionSetQuery, cacheQuery.values(), containsJson);
    }

    private List<QuerySteps> buildQuerySteps(String templateId) throws UnknownVariableException {
        ArrayList<QuerySteps> queryStepsList = new ArrayList<QuerySteps>();
        WhereMultiFields whereMultiFields = new WhereMultiFields(this.domainAccess, this.introspectCache, this.contains, this.statements.getWhereClause(), this.serverNodeId);
        MultiFieldsMap multiWhereFieldsMap = new MultiFieldsMap(whereMultiFields.bind(templateId));
        this.joinSetup = this.joinSetup.merge(whereMultiFields.getJoinSetup());
        SelectBinder selectBinder = new SelectBinder(this.domainAccess, this.introspectCache, this.contains, this.statements, this.serverNodeId);
        MultiFieldsMultiMap multiSelectFieldsMap = new MultiFieldsMultiMap(selectBinder.bind(templateId));
        this.joinSetup = this.joinSetup.merge(selectBinder.getCompositionAttributeQuery().getJoinSetup());
        int selectCursor = 0;
        int selectCursorMax = multiSelectFieldsMap.upperPathBoundary();
        int whereCursorMax = multiWhereFieldsMap.upperPathBoundary();
        SelectQuery select = this.domainAccess.getContext().selectQuery();
        for (int whereCursor = 0; whereCursorMax == 0 || whereCursor < whereCursorMax; ++whereCursor) {
            while (selectCursor < selectCursorMax) {
                QuerySteps querySteps;
                Iterator<MultiFields> it = multiSelectFieldsMap.multiFieldsIterator();
                while (it.hasNext()) {
                    MultiFields multiSelectFields = it.next();
                    select.addSelect(new SelectFieldOrAsterisk[]{multiSelectFields.getQualifiedFieldOrLast(selectCursor).getSQLField()});
                }
                Condition condition = selectBinder.getWhereConditions(templateId, whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap);
                if (condition != null && condition.equals(DSL.falseCondition())) break;
                ArrayList<LateralJoinDefinition> joins = new ArrayList<LateralJoinDefinition>();
                joins.addAll(this.lateralJoinsSelectClause(NIL_TEMPLATE, 0));
                if (!templateId.equals(NIL_TEMPLATE)) {
                    joins.addAll(this.lateralJoinsSelectClause(templateId, selectCursor));
                    joins.addAll(this.lateralJoinsWhereClause(templateId, whereCursor));
                }
                if (QuerySteps.isIncludedInList(querySteps = new QuerySteps(select, condition, joins, templateId), queryStepsList)) {
                    ++selectCursor;
                    select = this.domainAccess.getContext().selectQuery();
                    continue;
                }
                queryStepsList.add(querySteps);
                ++selectCursor;
                select = this.domainAccess.getContext().selectQuery();
            }
            if (whereCursorMax == 0) break;
            selectCursor = 0;
            select = this.domainAccess.getContext().selectQuery();
        }
        return queryStepsList;
    }

    private SelectQuery<?> setLateralJoins(List<LateralJoinDefinition> lateralJoins, SelectQuery<?> selectQuery) {
        if (lateralJoins == null) {
            return selectQuery;
        }
        HashSet<Pair> usedLaterals = new HashSet<Pair>();
        for (LateralJoinDefinition lateralJoinDefinition : lateralJoins) {
            Pair key = Pair.of((Object)lateralJoinDefinition.getTable().getName(), (Object)lateralJoinDefinition.getLateralVariable());
            if (usedLaterals.contains(key)) continue;
            if (lateralJoinDefinition.getCondition() == null) {
                selectQuery.addJoin(lateralJoinDefinition.getTable(), lateralJoinDefinition.getJoinType(), new Condition[0]);
            } else {
                selectQuery.addJoin(lateralJoinDefinition.getTable(), lateralJoinDefinition.getJoinType(), lateralJoinDefinition.getCondition());
            }
            usedLaterals.add(key);
        }
        return selectQuery;
    }

    private List<LateralJoinDefinition> lateralJoinsSelectClause(String templateId, int cursor) {
        ArrayList<LateralJoinDefinition> lateralJoinsList = new ArrayList<LateralJoinDefinition>();
        VariableDefinitions it = this.statements.getVariables();
        while (it.hasNext()) {
            I_VariableDefinition item = it.next();
            if (!(item instanceof I_VariableDefinition) || !item.isLateralJoin(templateId)) continue;
            Set<LateralJoinDefinition> listOfLaterals = item.getLateralJoinDefinitions(templateId);
            int index = cursor < listOfLaterals.size() ? cursor : listOfLaterals.size() - 1;
            LateralJoinDefinition encapsulatedLateralJoinDefinition = item.getLateralJoinDefinition(templateId, index);
            LateralJoinDefinition lateralJoinDefinition = new LateralJoinDefinition(encapsulatedLateralJoinDefinition.getSqlExpression(), DSL.lateral(encapsulatedLateralJoinDefinition.getTable()), encapsulatedLateralJoinDefinition.getLateralVariable(), encapsulatedLateralJoinDefinition.getJoinType(), encapsulatedLateralJoinDefinition.getCondition(), encapsulatedLateralJoinDefinition.getClause());
            lateralJoinsList.add(lateralJoinDefinition);
        }
        return lateralJoinsList;
    }

    private List<LateralJoinDefinition> lateralJoinsWhereClause(String templateId, int cursor) {
        ArrayList<LateralJoinDefinition> lateralJoinsList = new ArrayList<LateralJoinDefinition>();
        for (Object item : this.statements.getWhereClause()) {
            if (!(item instanceof I_VariableDefinition) || !((I_VariableDefinition)item).isLateralJoin(templateId)) continue;
            LateralJoinDefinition lateralJoinDefinition = ((I_VariableDefinition)item).getLateralJoinDefinition(templateId, cursor);
            if (((I_VariableDefinition)item).getLateralJoinDefinitions(templateId) == null) {
                throw new IllegalStateException("unresolved lateral join for template: " + templateId + ", path:" + ((I_VariableDefinition)item).getPath());
            }
            if (cursor > ((I_VariableDefinition)item).getLateralJoinDefinitions(templateId).size() - 1 || lateralJoinDefinition.getClause().equals((Object)IQueryImpl.Clause.SELECT)) continue;
            lateralJoinsList.add(new LateralJoinDefinition(lateralJoinDefinition.getSqlExpression(), DSL.lateral(lateralJoinDefinition.getTable()), ((I_VariableDefinition)item).getSubstituteFieldVariable(), JoinType.JOIN, null, IQueryImpl.Clause.WHERE));
        }
        return lateralJoinsList;
    }

    private Result<Record> fetchResultSet(Select<?> select, Result<Record> result) {
        Result intermediary;
        try {
            intermediary = select.fetch();
        }
        catch (Exception e) {
            String reason = "Could not perform SQL query:" + e.getCause() + ", AQL expression:" + this.statements.getParsedExpression() + ", Translated SQL:" + select.getSQL();
            throw new IllegalArgumentException(reason);
        }
        if (result != null) {
            result.addAll((Collection)intermediary);
        } else if (intermediary != null) {
            result = intermediary;
        }
        return result;
    }

    private List<List<String>> buildExplain(Select<?> select) {
        ArrayList<List<String>> explainList = new ArrayList<List<String>>();
        DSLContext pretty = DSL.using((SQLDialect)this.domainAccess.getContext().dialect(), (Settings)new Settings().withRenderFormatted(Boolean.valueOf(true)));
        String sql = pretty.render(select);
        ArrayList<String> details = new ArrayList<String>();
        details.add(sql);
        for (Param parameter : select.getParams().values()) {
            details.add(parameter.getValue().toString());
        }
        explainList.add(details);
        return explainList;
    }

    private List<QuerySteps> buildNullSelect() throws UnknownVariableException {
        List<QuerySteps> queryStepsList = this.buildQuerySteps(NIL_TEMPLATE);
        for (QuerySteps querySteps : queryStepsList) {
            querySteps.setWhereCondition(DSL.condition((String)"1 = 0"));
        }
        return queryStepsList;
    }

    public static class AqlSelectQuery {
        private final SelectQuery<Record> selectQuery;
        private final Collection<List<QuerySteps>> querySteps;
        private boolean outputWithJson;

        AqlSelectQuery(SelectQuery<Record> selectQuery, Collection<List<QuerySteps>> querySteps, boolean outputWithJson) {
            this.selectQuery = selectQuery;
            this.querySteps = querySteps;
            this.outputWithJson = outputWithJson;
        }

        public SelectQuery<Record> getSelectQuery() {
            return this.selectQuery;
        }

        public boolean isOutputWithJson() {
            return this.outputWithJson;
        }

        Collection<List<QuerySteps>> getQuerySteps() {
            return this.querySteps;
        }
    }
}

