/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.definition.LateralVariable;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.jooq.JoinType;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectQuery;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class LateralJoins {
    private static int seed = 1;

    private LateralJoins() {
    }

    public static void create(String templateId, TaggedStringBuilder encodedVar, I_VariableDefinition item, IQueryImpl.Clause clause) {
        int hashValue;
        String originalSqlExpression = encodedVar.toString();
        if (originalSqlExpression.isBlank()) {
            return;
        }
        if (item.getLateralJoinDefinitions(templateId) != null && !item.getLateralJoinDefinitions(templateId).isEmpty()) {
            for (LateralJoinDefinition lateralJoinDefinition : item.getLateralJoinDefinitions(templateId)) {
                if (!lateralJoinDefinition.getSqlExpression().equals(originalSqlExpression)) continue;
                item.setAlias(new LateralVariable(lateralJoinDefinition.getTable().getName(), lateralJoinDefinition.getLateralVariable()).alias());
                return;
            }
        }
        int abs = (hashValue = encodedVar.toString().hashCode()) != 0 ? Math.abs(hashValue) : 0;
        String tableAlias = "array_" + abs + "_" + LateralJoins.inc();
        String variableAlias = "var_" + abs + "_" + LateralJoins.inc();
        encodedVar.replaceLast(")", " AS " + variableAlias + ")");
        Table table = DSL.table((String)encodedVar.toString()).as(tableAlias);
        LateralJoinDefinition lateralJoinDefinition = new LateralJoinDefinition(originalSqlExpression, table, variableAlias, JoinType.JOIN, null, clause);
        LateralJoins.reuse(lateralJoinDefinition, templateId, item);
    }

    public static void create(String templateId, SelectQuery selectSelectStep, I_VariableDefinition item, IQueryImpl.Clause clause) {
        if (selectSelectStep == null) {
            return;
        }
        int hashValue = selectSelectStep.hashCode();
        int abs = hashValue != 0 ? Math.abs(hashValue) : 0;
        String tableAlias = "array_" + abs + "_" + LateralJoins.inc();
        String variableAlias = "var_" + abs + "_" + LateralJoins.inc();
        SelectSelectStep wrappedSelectSelectStep = DSL.select((SelectField)DSL.field((Select)selectSelectStep).as(variableAlias));
        Table table = DSL.table((Select)wrappedSelectSelectStep).as(tableAlias);
        item.setLateralJoinTable(templateId, new LateralJoinDefinition(selectSelectStep.getSQL(), table, variableAlias, JoinType.LEFT_OUTER_JOIN, DSL.condition((Boolean)true), clause));
        item.setSubstituteFieldVariable(variableAlias);
    }

    public static void reuse(LateralJoinDefinition lateralJoinDefinition, String templateId, I_VariableDefinition item) {
        item.setLateralJoinTable(templateId, lateralJoinDefinition);
        item.setAlias(new LateralVariable(lateralJoinDefinition.getTable().getName(), lateralJoinDefinition.getLateralVariable()).alias());
    }

    private static synchronized int inc() {
        return seed++;
    }
}

