/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.I_TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.WhereBinder;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMap;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.UnknownVariableException;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class WhereVariable {
    public static final String COMPOSITION = "COMPOSITION";
    public static final String CONTENT = "content";
    public static final String EHR = "EHR";
    private boolean isFollowedBySQLConditionalOperator = false;
    private WhereBinder.ExistsMode inExists;
    private String rightMostJsonbExpression = null;
    private final PathResolver pathResolver;

    public WhereVariable(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public TaggedStringBuilder encodeWhereVariable(WhereBinder.ExistsMode inExists, boolean isFollowedBySQLConditionalOperator, int whereCursor, MultiFieldsMap multiWhereFieldsMap, int selectCursor, MultiFieldsMap multiSelectFieldsMap, I_VariableDefinition variableDefinition, String compositionName) throws UnknownVariableException {
        TaggedStringBuilder variableSQL;
        this.inExists = inExists;
        this.isFollowedBySQLConditionalOperator = isFollowedBySQLConditionalOperator;
        try {
            variableSQL = this._encodeWhereVariable(whereCursor, multiWhereFieldsMap, selectCursor, multiSelectFieldsMap, variableDefinition, compositionName);
        }
        catch (UnknownVariableException e) {
            if (!inExists.equals((Object)WhereBinder.ExistsMode.UNSET)) {
                variableSQL = new TaggedStringBuilder(" " + DSL.val((Byte)null) + " ", I_TaggedStringBuilder.TagField.SQLQUERY);
                this.inExists = WhereBinder.ExistsMode.UNSET;
            }
            throw new UnknownVariableException(e.toString());
        }
        return variableSQL;
    }

    private TaggedStringBuilder _encodeWhereVariable(int whereCursor, MultiFieldsMap multiFieldsMap, int selectCursor, MultiFieldsMap multiSelectFieldsMap, I_VariableDefinition variableDefinition, String compositionName) throws UnknownVariableException {
        String identifier = variableDefinition.getIdentifier();
        String alreadyResolvedSQL = this.lookUpFromSelect(variableDefinition, selectCursor, multiSelectFieldsMap);
        if (alreadyResolvedSQL != null) {
            this.rightMostJsonbExpression = null;
            return new TaggedStringBuilder(alreadyResolvedSQL, I_TaggedStringBuilder.TagField.SQLQUERY);
        }
        String className = this.pathResolver.classNameOf(identifier);
        if (className == null) {
            throw new IllegalArgumentException("Could not bind identifier in WHERE clause:'" + identifier + "'");
        }
        MultiFields multiFields = multiFieldsMap.get(variableDefinition.getIdentifier(), variableDefinition.getPath());
        if (multiFields == null) {
            throw new UnknownVariableException(variableDefinition.toString());
        }
        QualifiedAqlField qualifiedAqlField = multiFields.getQualifiedFieldOrLast(whereCursor);
        Field<?> field = qualifiedAqlField.getSQLField();
        this.rightMostJsonbExpression = qualifiedAqlField.getRightMostJsonbExpression();
        if (field == null) {
            return null;
        }
        return new TaggedStringBuilder(field.toString(), I_TaggedStringBuilder.TagField.SQLQUERY);
    }

    private String lookUpFromSelect(I_VariableDefinition variableDefinition, int selectCursor, MultiFieldsMap multiSelectFieldsMap) throws UnknownVariableException {
        if (this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals(COMPOSITION) && variableDefinition.getPath().equals("uid/value")) {
            return null;
        }
        MultiFields multiFields = multiSelectFieldsMap.get(variableDefinition.getIdentifier(), variableDefinition.getPath());
        if (multiFields == null) {
            return null;
        }
        QualifiedAqlField aqlField = multiFields.getQualifiedFieldOrLast(selectCursor);
        if (aqlField.getItemType() != null && aqlField.getItemType().equals("DV_DURATION")) {
            return null;
        }
        return DSL.select(aqlField.getSQLField()).getSQL().replace("select ", "").replace("\"" + aqlField.getSQLField().getName() + "\"", "");
    }

    public boolean isFollowedBySQLConditionalOperator() {
        return this.isFollowedBySQLConditionalOperator;
    }

    public WhereBinder.ExistsMode inExists() {
        return this.inExists;
    }

    public String getRightMostJsonbExpression() {
        return this.rightMostJsonbExpression;
    }

    public boolean hasRightMostJsonbExpression() {
        return this.rightMostJsonbExpression != null;
    }
}

