/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.postprocessing;

import com.google.gson.JsonElement;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonException;
import org.ehrbase.aql.sql.postprocessing.IRawJsonTransform;
import org.ehrbase.serialisation.dbencoding.rawjson.LightRawJsonEncoder;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.Record;
import org.jooq.Result;

public class RawJsonTransform
implements IRawJsonTransform {
    public static final String TEMPLATE_ID = "_TEMPLATE_ID";
    public static final String ARRAY_MARKER = "$array$";

    private RawJsonTransform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toRawJson(Result<Record> result) {
        if (result.isEmpty()) {
            return;
        }
        for (Record record : result) {
            for (Field field : record.fields()) {
                if (!(record.getValue(field) instanceof String) && !(record.getValue(field) instanceof JSONB)) continue;
                String value = record.getValue(field).toString();
                Object jsonbOrigin = null;
                if (value.startsWith("[")) {
                    jsonReader = Json.createReader((Reader)new StringReader(value));
                    try {
                        jsonReader.readArray();
                        jsonbOrigin = "{\"$array$\":" + value + "}";
                    }
                    catch (JsonException jsonException) {
                    }
                    finally {
                        jsonReader.close();
                    }
                } else if (value.startsWith("{")) {
                    jsonReader = Json.createReader((Reader)new StringReader(value));
                    try {
                        jsonReader.readObject();
                        jsonbOrigin = value;
                    }
                    catch (JsonException jsonException) {
                    }
                    finally {
                        jsonReader.close();
                    }
                }
                if (jsonbOrigin == null) continue;
                JsonElement jsonElement = new LightRawJsonEncoder(jsonbOrigin).encodeContentAsJson(null);
                if (jsonElement.getAsJsonObject().has(ARRAY_MARKER)) {
                    jsonElement = jsonElement.getAsJsonObject().getAsJsonArray(ARRAY_MARKER);
                }
                record.setValue(field, (Object)jsonElement);
            }
        }
    }
}

