/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.sql.queryimpl.AqlDialects;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.JSONB;
import org.jooq.impl.DSL;

public class AqlRoutines
extends AqlDialects {
    private AqlRoutines() {
    }

    public static Field<JSONB> jsonArraySplitElements(Field<JSONB> jsonbVal) {
        return DSL.field((String)("ehr.xjsonb_array_elements(" + jsonbVal + ")")).cast(JSONB.class);
    }

    public static Field<JSONB> jsonArraySplitElements(Configuration configuration, Field<JSONB> jsonbVal) {
        AqlRoutines.isSupported(configuration);
        return DSL.field((String)("ehr.xjsonb_array_elements(" + jsonbVal + ")")).cast(JSONB.class);
    }

    public static Field<JSONB> jsonpathItem(Field<JSONB> jsonbVal, String[] elements) {
        return DSL.field((String)("jsonb_extract_path(" + jsonbVal + "," + String.join((CharSequence)",", elements) + ")")).cast(JSONB.class);
    }

    public static Field<JSONB> jsonpathItem(Configuration configuration, Field<JSONB> jsonbVal, String[] elements) {
        AqlRoutines.isSupported(configuration);
        return DSL.field((String)("jsonb_extract_path(" + jsonbVal + "," + String.join((CharSequence)",", elements) + ")")).cast(JSONB.class);
    }

    public static Field<JSONB> toJson(Configuration configuration, String expression) {
        AqlRoutines.isSupported(configuration);
        return DSL.field((String)("to_json(" + expression + ")")).cast(JSONB.class);
    }

    public static String jsonpathItemAsText(Field<JSONB> jsonbVal, String[] elements) {
        return "jsonb_extract_path_text(" + jsonbVal + "," + String.join((CharSequence)",", elements) + ")";
    }

    public static String jsonpathItemAsText(Configuration configuration, Field<JSONB> jsonbVal, String[] elements) {
        AqlRoutines.isSupported(configuration);
        return "jsonb_extract_path_text(" + jsonbVal + "," + String.join((CharSequence)",", elements) + ")";
    }

    public static String[] jsonpathParameters(String rawParameters) {
        String parametersFormatted = StringUtils.remove((String)StringUtils.remove((String)rawParameters, (String)"'{"), (String)"}'");
        return Arrays.stream(parametersFormatted.split(",")).map(s -> s.startsWith("'") ? s.replace("'", "") : s).map(s -> !s.equals("$AQL_NODE_NAME_PREDICATE$") ? "'" + s + "'" : s).collect(Collectors.toList()).toArray(new String[0]);
    }
}

