/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ehrbase.aql.definition.LateralJoinDefinition;
import org.ehrbase.aql.sql.queryimpl.MultiFields;

public class MultiFieldsMap {
    protected Map<String, MultiFields> multiFieldsListAsMap;

    public MultiFieldsMap(List<MultiFields> multiFieldsList) {
        this.multiFieldsListAsMap = this.toMap(multiFieldsList);
    }

    public MultiFieldsMap() {
    }

    private Map<String, MultiFields> toMap(List<MultiFields> multiFieldsList) {
        LinkedHashMap<String, MultiFields> multiMap = new LinkedHashMap<String, MultiFields>();
        for (MultiFields multiFields : multiFieldsList) {
            if (multiFields.isEmpty()) continue;
            multiMap.put(this.variableIdentifierPath(multiFields.getVariableDefinition().getIdentifier(), multiFields.getVariableDefinition().getPath()), multiFields);
        }
        return multiMap;
    }

    public MultiFields get(String identifierPath) {
        return this.multiFieldsListAsMap.get(identifierPath);
    }

    public MultiFields get(String variableIdentifier, String variablePath) {
        List result = this.multiFieldsListAsMap.values().stream().filter(v -> v.getVariableDefinition().getIdentifier().equals(variableIdentifier) && v.getVariableDefinition().getPath() != null && v.getVariableDefinition().getPath().equals(variablePath)).collect(Collectors.toList());
        if (result.isEmpty()) {
            return null;
        }
        return (MultiFields)result.get(0);
    }

    private String variableIdentifierPath(String variableIdentifier, String variablePath) {
        return variableIdentifier + "::" + variablePath;
    }

    public Iterator<MultiFields> multiFieldsIterator() {
        return this.multiFieldsListAsMap.values().iterator();
    }

    public int upperPathBoundary() {
        int upperbound = 0;
        for (MultiFields multiFields : this.multiFieldsListAsMap.values()) {
            if (multiFields.fieldsSize() <= upperbound) continue;
            upperbound = multiFields.fieldsSize();
        }
        return upperbound;
    }

    public Optional<LateralJoinDefinition> matchingLateralJoin(String templateId, String candidateLateralExpression) {
        return MultiFieldsMap.matchingLateralJoin(this.multiFieldsListAsMap.values(), templateId, candidateLateralExpression);
    }

    public static Optional<LateralJoinDefinition> matchingLateralJoin(Collection<MultiFields> multiFieldsCollection, String templateId, String candidateLateralExpression) {
        return multiFieldsCollection.stream().map(MultiFields::getVariableDefinition).map(vd -> vd.getLastLateralJoin(templateId)).filter(Objects::nonNull).filter(lj -> lj.getSqlExpression().equals(candidateLateralExpression)).findFirst();
    }
}

