/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.tables.AdminDeleteCompositionHistory;
import org.ehrbase.jooq.pg.tables.AdminDeleteFolderHistory;
import org.ehrbase.jooq.pg.tables.AdminDeleteFolderObjRefHistory;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.TableLike;

public class AdminApiUtils {
    DSLContext ctx;

    public AdminApiUtils(DSLContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    private void internalDeleteComposition(UUID id) {
        Routines.adminDeleteEventContextForCompo((Configuration)this.ctx.configuration(), (UUID)id);
        Result delCompo = Routines.adminDeleteComposition((Configuration)this.ctx.configuration(), (UUID)id);
        delCompo.forEach(del -> {
            this.deleteAudit(del.getAudit(), "Composition", false);
            if (del.getAttestation() != null) {
                Result delAttest = Routines.adminDeleteAttestation((Configuration)this.ctx.configuration(), (UUID)del.getAttestation());
                delAttest.forEach(attest -> this.deleteAudit(attest.getAudit(), "Attestation", false));
            }
            this.deleteContribution(del.getContribution(), null, false);
        });
    }

    public void deleteComposition(UUID id) {
        this.internalDeleteComposition(id);
        int res = this.ctx.selectQuery((TableLike)new AdminDeleteCompositionHistory().call(id)).execute();
        if (res != 1) {
            throw new InternalServerException("Admin deletion of Composition auxiliary objects failed!");
        }
    }

    public void deleteAudit(UUID id, String context, Boolean resultCanBeEmpty) {
        Result delAudit = Routines.adminDeleteAudit((Configuration)this.ctx.configuration(), (UUID)id);
        if (resultCanBeEmpty.equals(false) && delAudit.size() != 1) {
            throw new InternalServerException("Admin deletion of " + context + " Audit failed!");
        }
    }

    public void deleteContribution(UUID id, UUID audit, Boolean resultCanBeEmpty) {
        Result rec = Routines.adminDeleteContribution((Configuration)this.ctx.configuration(), (UUID)id);
        if (rec.isNotEmpty()) {
            rec.forEach(del -> this.deleteAudit(del.getAudit(), "Contribution", resultCanBeEmpty));
        } else if (audit != null) {
            this.deleteAudit(audit, "Contribution", resultCanBeEmpty);
        }
    }

    public void deleteFolder(UUID id, Boolean deleteContributions) {
        Result records = Routines.adminDeleteFolder((Configuration)this.ctx.configuration(), (UUID)id);
        HashSet<UUID> folders = new HashSet<UUID>();
        HashSet contribs = new HashSet();
        HashSet audits = new HashSet();
        folders.add(id);
        records.forEach(rec -> {
            folders.add(rec.getChild());
            contribs.add(rec.getContribution());
            audits.add(rec.getAudit());
        });
        folders.forEach(folder -> this.ctx.selectQuery((TableLike)new AdminDeleteFolderHistory().call(folder)).execute());
        contribs.forEach(contrib -> this.ctx.selectQuery((TableLike)new AdminDeleteFolderObjRefHistory().call(contrib)).execute());
        if (deleteContributions.equals(true)) {
            contribs.forEach(contrib -> this.deleteContribution((UUID)contrib, null, false));
        }
        audits.forEach(audit -> this.deleteAudit((UUID)audit, "Folder", false));
    }
}

