/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.encapsulated.DvMultimedia;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_AttestationAccess;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.tables.Attestation;
import org.ehrbase.jooq.pg.tables.records.AttestationRecord;
import org.ehrbase.jooq.pg.tables.records.AuditDetailsRecord;
import org.jooq.Result;
import org.jooq.Table;

public class AttestationAccess
extends DataAccess
implements I_AttestationAccess {
    private AttestationRecord attestationRecord;
    private I_AuditDetailsAccess auditDetailsAccess;

    public AttestationAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public I_AttestationAccess retrieveInstance(UUID attestationId) {
        try {
            this.attestationRecord = (AttestationRecord)this.getDataAccess().getContext().fetchOne((Table)Attestation.ATTESTATION, Attestation.ATTESTATION.ID.eq((Object)attestationId));
        }
        catch (Exception e) {
            throw new InternalServerException("fetching attestation failed", (Throwable)e);
        }
        this.auditDetailsAccess = new AuditDetailsAccess(this.getDataAccess(), this.attestationRecord.getNamespace());
        try {
            this.auditDetailsAccess.setRecord((AuditDetailsRecord)this.getDataAccess().getContext().fetchOne((Table)org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS, org.ehrbase.jooq.pg.tables.AuditDetails.AUDIT_DETAILS.ID.eq((Object)this.getAuditId())));
        }
        catch (Exception e) {
            throw new InternalServerException("fetching audit_details failed", (Throwable)e);
        }
        return null;
    }

    public static List<UUID> retrieveListOfAttestationsByRef(I_DomainAccess dataAccess, UUID attestationRef) {
        Result result = dataAccess.getContext().fetch((Table)Attestation.ATTESTATION, Attestation.ATTESTATION.REFERENCE.eq((Object)attestationRef));
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (AttestationRecord rec : result) {
            list.add(rec.getId());
        }
        return list;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        return null;
    }

    @Override
    public UUID commit() {
        return null;
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return null;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return null;
    }

    @Override
    public Boolean update() {
        return null;
    }

    @Override
    public Boolean update(Boolean force) {
        return null;
    }

    @Override
    public Integer delete() {
        return null;
    }

    private UUID getAuditId() {
        return this.attestationRecord.getHasAudit();
    }

    @Override
    public com.nedap.archie.rm.generic.Attestation getAsAttestation() {
        AuditDetails audit = this.auditDetailsAccess.getAsAuditDetails();
        String systemId = audit.getSystemId();
        PartyProxy committer = audit.getCommitter();
        DvDateTime time = audit.getTimeCommitted();
        DvCodedText changeType = audit.getChangeType();
        DvText description = audit.getDescription();
        DvMultimedia attestedView = null;
        String proof = this.attestationRecord.getProof();
        List items = null;
        DvText reason = new DvText(this.attestationRecord.getReason());
        boolean isPending = this.attestationRecord.getIsPending();
        return new com.nedap.archie.rm.generic.Attestation(systemId, committer, time, changeType, description, attestedView, proof, items, reason, isPending);
    }
}

