/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_CompoXrefAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoXRefAccess
extends DataAccess
implements I_CompoXrefAccess {
    static Logger log = LoggerFactory.getLogger(CompoXRefAccess.class);

    public CompoXRefAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public Map<UUID, Timestamp> getLinkList(UUID masterUid) {
        return this.getContext().select((SelectField)Tables.COMPO_XREF.CHILD_UUID, (SelectField)Tables.COMPO_XREF.SYS_TRANSACTION).from((TableLike)Tables.COMPO_XREF).where(Tables.COMPO_XREF.MASTER_UUID.eq((Object)masterUid)).fetch().intoMap((Field)Tables.COMPO_XREF.CHILD_UUID, (Field)Tables.COMPO_XREF.SYS_TRANSACTION);
    }

    @Override
    public UUID getLastLink(UUID masterUid) {
        return (UUID)this.getContext().select((SelectField)Tables.COMPO_XREF.CHILD_UUID).from((TableLike)Tables.COMPO_XREF).where(Tables.COMPO_XREF.MASTER_UUID.eq((Object)masterUid)).orderBy((OrderField)Tables.COMPO_XREF.SYS_TRANSACTION.desc()).fetchOne((Field)Tables.COMPO_XREF.CHILD_UUID);
    }

    @Override
    public int setLink(UUID masterUid, UUID childUid) {
        Timestamp timestamp = TransactionTime.millis();
        return this.getContext().insertInto((Table)Tables.COMPO_XREF).columns((Field)Tables.COMPO_XREF.MASTER_UUID, (Field)Tables.COMPO_XREF.CHILD_UUID, (Field)Tables.COMPO_XREF.SYS_TRANSACTION).values((Object)masterUid, (Object)childUid, (Object)timestamp).execute();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

