/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.generic.AuditDetails;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.AdminApiUtils;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.enums.ContributionState;
import org.ehrbase.jooq.pg.tables.AdminDeleteStatusHistory;
import org.ehrbase.jooq.pg.tables.records.ContributionRecord;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.util.UuidGenerator;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContributionAccess
extends DataAccess
implements I_ContributionAccess {
    Logger log = LoggerFactory.getLogger(ContributionAccess.class);
    private ContributionRecord contributionRecord;
    private I_AuditDetailsAccess auditDetails;

    public ContributionAccess(DSLContext context, I_KnowledgeCache knowledgeManager, IntrospectService introspectCache, ServerConfig serverConfig, UUID ehrId, String tenantIdentifier) {
        super(context, knowledgeManager, introspectCache, serverConfig);
        this.contributionRecord = (ContributionRecord)context.newRecord((Table)Tables.CONTRIBUTION);
        this.contributionRecord.setEhrId(ehrId);
        this.contributionRecord.setNamespace(tenantIdentifier);
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess(), tenantIdentifier);
    }

    public ContributionAccess(I_DomainAccess domainAccess, UUID ehrId, String tenantIdentifier) {
        this(domainAccess.getContext(), domainAccess.getKnowledgeManager(), domainAccess.getIntrospectService(), domainAccess.getServerConfig(), ehrId, tenantIdentifier);
    }

    private ContributionAccess(I_DomainAccess domainAccess, ContributionRecord record, I_AuditDetailsAccess audit) {
        super(domainAccess);
        this.contributionRecord = record;
        this.auditDetails = audit;
    }

    public static I_ContributionAccess retrieveInstance(I_DomainAccess domainAccess, UUID contributionId) {
        try {
            return Optional.ofNullable((ContributionRecord)domainAccess.getContext().fetchOne((Table)Tables.CONTRIBUTION, Tables.CONTRIBUTION.ID.eq((Object)contributionId))).map(rec -> new ContributionAccess(domainAccess, (ContributionRecord)rec, new AuditDetailsAccess(domainAccess.getDataAccess(), rec.getNamespace()).retrieveInstance(domainAccess.getDataAccess(), rec.getHasAudit()))).orElse(null);
        }
        catch (Exception e) {
            throw new InternalServerException("fetching contribution failed", (Throwable)e);
        }
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        UUID auditId = this.auditDetails.commit();
        this.contributionRecord.setHasAudit(auditId);
        if (this.contributionRecord.getState() == ContributionState.incomplete) {
            this.log.warn("Contribution state has not been set");
        }
        this.contributionRecord.setEhrId(this.getEhrId());
        if (this.contributionRecord.insert() == 0) {
            throw new InternalServerException("Couldn't store contribution");
        }
        return this.contributionRecord.getId();
    }

    @Override
    public UUID commit() {
        return this.commit(TransactionTime.millis());
    }

    @Override
    public UUID commit(Timestamp transactionTime, ContributionDataType contributionType, ContributionDef.ContributionState state) {
        if (transactionTime == null) {
            transactionTime = TransactionTime.millis();
        }
        this.setContributionDataType(Objects.requireNonNullElse(contributionType, ContributionDataType.other));
        this.setState(Objects.requireNonNullElse(state, ContributionDef.ContributionState.COMPLETE));
        return this.commit(transactionTime);
    }

    @Override
    public UUID commit(Timestamp transactionTime, UUID committerId, UUID systemId, ContributionDataType contributionType, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess(), this.contributionRecord.getNamespace());
        if (transactionTime == null) {
            transactionTime = TransactionTime.millis();
        }
        this.setContributionDataType(Objects.requireNonNullElse(contributionType, ContributionDataType.other));
        this.setState(Objects.requireNonNullElse(state, ContributionDef.ContributionState.COMPLETE));
        if (committerId == null) {
            throw new InternalServerException("Missing mandatory committer ID");
        }
        this.auditDetails.setCommitter(committerId);
        if (systemId == null) {
            throw new InternalServerException("Missing mandatory system ID");
        }
        this.auditDetails.setSystemId(systemId);
        if (contributionChangeType != null) {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType.name()));
        } else {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        }
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
        return this.commit(transactionTime);
    }

    @Override
    public Boolean update(Timestamp transactionTime, UUID committerId, UUID systemId, String contributionType, String contributionState, String contributionChangeType, String description) {
        ContributionDataType type = null;
        ContributionDef.ContributionState state = null;
        I_ConceptAccess.ContributionChangeType changeType = null;
        if (contributionType == null) {
            type = ContributionDataType.valueOf((String)contributionType);
        }
        if (contributionState != null) {
            state = ContributionDef.ContributionState.valueOf(contributionState);
        }
        if (contributionChangeType != null) {
            changeType = I_ConceptAccess.ContributionChangeType.valueOf(contributionChangeType);
        }
        return this.update(transactionTime, committerId, systemId, type, state, changeType, description);
    }

    @Override
    public Boolean update(Timestamp transactionTime, UUID committerId, UUID systemId, ContributionDataType contributionType, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        if (contributionType != null) {
            this.setContributionDataType(contributionType);
        }
        if (state != null) {
            this.setState(state);
        }
        this.auditDetails = I_AuditDetailsAccess.getInstance(this.getDataAccess(), this.contributionRecord.getNamespace());
        if (committerId != null) {
            this.auditDetails.setCommitter(committerId);
        }
        if (systemId != null) {
            this.auditDetails.setSystemId(systemId);
        }
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
        if (contributionChangeType != null) {
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, contributionChangeType));
        }
        return this.update(transactionTime);
    }

    @Override
    public UUID commitWithSignature(String signature) {
        this.contributionRecord.setSignature(signature);
        this.contributionRecord.setState(ContributionState.valueOf((String)"complete"));
        this.contributionRecord.store();
        return this.contributionRecord.getId();
    }

    @Override
    public UUID updateWithSignature(String signature) {
        this.contributionRecord.setSignature(signature);
        this.contributionRecord.setState(ContributionState.valueOf((String)"complete"));
        this.contributionRecord.update();
        return this.contributionRecord.getId();
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean updated = false;
        if (force || this.contributionRecord.changed()) {
            if (!this.contributionRecord.changed()) {
                this.contributionRecord.changed(true);
            }
            this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.MODIFICATION));
            if (this.auditDetails.update(transactionTime, force).equals(Boolean.FALSE)) {
                throw new InternalServerException("Couldn't update auditDetails");
            }
            this.contributionRecord.setHasAudit(this.auditDetails.getId());
            this.contributionRecord.setId(UuidGenerator.randomUUID());
            updated = this.contributionRecord.insert() == 1;
        }
        return updated;
    }

    @Override
    public Boolean update() {
        return this.update(TransactionTime.millis());
    }

    @Override
    public Boolean update(Boolean force) {
        return this.update(TransactionTime.millis());
    }

    @Override
    public Integer delete() {
        int count = 0;
        return count += this.contributionRecord.delete();
    }

    public I_ContributionAccess retrieve(UUID id) {
        return ContributionAccess.retrieveInstance(this, id);
    }

    @Override
    public UUID getContributionId() {
        return this.contributionRecord.getId();
    }

    @Override
    public void setAuditDetailsChangeType(UUID changeType) {
        this.auditDetails.setChangeType(changeType);
    }

    @Override
    public ContributionDataType getContributionDataType() {
        return this.contributionRecord.getContributionType();
    }

    @Override
    public void setContributionDataType(ContributionDataType contributionDataType) {
        this.contributionRecord.setContributionType(contributionDataType);
    }

    @Override
    public void setState(ContributionDef.ContributionState state) {
        if (state != null) {
            this.contributionRecord.setState(ContributionState.valueOf((String)state.getLiteral()));
        }
    }

    @Override
    public void setComplete() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.complete.getLiteral()));
    }

    @Override
    public void setIncomplete() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.incomplete.getLiteral()));
    }

    @Override
    public void setDeleted() {
        this.contributionRecord.setState(ContributionState.valueOf((String)ContributionState.deleted.getLiteral()));
    }

    @Override
    public void setAuditDetailsValues(UUID committer, UUID system, String description, I_ConceptAccess.ContributionChangeType changeType) {
        if (committer == null || system == null || changeType == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetails.setCommitter(committer);
        this.auditDetails.setSystemId(system);
        this.auditDetails.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, changeType));
        if (description != null) {
            this.auditDetails.setDescription(description);
        }
    }

    @Override
    public void setAuditDetailsValues(AuditDetails auditObject) {
        UUID committer = new PersistedPartyProxy(this).getOrCreate(auditObject.getCommitter(), this.auditDetails.getNamespace());
        UUID system = I_SystemAccess.createOrRetrieveInstanceId(this, null, auditObject.getSystemId());
        UUID changeType = I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, auditObject.getChangeType().getValue());
        if (committer == null || system == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetails.setCommitter(committer);
        this.auditDetails.setSystemId(system);
        this.auditDetails.setChangeType(changeType);
        if (auditObject.getDescription() != null) {
            this.auditDetails.setDescription(auditObject.getDescription().getValue());
        }
    }

    @Override
    public void setAuditDetailsCommitter(UUID committer) {
        this.auditDetails.setCommitter(committer);
    }

    @Override
    public void setAuditDetailsSystemId(UUID system) {
        this.auditDetails.setSystemId(system);
    }

    @Override
    public void setAuditDetailsDescription(String description) {
        this.auditDetails.setDescription(description);
    }

    @Override
    public UUID getAuditsCommitter() {
        return this.auditDetails.getCommitter();
    }

    @Override
    public UUID getAuditsSystemId() {
        return this.auditDetails.getSystemId();
    }

    @Override
    public String getAuditsDescription() {
        return this.auditDetails.getDescription();
    }

    @Override
    public I_ConceptAccess.ContributionChangeType getAuditsChangeType() {
        return I_ConceptAccess.ContributionChangeType.valueOf(this.auditDetails.getChangeType().getLiteral().toUpperCase());
    }

    @Override
    public ContributionDef.ContributionType getContributionType() {
        return ContributionDef.ContributionType.valueOf(this.contributionRecord.getContributionType().getLiteral());
    }

    @Override
    public ContributionDef.ContributionState getContributionState() {
        return ContributionDef.ContributionState.valueOf(this.contributionRecord.getState().getLiteral());
    }

    @Override
    public UUID getEhrId() {
        return this.contributionRecord.getEhrId();
    }

    @Override
    public String getDataType() {
        return this.contributionRecord.getContributionType().getLiteral();
    }

    @Override
    public void setDataType(ContributionDataType contributionDataType) {
        this.contributionRecord.setContributionType(contributionDataType);
    }

    @Override
    public UUID getId() {
        return this.contributionRecord.getId();
    }

    @Override
    public void setEhrId(UUID ehrId) {
        this.contributionRecord.setEhrId(ehrId);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public void setHasAuditDetails(UUID auditId) {
        this.contributionRecord.setHasAudit(auditId);
    }

    @Override
    public UUID getHasAuditDetails() {
        return this.contributionRecord.getHasAudit();
    }

    @Override
    public void adminDelete() {
        AdminApiUtils adminApi = new AdminApiUtils(this.getContext());
        Result linkedCompositions = Routines.adminGetLinkedCompositionsForContrib((Configuration)this.getContext().configuration(), (UUID)this.getId());
        Result linkedStatus = Routines.adminGetLinkedStatusForContrib((Configuration)this.getContext().configuration(), (UUID)this.getId());
        linkedCompositions.forEach(compo -> adminApi.deleteComposition(compo.getComposition()));
        linkedStatus.forEach(status -> {
            Result delStatus = Routines.adminDeleteStatus((Configuration)this.getContext().configuration(), (UUID)status.getStatus());
            if (delStatus.isEmpty()) {
                throw new InternalServerException("Admin deletion of Status failed! Unexpected result.");
            }
            delStatus.forEach(id -> {
                adminApi.deleteAudit(id.getStatusAudit(), "Status", false);
                int res = this.getContext().selectQuery((TableLike)new AdminDeleteStatusHistory().call(status.getStatus())).execute();
                if (res != 1) {
                    throw new InternalServerException("Admin deletion of Status failed!");
                }
            });
        });
        adminApi.deleteContribution(this.getId(), null, false);
    }

    @Override
    public String getNamespace() {
        return this.contributionRecord.getNamespace();
    }
}

