/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_StatusHistoryAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StatusHistoryRecord;
import org.jooq.Condition;
import org.jooq.OrderField;
import org.jooq.Result;
import org.jooq.Table;

public class StatusHistoryAccess
extends DataAccess
implements I_StatusHistoryAccess {
    private StatusHistoryRecord statusHistoryRecord;

    private StatusHistoryAccess(I_DomainAccess domainAccess, StatusHistoryRecord statusHistoryRecord) {
        super(domainAccess);
        this.statusHistoryRecord = statusHistoryRecord;
    }

    public static StatusHistoryAccess retrieveByVersion(I_DomainAccess domainAccess, UUID statusId, int version) {
        Result historyRec = domainAccess.getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.ID.eq((Object)statusId)).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
        if (historyRec.isEmpty()) {
            return null;
        }
        StatusHistoryRecord rec = (StatusHistoryRecord)historyRec.get(version - 1);
        return new StatusHistoryAccess(domainAccess, rec);
    }

    @Override
    public UUID getId() {
        return this.statusHistoryRecord.getId();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public UUID getContributionId() {
        return this.statusHistoryRecord.getInContribution();
    }

    @Override
    public Timestamp getSysTransaction() {
        return this.statusHistoryRecord.getSysTransaction();
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID commit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean update() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean update(Boolean force) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer delete() {
        Condition condition = Tables.STATUS_HISTORY.ID.eq((Object)this.statusHistoryRecord.getId()).and(Tables.STATUS_HISTORY.SYS_TRANSACTION.eq((Object)this.statusHistoryRecord.getSysTransaction()));
        return this.getContext().delete((Table)Tables.STATUS_HISTORY).where(condition).execute();
    }
}

