/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.dao.access.interfaces.I_TenantAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.TenantRecord;
import org.jooq.DSLContext;
import org.jooq.Result;
import org.jooq.Table;

public class TenantAccess
implements I_TenantAccess {
    private final TenantRecord record;
    private static final String ERR_TENANT_ID = "Updateing tenant id[%s] is not allowed";

    public TenantAccess(DSLContext ctx, Tenant tenant) {
        this(ctx, TenantAccess.initTenantRec(ctx, tenant));
    }

    private TenantAccess(DSLContext ctx, TenantRecord rec) {
        this.record = rec;
    }

    private static TenantRecord initTenantRec(DSLContext ctx, Tenant tenant) {
        TenantRecord rec = (TenantRecord)ctx.newRecord((Table)Tables.TENANT);
        rec.setTenantId(tenant.getTenantId());
        rec.setTenantName(tenant.getTenantName());
        return rec;
    }

    @Override
    public UUID commit() {
        this.record.store();
        return this.record.getId();
    }

    public static List<I_TenantAccess> getAll(DSLContext ctx) {
        Result allRecs = ctx.fetch((Table)Tables.TENANT);
        return StreamSupport.stream(allRecs.spliterator(), false).map(rec -> new TenantAccess(ctx, (TenantRecord)rec)).collect(Collectors.toList());
    }

    public static I_TenantAccess retrieveInstanceBy(DSLContext ctx, String tenantId) {
        return Optional.ofNullable((TenantRecord)ctx.fetchOne((Table)Tables.TENANT, Tables.TENANT.TENANT_ID.eq((Object)tenantId))).map(rec -> new TenantAccess(ctx, (TenantRecord)rec)).orElse(null);
    }

    @Override
    public Tenant convert() {
        return new Tenant(){

            public String getTenantId() {
                return TenantAccess.this.record.getTenantId();
            }

            public String getTenantName() {
                return TenantAccess.this.record.getTenantName();
            }
        };
    }

    @Override
    public Tenant update(Tenant tenant) {
        if (!this.record.getTenantId().equals(tenant.getTenantId())) {
            new InternalServerException(String.format(ERR_TENANT_ID, tenant.getTenantId()));
        }
        this.record.setTenantName(tenant.getTenantName());
        this.record.update();
        return this.convert();
    }
}

