/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Record;
import org.jooq.Table;

public class PersistedPartyRef {
    I_DomainAccess domainAccess;

    public PersistedPartyRef(I_DomainAccess domainAccess) {
        this.domainAccess = domainAccess;
    }

    public UUID findInDB(PartyRef partyRef) {
        Record record;
        if (partyRef == null) {
            return null;
        }
        ObjectId ref = partyRef.getId();
        if (ref instanceof ObjectVersionId || ref instanceof HierObjectId) {
            ObjectId objectId = ref;
            record = this.domainAccess.getContext().fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)objectId.getValue())));
        } else if (ref instanceof GenericId) {
            GenericId genericId = (GenericId)ref;
            record = this.domainAccess.getContext().fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)partyRef.getNamespace()).and(Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME.eq((Object)genericId.getScheme())).and(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)genericId.getValue())));
        } else {
            throw new IllegalStateException("Unsupported PartyRef identification:" + ref.getClass().getSimpleName());
        }
        if (record != null) {
            return (UUID)record.get("id");
        }
        return null;
    }

    public UUID findInDB(String value, String scheme, String namespace, String type) {
        PartyRef partyRef = new PartyRef((ObjectId)new GenericId(value, scheme), namespace, type);
        return this.findInDB(partyRef);
    }

    public UUID findInDB(String id, String namespace) {
        PartyRef partyRef = new PartyRef((ObjectId)new HierObjectId(id), namespace, "PERSON");
        return this.findInDB(partyRef);
    }
}

