/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.support;

import java.sql.Connection;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.service.IntrospectService;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;

public abstract class DataAccess
implements I_DomainAccess {
    private final DSLContext context;
    private final I_KnowledgeCache knowledgeManager;
    private final IntrospectService introspectService;
    private final ServerConfig serverConfig;

    public DataAccess(DSLContext context, I_KnowledgeCache knowledgeManager, IntrospectService introspectService, ServerConfig serverConfig) {
        this.context = context;
        this.knowledgeManager = knowledgeManager;
        this.introspectService = introspectService;
        this.serverConfig = serverConfig;
    }

    public DataAccess(I_DomainAccess domainAccess) {
        this.context = domainAccess.getContext();
        this.knowledgeManager = domainAccess.getKnowledgeManager();
        this.introspectService = domainAccess.getIntrospectService();
        this.serverConfig = domainAccess.getServerConfig();
    }

    @Override
    public SQLDialect getDialect() {
        return this.context.dialect();
    }

    @Override
    public Connection getConnection() {
        return this.context.configuration().connectionProvider().acquire();
    }

    @Override
    public void releaseConnection(Connection connection) {
        this.context.configuration().connectionProvider().release(connection);
    }

    @Override
    public DSLContext getContext() {
        return this.context;
    }

    @Override
    public I_KnowledgeCache getKnowledgeManager() {
        return this.knowledgeManager;
    }

    @Override
    public IntrospectService getIntrospectService() {
        return this.introspectService;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

