/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.support;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.tenant.TenantAuthentication;
import org.ehrbase.functional.Try;
import org.ehrbase.tenant.DefaultTenantAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class TenantSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantSupport.class);
    private static final String WARN_NOT_TENEANT_IDENT = "No tenent identifier provided, falling back to default tenant identifier {}";
    private static final String ERR_TENANT_ID_MISSMATCH = "Provided tenant id[%s] does not match session tenant id[%s]";

    private TenantSupport() {
    }

    public static String currentTenantIdentifier() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(Objects::nonNull).filter(DefaultTenantAuthentication.class::isInstance).map(DefaultTenantAuthentication.class::cast).map(DefaultTenantAuthentication::getTenantId).filter(StringUtils::isNotEmpty).orElseGet(() -> {
            LOGGER.warn(WARN_NOT_TENEANT_IDENT, (Object)TenantAuthentication.getDefaultTenantId());
            return TenantAuthentication.getDefaultTenantId();
        });
    }

    public static Try<String, InternalServerException> isValidTenantId(String tenantId, Supplier<String> currentTenant) {
        String currentTenantIdentifier = currentTenant.get();
        return currentTenantIdentifier.equals(tenantId) ? Try.success((Object)tenantId) : Try.failure((Exception)new InternalServerException(String.format(ERR_TENANT_ID_MISSMATCH, tenantId, currentTenantIdentifier)));
    }
}

