/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.aql.containment.JsonPathQueryResult;
import org.ehrbase.aql.sql.queryimpl.ItemInfo;
import org.ehrbase.cache.CacheOptions;
import org.ehrbase.dao.access.support.TenantSupport;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.TemplateStorage;
import org.ehrbase.tenant.DefaultTenantAuthentication;
import org.ehrbase.util.TemplateUtils;
import org.ehrbase.util.WebTemplateNodeQuery;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.NodeId;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KnowledgeCacheService
implements I_KnowledgeCache,
IntrospectService {
    public static final String ELEMENT = "ELEMENT";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private final CacheOptions cacheOptions;
    private final Cache jsonPathQueryResultCache;
    private final Cache webTemplateCache;
    private final Cache fieldCache;
    private final Cache multivaluedCache;
    private final TenantService tenantService;
    private final Map<CacheKey<UUID>, String> idxCacheUuidToTemplateId = new ConcurrentHashMap<CacheKey<UUID>, String>();
    private final Map<String, CacheKey<UUID>> idxCacheTemplateIdToUuid = new ConcurrentHashMap<String, CacheKey<UUID>>();
    @Value(value="${system.allow-template-overwrite:false}")
    private boolean allowTemplateOverwrite;
    private static final int NUM_OF_PROC = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService execService = Executors.newFixedThreadPool(NUM_OF_PROC);
    private static final String ERR_CACHE_ERROR = "An error occurred while caching template: {}";
    private static final String ERR_GEN_ERROR = "An error occurred while calculating queries for template: {}";

    public KnowledgeCacheService(TemplateStorage templateStorage, CacheManager cacheManager, CacheOptions cacheOptions, TenantService tenantService) throws InterruptedException {
        this.templateStorage = templateStorage;
        this.cacheOptions = cacheOptions;
        this.tenantService = tenantService;
        this.webTemplateCache = cacheManager.getCache("introspectCache");
        this.jsonPathQueryResultCache = cacheManager.getCache("queryCache");
        this.fieldCache = cacheManager.getCache("fieldsCache");
        this.multivaluedCache = cacheManager.getCache("multivaluedCache");
        this.initializeCaches(cacheOptions.isPreInitialize());
    }

    private Future<?> initCachePerTenant(String tenantId) {
        SecCtxAwareRunnable runMe = new SecCtxAwareRunnable((Authentication)DefaultTenantAuthentication.of(tenantId)){

            @Override
            void doRun() {
                HashSet templateIds = new HashSet();
                KnowledgeCacheService.this.listAllOperationalTemplates().forEach(metadata -> {
                    OPERATIONALTEMPLATE template = metadata.getOperationaltemplate();
                    String templateId = TemplateUtils.getTemplateId(template);
                    templateIds.add(templateId);
                    try {
                        KnowledgeCacheService.this.putIntoCache(template, KnowledgeCacheService.this.tenantService.getCurrentTenantIdentifier());
                    }
                    catch (RuntimeException e) {
                        KnowledgeCacheService.this.log.error(KnowledgeCacheService.ERR_CACHE_ERROR, (Object)templateId, (Object)e);
                    }
                });
                templateIds.forEach(templateId -> {
                    try {
                        KnowledgeCacheService.this.preBuildQueries((String)templateId, KnowledgeCacheService.this.cacheOptions.isPreBuildQueries());
                    }
                    catch (RuntimeException e) {
                        KnowledgeCacheService.this.log.error(KnowledgeCacheService.ERR_GEN_ERROR, templateId, (Object)e);
                    }
                });
            }
        };
        return execService.submit(runMe);
    }

    private void initializeCaches(boolean init) throws InterruptedException {
        if (!init) {
            return;
        }
        List<Future> collect = this.tenantService.getAll().stream().map(Tenant::getTenantId).map(this::initCachePerTenant).collect(Collectors.toList());
        int i = 0;
        while (i < 16) {
            boolean res = collect.stream().map(Future::isDone).reduce(true, (a, b) -> a != false && b != false);
            if (res) {
                return;
            }
            i = Math.max(1, 2 * i);
            Thread.sleep((long)i * 1000L);
        }
        collect.forEach(f -> {
            if (!f.isDone()) {
                f.cancel(false);
            }
        });
    }

    @Override
    public Set<String> getAllTemplateIds() {
        return this.templateStorage.findAllTemplateIds();
    }

    @Override
    public String addOperationalTemplate(InputStream inputStream, String tenantIdentifier) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(inputStream);
        return this.addOperationalTemplateIntern(template, false, tenantIdentifier);
    }

    private OPERATIONALTEMPLATE buildOperationalTemplate(InputStream content) {
        try {
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)content);
            return document.getTemplate();
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
    }

    @Override
    public String addOperationalTemplate(OPERATIONALTEMPLATE template, String tenantIdentifier) {
        return this.addOperationalTemplateIntern(template, false, tenantIdentifier);
    }

    public String addOperationalTemplateIntern(OPERATIONALTEMPLATE template, boolean overwrite, String tenantIdentifier) {
        String templateId;
        TenantSupport.isValidTenantId(tenantIdentifier, () -> this.tenantService.getCurrentTenantIdentifier()).getOrThrow();
        this.validateTemplate(template);
        try {
            templateId = TemplateUtils.getTemplateId(template);
        }
        catch (IllegalArgumentException a) {
            throw new InvalidApiParameterException("Invalid template input content");
        }
        if (!this.allowTemplateOverwrite && !overwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists: " + templateId);
        }
        this.invalidateCache(template);
        this.templateStorage.storeTemplate(template, tenantIdentifier);
        this.putIntoCache(template, tenantIdentifier);
        this.preBuildQueries(templateId, this.cacheOptions.isPreBuildQueries());
        return templateId;
    }

    private void preBuildQueries(final String templateId, boolean preBuild) {
        if (!preBuild) {
            return;
        }
        this.getQueryOptMetaData(templateId).findAllContainmentCombinations().stream().filter(nodeIds -> !nodeIds.isEmpty() && nodeIds.size() <= this.cacheOptions.getPreBuildQueriesDepth()).forEach(nodeIds -> execService.submit(new SecCtxAwareRunnable(SecurityContextHolder.getContext().getAuthentication(), (Set)nodeIds){
            final /* synthetic */ Set val$nodeIds;
            {
                this.val$nodeIds = set;
                super(auth);
            }

            @Override
            void doRun() {
                KnowledgeCacheService.this.resolveForTemplate(templateId, this.val$nodeIds);
            }
        }));
    }

    private void putIntoCache(OPERATIONALTEMPLATE template, String tenantIdentifier) {
        String templateId = TemplateUtils.getTemplateId(template);
        UUID uid = TemplateUtils.getUid(template);
        try {
            this.idxCacheUuidToTemplateId.put(CacheKey.of(uid, tenantIdentifier), templateId);
            this.idxCacheTemplateIdToUuid.put(templateId, CacheKey.of(uid, tenantIdentifier));
            this.getQueryOptMetaData(templateId);
        }
        catch (RuntimeException e) {
            this.log.error("Invalid template {}", (Object)templateId);
            this.invalidateCache(template);
            throw e;
        }
    }

    public String adminUpdateOperationalTemplate(InputStream content) {
        OPERATIONALTEMPLATE template = this.buildOperationalTemplate(content);
        return this.addOperationalTemplateIntern(template, true, this.tenantService.getCurrentTenantIdentifier());
    }

    private void invalidateCache(OPERATIONALTEMPLATE template) {
        this.webTemplateCache.evict(CacheKey.of(TemplateUtils.getUid(template), this.tenantService.getCurrentTenantIdentifier()));
        this.jsonPathQueryResultCache.invalidate();
        this.fieldCache.invalidate();
        this.multivaluedCache.invalidate();
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStorage.listAllOperationalTemplates();
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        return Optional.ofNullable(this.getOperationaltemplateFromFileStorage(key));
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID uuid) {
        return Optional.ofNullable(this.findTemplateIdByUuid(uuid)).flatMap(key -> this.retrieveOperationalTemplate((String)key));
    }

    @Override
    public boolean deleteOperationalTemplate(OPERATIONALTEMPLATE template) {
        boolean deleted = this.templateStorage.deleteTemplate(template.getTemplateId().getValue());
        if (deleted) {
            this.invalidateCache(template);
        }
        return deleted;
    }

    private String findTemplateIdByUuid(UUID uuid) {
        return this.idxCacheUuidToTemplateId.computeIfAbsent(CacheKey.of(uuid, this.tenantService.getCurrentTenantIdentifier()), ck -> this.listAllOperationalTemplates().stream().filter(t -> t.getErrorList().isEmpty()).filter(t -> t.getOperationaltemplate().getUid().getValue().equals(((UUID)ck.val).toString())).map(t -> t.getOperationaltemplate().getTemplateId().getValue()).findFirst().orElse(null));
    }

    private UUID findUuidByTemplateId(String templateId) {
        return (UUID)this.idxCacheTemplateIdToUuid.computeIfAbsent((String)templateId, (Function<String, CacheKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findUuidByTemplateId$11(java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/ehrbase/service/KnowledgeCacheService$CacheKey;)((KnowledgeCacheService)this, (String)templateId)).val;
    }

    @Override
    public WebTemplate getQueryOptMetaData(UUID uuid) {
        CacheKey<UUID> ck = CacheKey.of(uuid, this.tenantService.getCurrentTenantIdentifier());
        WebTemplate retval = (WebTemplate)this.webTemplateCache.get(ck, WebTemplate.class);
        if (retval == null) {
            return this.buildAndCacheQueryOptMetaData(uuid);
        }
        return retval;
    }

    @Override
    public WebTemplate getQueryOptMetaData(String templateId) {
        return this.getQueryOptMetaData(this.findUuidByTemplateId(templateId));
    }

    private WebTemplate buildAndCacheQueryOptMetaData(UUID uuid) {
        Optional<Object> operationaltemplate = Optional.empty();
        try {
            operationaltemplate = this.retrieveOperationalTemplate(uuid);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (operationaltemplate.isPresent()) {
            return this.buildAndCacheQueryOptMetaData((OPERATIONALTEMPLATE)operationaltemplate.get());
        }
        throw new IllegalArgumentException("Could not retrieve  knowledgeCacheService.getKnowledgeCache() cache for template Uid:" + uuid);
    }

    private WebTemplate buildAndCacheQueryOptMetaData(OPERATIONALTEMPLATE operationaltemplate) {
        WebTemplate visitor;
        this.log.info("Updating WebTemplate cache for template: {}", (Object)TemplateUtils.getTemplateId(operationaltemplate));
        try {
            visitor = new OPTParser(operationaltemplate).parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid template: %s", e.getMessage()));
        }
        this.webTemplateCache.put(CacheKey.of(TemplateUtils.getUid(operationaltemplate), this.tenantService.getCurrentTenantIdentifier()), (Object)visitor);
        return visitor;
    }

    private OPERATIONALTEMPLATE getOperationaltemplateFromFileStorage(String filename) {
        Optional<OPERATIONALTEMPLATE> template = this.templateStorage.readOperationaltemplate(filename);
        template.ifPresent(existingTemplate -> this.idxCacheUuidToTemplateId.put(CacheKey.of(TemplateUtils.getUid(existingTemplate), this.tenantService.getCurrentTenantIdentifier()), filename));
        return template.orElse(null);
    }

    public int deleteAllOperationalTemplates() {
        List<TemplateMetaData> templateList = this.templateStorage.listAllOperationalTemplates();
        if (templateList.isEmpty()) {
            return 0;
        }
        int deleted = 0;
        for (TemplateMetaData metaData : templateList) {
            if (!this.deleteOperationalTemplate(metaData.getOperationaltemplate())) continue;
            ++deleted;
        }
        return deleted;
    }

    @Override
    public JsonPathQueryResult resolveForTemplate(String templateId, Collection<NodeId> nodeIds) {
        String tenantId = this.tenantService.getCurrentTenantIdentifier();
        Triple key = Triple.of((Object)templateId, (Object)tenantId, nodeIds);
        JsonPathQueryResult jsonPathQueryResult = (JsonPathQueryResult)this.jsonPathQueryResultCache.get((Object)key, JsonPathQueryResult.class);
        if (jsonPathQueryResult == null) {
            WebTemplate webTemplate = this.getQueryOptMetaData(templateId);
            List<Object> webTemplateNodeList = new ArrayList<WebTemplateNode>();
            webTemplateNodeList.add(webTemplate.getTree());
            for (NodeId nodeId : nodeIds) {
                webTemplateNodeList = webTemplateNodeList.stream().map(n -> n.findMatching(f -> {
                    if (f.getNodeId() == null) {
                        return false;
                    }
                    if (nodeId.getNodeId() == null) {
                        return nodeId.getClassName().equals(new NodeId(f.getNodeId()).getClassName());
                    }
                    return nodeId.equals((Object)new NodeId(f.getNodeId()));
                })).flatMap(Collection::stream).collect(Collectors.toList());
            }
            TreeSet<String> uniquePaths = new TreeSet<String>();
            webTemplateNodeList.stream().map(n -> n.getAqlPath(new WebTemplateNodeQuery(webTemplate, (WebTemplateNode)n).requiresNamePredicate())).forEach(uniquePaths::add);
            jsonPathQueryResult = !uniquePaths.isEmpty() ? new JsonPathQueryResult(templateId, uniquePaths) : new JsonPathQueryResult(null, Collections.emptyMap());
            this.jsonPathQueryResultCache.put((Object)key, (Object)jsonPathQueryResult);
        }
        if (jsonPathQueryResult.getTemplateId() != null) {
            return jsonPathQueryResult;
        }
        return null;
    }

    @Override
    public ItemInfo getInfo(String templateId, String aql) {
        Triple key = Triple.of((Object)templateId, (Object)this.tenantService.getCurrentTenantIdentifier(), (Object)aql);
        ItemInfo itemInfo = (ItemInfo)this.fieldCache.get((Object)key, ItemInfo.class);
        if (itemInfo == null) {
            WebTemplate webTemplate = this.getQueryOptMetaData(templateId);
            Optional node = webTemplate.findByAqlPath(aql);
            String type = node.isEmpty() ? null : (((WebTemplateNode)node.get()).getRmType().equals(ELEMENT) ? ((WebTemplateNode)((WebTemplateNode)node.get()).getChildren().get(0)).getRmType() : ((WebTemplateNode)node.get()).getRmType());
            String category = node.isEmpty() ? null : (aql.endsWith("/value") ? webTemplate.findByAqlPath(aql.replace("/value", "")).filter(n -> n.getRmType().equals(ELEMENT)).map(n -> ELEMENT).orElse("DATA_STRUCTURE") : "DATA_STRUCTURE");
            itemInfo = new ItemInfo(type, category);
            this.fieldCache.put((Object)key, (Object)itemInfo);
        }
        return itemInfo;
    }

    @Override
    public List<String> multiValued(String templateId) {
        CacheKey<String> key = CacheKey.of(templateId, this.tenantService.getCurrentTenantIdentifier());
        List list = (List)this.multivaluedCache.get(key, List.class);
        if (list == null) {
            list = this.getQueryOptMetaData(templateId).multiValued().stream().map(webTemplateNode -> webTemplateNode.getAqlPath(false)).collect(Collectors.toList());
            this.multivaluedCache.put(key, list);
        }
        return list;
    }

    @Override
    public I_KnowledgeCache getKnowledge() {
        return this;
    }

    private void validateTemplate(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        if (!TemplateUtils.isSupported(template)) {
            throw new IllegalArgumentException(MessageFormat.format("The supplied template is not supported (unsupported types: {0})", String.join((CharSequence)",", TemplateUtils.UNSUPPORTED_RM_TYPES)));
        }
    }

    private /* synthetic */ CacheKey lambda$findUuidByTemplateId$11(String templateId, String id) {
        OPERATIONALTEMPLATE templ = this.retrieveOperationalTemplate(id).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown template %s", templateId)));
        return CacheKey.of(UUID.fromString(templ.getUid().getValue()), this.tenantService.getCurrentTenantIdentifier());
    }

    static class CacheKey<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -5926035933645900703L;
        private final T val;
        private final String tenantId;

        static <T0 extends Serializable> CacheKey<T0> of(T0 val, String tenantId) {
            return new CacheKey<T0>(val, tenantId);
        }

        public T getVal() {
            return this.val;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        private CacheKey(T val, String tenantId) {
            this.val = val;
            this.tenantId = tenantId;
        }

        public int hashCode() {
            return Objects.hash(this.val, this.tenantId);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CacheKey) || ((CacheKey)obj).val.getClass() != this.val.getClass()) {
                return false;
            }
            CacheKey ck = (CacheKey)obj;
            return this.val.equals(ck.val) && this.tenantId.equals(ck.tenantId);
        }
    }

    private static abstract class SecCtxAwareRunnable
    implements Runnable {
        private Authentication auth;

        private SecCtxAwareRunnable(Authentication auth) {
            this.auth = auth;
        }

        @Override
        public void run() {
            SecurityContextHolder.getContext().setAuthentication(this.auth);
            this.doRun();
        }

        abstract void doRun();
    }
}

