/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.api.tenant.Tenant;
import org.ehrbase.dao.access.interfaces.I_TenantAccess;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TenantServiceImp
extends BaseServiceImp
implements TenantService {
    public TenantServiceImp(@Lazy KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
    }

    public String getCurrentTenantIdentifier() {
        return I_TenantAccess.currentTenantIdentifier();
    }

    public UUID create(Tenant tenant) {
        I_TenantAccess tenantAccess = I_TenantAccess.getNewInstance(this.getDataAccess().getContext(), tenant);
        return tenantAccess.commit();
    }

    public List<Tenant> getAll() {
        return I_TenantAccess.getAll(this.getDataAccess().getContext()).stream().map(ta -> ta.convert()).collect(Collectors.toList());
    }

    public Optional<Tenant> findBy(String tenantId) {
        return Optional.ofNullable(I_TenantAccess.retrieveInstanceBy(this.getDataAccess().getContext(), tenantId)).map(acc -> acc.convert());
    }

    public Tenant update(Tenant tenant) {
        return I_TenantAccess.retrieveInstanceBy(this.getDataAccess().getContext(), tenant.getTenantId()).update(tenant);
    }
}

