/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.serialisation.dbencoding.wrappers.json.writer.translator_db2raw.GenericRmType;
import org.jooq.DataType;
import org.jooq.impl.SQLDataType;

public class PGType {
    public static final String MAGNITUDE = "magnitude";
    public static final String VALUE = "value";
    public static final String VALUE_VALUE = "/value,value";
    public static final String COMMA_VALUE = ",value";
    public static final String NUMERATOR = "numerator";
    public static final String DENOMINATOR = "denominator";
    List<String> segmentedPath;
    private final IQueryImpl.Clause clause;

    public PGType(List<String> segmentedPath, IQueryImpl.Clause clause) {
        this.segmentedPath = segmentedPath;
        this.clause = clause;
    }

    public DataType forRmType(String type) {
        String attribute = this.segmentedPath.get(this.segmentedPath.size() - 1);
        String actualType = type;
        DataType pgtype = null;
        if (new GenericRmType(type).isSpecialized()) {
            if (new GenericRmType(type).mainType().equals("DV_INTERVAL") && (StringUtils.endsWith((CharSequence)attribute, (CharSequence)"lower_unbounded") || StringUtils.endsWith((CharSequence)attribute, (CharSequence)"upper_unbounded"))) {
                pgtype = SQLDataType.BOOLEAN;
            } else {
                actualType = new GenericRmType(type).specializedWith();
            }
        }
        if (pgtype == null) {
            pgtype = this.resolvePgTypeFromRmType(actualType, attribute);
        }
        if (pgtype == null && attribute.endsWith(MAGNITUDE)) {
            pgtype = SQLDataType.NUMERIC;
        }
        return pgtype;
    }

    DataType resolvePgTypeFromRmType(String type, String attribute) {
        DataType pgtype = null;
        switch (type) {
            case "DV_QUANTITY": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)MAGNITUDE)) break;
                pgtype = SQLDataType.NUMERIC;
                break;
            }
            case "DV_PROPORTION": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)NUMERATOR) && !StringUtils.endsWith((CharSequence)attribute, (CharSequence)DENOMINATOR)) break;
                pgtype = SQLDataType.NUMERIC;
                break;
            }
            case "DV_COUNT": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)MAGNITUDE)) break;
                pgtype = SQLDataType.BIGINT;
                break;
            }
            case "DV_ORDINAL": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)VALUE_VALUE)) break;
                pgtype = SQLDataType.BIGINT;
                break;
            }
            case "DV_BOOLEAN": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)COMMA_VALUE)) break;
                pgtype = SQLDataType.BOOLEAN;
                break;
            }
            case "DV_DURATION": {
                if (!StringUtils.endsWith((CharSequence)attribute, (CharSequence)COMMA_VALUE)) break;
                if (this.clause.equals((Object)IQueryImpl.Clause.WHERE)) {
                    pgtype = SQLDataType.INTERVAL;
                    break;
                }
                pgtype = SQLDataType.VARCHAR;
                break;
            }
        }
        if (pgtype == null && attribute.endsWith(MAGNITUDE)) {
            pgtype = SQLDataType.NUMERIC;
        }
        return pgtype;
    }
}

