/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_Compensatable;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_VersionedCRUD;
import org.ehrbase.dao.access.jooq.FolderAccess;
import org.ehrbase.dao.access.jooq.FolderHistoryAccess;
import org.ehrbase.dao.access.util.FolderUtils;
import org.joda.time.DateTime;

public interface I_FolderAccess
extends I_VersionedCRUD,
I_Compensatable {
    public static I_FolderAccess retrieveByVersion(I_DomainAccess domainAccess, UUID folderId, int version) {
        return FolderAccess.retrieveByVersion(domainAccess, folderId, version);
    }

    public static boolean isDeleted(I_DomainAccess domainAccess, UUID versionedObjectId) {
        return FolderAccess.isDeleted(domainAccess, versionedObjectId);
    }

    public UUID getEhrId();

    public Map<UUID, I_FolderAccess> getSubfoldersList();

    public List<ObjectRef<? extends ObjectId>> getItems();

    public static I_FolderAccess getNewFolderAccessInstance(I_DomainAccess domainAccess, Folder folder, DateTime dateTime, UUID ehrId, String tenantIdentifier) {
        return FolderAccess.getNewFolderAccessInstance(domainAccess, folder, dateTime, ehrId, tenantIdentifier);
    }

    public static I_FolderAccess retrieveInstanceForExistingFolder(I_DomainAccess domainAccess, UUID folderId) {
        return FolderAccess.retrieveInstanceForExistingFolder(domainAccess, folderId);
    }

    public static I_FolderAccess retrieveInstanceForExistingFolder(I_DomainAccess domainAccess, UUID folderId, Timestamp timestamp) {
        return FolderHistoryAccess.retrieveInstanceForExistingFolder(domainAccess, folderId, timestamp);
    }

    public static I_FolderAccess getInstanceForExistingFolder(I_DomainAccess domainAccess, ObjectVersionId folderId) {
        return FolderAccess.retrieveInstanceForExistingFolder(domainAccess, FolderUtils.extractUuidFromObjectVersionId(folderId));
    }

    public static I_FolderAccess getInstanceForExistingFolder(I_DomainAccess domainAccess, ObjectVersionId folderId, Timestamp timestamp) {
        return FolderAccess.retrieveInstanceForExistingFolder(domainAccess, FolderUtils.extractUuidFromObjectVersionId(folderId));
    }

    public static Set<ObjectVersionId> retrieveFolderVersionIdsInContribution(I_DomainAccess domainAccess, UUID contribution, String nodeName) {
        return FolderAccess.retrieveFolderVersionIdsInContribution(domainAccess, contribution, nodeName);
    }

    public UUID getFolderId();

    public void setFolderId(UUID var1);

    public UUID getInContribution();

    public void setInContribution(UUID var1);

    public String getFolderName();

    public void setFolderName(String var1);

    public String getFolderArchetypeNodeId();

    public void setFolderNArchetypeNodeId(String var1);

    public boolean isFolderActive();

    public void setIsFolderActive(boolean var1);

    public ItemStructure getFolderDetails();

    public void setFolderDetails(ItemStructure var1);

    public void setFolderSysTransaction(Timestamp var1);

    public Timestamp getFolderSysTransaction();

    public AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> getFolderSysPeriod();

    public void setFolderSysPeriod(AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> var1);

    public UUID getAudit();

    public void setAudit(UUID var1);

    public void adminDeleteFolder();
}

