/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.jooq.Field;
import org.jooq.Table;

class PartyIdentifiers {
    I_DomainAccess domainAccess;
    private static final BiFunction<Collection<IdentifierRecord>, UUID, Collection<IdentifierRecord>> allMatchingIdRec = (col, uuid) -> col.stream().filter(irec -> uuid.equals(irec.getParty())).collect(Collectors.toCollection(HashSet::new));
    private static final Function<IdentifierRecord, DvIdentifier> idConvert = record -> {
        DvIdentifier identifier = new DvIdentifier();
        identifier.setIssuer(record.getIssuer());
        identifier.setAssigner(record.getAssigner());
        identifier.setId(record.getIdValue());
        identifier.setType(record.getTypeName());
        return identifier;
    };

    PartyIdentifiers(I_DomainAccess domainAccess) {
        this.domainAccess = domainAccess;
    }

    void store(PartyIdentified partyIdentified, UUID partyIdentifiedUuid, String tenantIdentifier) {
        List identifierList = partyIdentified.getIdentifiers();
        if (identifierList != null) {
            for (DvIdentifier identifier : identifierList) {
                if (identifier.getId() == null) continue;
                this.domainAccess.getContext().insertInto((Table)Tables.IDENTIFIER, (Field)Tables.IDENTIFIER.PARTY, (Field)Tables.IDENTIFIER.ID_VALUE, (Field)Tables.IDENTIFIER.ISSUER, (Field)Tables.IDENTIFIER.ASSIGNER, (Field)Tables.IDENTIFIER.TYPE_NAME, (Field)Tables.IDENTIFIER.NAMESPACE).values((Object)partyIdentifiedUuid, (Object)identifier.getId(), (Object)identifier.getIssuer(), (Object)identifier.getAssigner(), (Object)identifier.getType(), (Object)tenantIdentifier).execute();
            }
        }
    }

    List<Pair<PartyIdentifiedRecord, List<DvIdentifier>>> retrieveMultiple(Collection<PartyIdentifiedRecord> partyIdentifiedRecords) {
        Set allIds = partyIdentifiedRecords.stream().map(pir -> pir.getId()).collect(Collectors.toSet());
        Collection allIdRecs = (Collection)this.domainAccess.getContext().selectFrom((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.in(allIds)).fetch().collect(Collectors.toCollection(HashSet::new));
        List<Pair<PartyIdentifiedRecord, List<DvIdentifier>>> result = partyIdentifiedRecords.stream().map(pir -> {
            List dvIds = allMatchingIdRec.apply(allIdRecs, pir.getId()).stream().map(record -> idConvert.apply((IdentifierRecord)record)).collect(Collectors.toList());
            return Pair.of((Object)pir, dvIds);
        }).collect(Collectors.toList());
        return result;
    }

    List<DvIdentifier> retrieve(PartyIdentifiedRecord partyIdentifiedRecord) {
        return this.domainAccess.getContext().fetch((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.PARTY.eq((Object)partyIdentifiedRecord.getId())).stream().map(record -> idConvert.apply((IdentifierRecord)record)).collect(Collectors.toList());
    }

    public boolean compare(List<DvIdentifier> identifiersFromDB, List<DvIdentifier> identifiers) {
        if (identifiersFromDB == null && identifiers == null) {
            return true;
        }
        if (identifiersFromDB == null && identifiers != null || identifiersFromDB != null && identifiers == null) {
            return false;
        }
        if (identifiersFromDB.size() != identifiers.size()) {
            return false;
        }
        List filteredList = identifiersFromDB.stream().filter(identifier -> identifiers.stream().anyMatch(identifier1 -> Objects.equals(identifier1.getType(), identifier.getType()) && Objects.equals(identifier1.getId(), identifier.getId()) && Objects.equals(identifier1.getAssigner(), identifier.getAssigner()) && Objects.equals(identifier1.getIssuer(), identifier.getIssuer()))).collect(Collectors.toList());
        return filteredList.size() == identifiersFromDB.size();
    }

    public boolean compare(PartyIdentifiedRecord partyIdentifiedRecord, List<DvIdentifier> identifiers) {
        List<DvIdentifier> identifiersFromDB = this.retrieve(partyIdentifiedRecord);
        return this.compare(identifiersFromDB, identifiers);
    }
}

