/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyIdentified;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRelated;
import org.ehrbase.dao.access.jooq.party.PersistedPartySelf;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.util.PartyUtils;
import org.jooq.Result;
import org.jooq.Table;

public class PersistedPartyProxy {
    I_DomainAccess domainAccess;
    private final BiFunction<Result<PartyIdentifiedRecord>, PartyType, Set<PartyIdentifiedRecord>> partyTypeFilter = (result, pt) -> result.stream().filter(r -> r.getPartyType() == pt).collect(Collectors.toSet());
    private final Consumer<Result<PartyIdentifiedRecord>> partyTypeValidator = result -> result.stream().forEach(p -> {
        switch (p.getPartyType()) {
            case party_self: 
            case party_identified: 
            case party_related: {
                return;
            }
        }
        throw new InternalServerException("Inconsistent Party type detected:" + p.getPartyRefType());
    });

    public PersistedPartyProxy(I_DomainAccess domainAccess) {
        this.domainAccess = domainAccess;
    }

    public UUID create(PartyProxy partyProxy, String tenantIdentifier) {
        if (PartyUtils.isPartySelf(partyProxy)) {
            return new PersistedPartySelf(this.domainAccess).store(partyProxy, tenantIdentifier);
        }
        if (PartyUtils.isPartyRelated(partyProxy)) {
            return new PersistedPartyRelated(this.domainAccess).store(partyProxy, tenantIdentifier);
        }
        if (PartyUtils.isPartyIdentified(partyProxy)) {
            return new PersistedPartyIdentified(this.domainAccess).store(partyProxy, tenantIdentifier);
        }
        throw new InternalServerException("Unhandled Party type detected:" + partyProxy.getClass().getSimpleName());
    }

    public Collection<PartyProxy> retrieveMany(List<UUID> uuids) {
        ArrayList<PartyProxy> partyProxies = new ArrayList<PartyProxy>();
        if (uuids.isEmpty()) {
            return partyProxies;
        }
        Result result = this.domainAccess.getContext().selectFrom((Table)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.in(uuids)).fetch();
        this.partyTypeValidator.accept((Result<PartyIdentifiedRecord>)result);
        Set<PartyIdentifiedRecord> self = this.partyTypeFilter.apply((Result<PartyIdentifiedRecord>)result, PartyType.party_self);
        List<PartyProxy> allParties = new PersistedPartySelf(this.domainAccess).renderMultiple(self);
        Set<PartyIdentifiedRecord> identified = this.partyTypeFilter.apply((Result<PartyIdentifiedRecord>)result, PartyType.party_identified);
        allParties.addAll(new PersistedPartyIdentified(this.domainAccess).renderMultiple(identified));
        Set<PartyIdentifiedRecord> related = this.partyTypeFilter.apply((Result<PartyIdentifiedRecord>)result, PartyType.party_related);
        allParties.addAll(new PersistedPartyRelated(this.domainAccess).renderMultiple(related));
        return allParties;
    }

    public PartyProxy retrieve(UUID id) {
        Iterator<PartyProxy> proxy = this.retrieveMany(List.of(id)).iterator();
        return proxy.hasNext() ? proxy.next() : null;
    }

    public UUID getOrCreate(PartyProxy partyProxy, String tenantIdentifier) {
        if (PartyUtils.isPartySelf(partyProxy)) {
            return new PersistedPartySelf(this.domainAccess).getOrCreate(partyProxy, tenantIdentifier);
        }
        if (PartyUtils.isPartyRelated(partyProxy)) {
            return new PersistedPartyRelated(this.domainAccess).getOrCreate(partyProxy, tenantIdentifier);
        }
        if (PartyUtils.isPartyIdentified(partyProxy)) {
            return new PersistedPartyIdentified(this.domainAccess).getOrCreate(partyProxy, tenantIdentifier);
        }
        throw new InternalServerException("Unhandled Party type detected:" + partyProxy.getClass().getSimpleName());
    }

    public UUID getOrCreate(String name, String code, String scheme, String namespace, String type, List<DvIdentifier> identifiers, String tenantIdentifier) {
        if (identifiers == null || identifiers.isEmpty()) {
            throw new IllegalArgumentException("Can't create PartyIdentified with invalid list of identifiers.");
        }
        identifiers.forEach(dv -> {
            if (!this.isValidDvIdentifier((DvIdentifier)dv)) {
                throw new IllegalArgumentException("Can't create PartyIdentified with an invalid identifier.");
            }
        });
        PartyIdentified partyIdentified = new PartyIdentified(new PartyRef((ObjectId)new GenericId(code, scheme), namespace, type), name, identifiers);
        return this.getOrCreate((PartyProxy)partyIdentified, tenantIdentifier);
    }

    private boolean isValidDvIdentifier(DvIdentifier identifier) {
        return identifier.getId() != null && !identifier.getId().isBlank();
    }
}

