/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.google.gson.JsonElement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.BadGatewayException;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.api.service.TenantService;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.dao.access.interfaces.I_StoredQueryAccess;
import org.ehrbase.dao.access.jooq.AqlQueryHandler;
import org.ehrbase.dao.access.jooq.StoredQueryAccess;
import org.ehrbase.dao.access.util.InvalidVersionFormatException;
import org.ehrbase.dao.access.util.SemVer;
import org.ehrbase.dao.access.util.SemVerUtil;
import org.ehrbase.dao.access.util.VersionConflictException;
import org.ehrbase.response.ehrscape.QueryDefinitionResultDto;
import org.ehrbase.response.ehrscape.QueryResultDto;
import org.ehrbase.response.ehrscape.StructuredString;
import org.ehrbase.response.ehrscape.StructuredStringFormat;
import org.ehrbase.response.ehrscape.query.ResultHolder;
import org.ehrbase.service.BaseServiceImp;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class QueryServiceImp
extends BaseServiceImp
implements QueryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExternalTerminologyValidation tsAdapter;
    private final TenantService tenantService;
    private static BiConsumer<Map<?, ?>, String> checkNonNull = (map, errMsg) -> {
        if (map == null) {
            throw new IllegalArgumentException((String)errMsg);
        }
    };
    private static final String ERR_MAP_NON_NULL = "Arg[%s] must not be null";

    @Autowired
    public QueryServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig, ExternalTerminologyValidation tsAdapter, TenantService tenantService) {
        super(knowledgeCacheService, context, serverConfig);
        this.tsAdapter = tsAdapter;
        this.tenantService = tenantService;
    }

    public QueryResultDto query(String queryString, Map<String, Object> parameters, boolean explain, Map<String, Set<Object>> auditResultMap) {
        AqlQueryHandler handler = new AqlQueryHandler(this.getDataAccess(), this.tsAdapter);
        return this.queryAql(queryString, explain, () -> parameters == null ? handler.process(queryString) : handler.process(queryString, parameters), auditResultMap);
    }

    private QueryResultDto formatResult(AqlResult aqlResult, String queryString, boolean explain) {
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL(queryString);
        dto.setVariables(aqlResult.getVariables());
        ArrayList<ResultHolder> resultList = new ArrayList<ResultHolder>();
        for (Record record : aqlResult.getRecords()) {
            ResultHolder fieldMap = new ResultHolder();
            for (Field field : record.fields()) {
                if (!aqlResult.variablesContains(field.getName())) continue;
                if (record.getValue(field) instanceof JsonElement) {
                    fieldMap.putResult(field.getName(), (Object)new StructuredString(record.getValue(field).toString(), StructuredStringFormat.JSON));
                    continue;
                }
                fieldMap.putResult(field.getName(), record.getValue(field));
            }
            resultList.add(fieldMap);
        }
        dto.setResultSet(resultList);
        if (explain) {
            dto.setExplain(aqlResult.getExplain());
        }
        return dto;
    }

    private QueryResultDto queryAql(String queryString, boolean explain, Supplier<AqlResult> resultSupplier, Map<String, Set<Object>> auditResultMap) {
        checkNonNull.accept(auditResultMap, String.format(ERR_MAP_NON_NULL, "auditResultMap"));
        try {
            AqlResult aqlResult = resultSupplier.get();
            auditResultMap.putAll(aqlResult.getAuditResultMap());
            return this.formatResult(aqlResult, queryString, explain);
        }
        catch (RestClientException e) {
            throw new BadGatewayException("Bad gateway exception: " + e.getCause().getMessage());
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not process query/stored-query, reason: " + e);
        }
    }

    public List<QueryDefinitionResultDto> retrieveStoredQueries(String fullyQualifiedName) {
        String name = (String)StringUtils.defaultIfEmpty((CharSequence)fullyQualifiedName, null);
        try {
            List<StoredQueryAccess> storedQueries = StoredQueryAccess.retrieveQualifiedList(this.getDataAccess(), name);
            return storedQueries.stream().map(QueryServiceImp::mapToQueryDefinitionDto).toList();
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason: " + e, e);
        }
    }

    public QueryDefinitionResultDto retrieveStoredQuery(String qualifiedName, String version) {
        Optional<StoredQueryAccess> storedQueryAccess;
        SemVer requestedVersion = QueryServiceImp.parseRequestSemVer(version);
        try {
            storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName, requestedVersion);
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
        return storedQueryAccess.map(QueryServiceImp::mapToQueryDefinitionDto).orElseThrow(() -> new IllegalArgumentException("Could not retrieve stored query for qualified name: " + qualifiedName));
    }

    public QueryDefinitionResultDto createStoredQuery(String qualifiedName, String version, String queryString) {
        SemVer requestedVersion = QueryServiceImp.parseRequestSemVer(version);
        try {
            new AqlExpression().parse(queryString);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid query, reason:" + e, e);
        }
        SemVer dbSemVer = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName, requestedVersion).map(q -> SemVer.parse(q.getSemver())).orElse(SemVer.NO_VERSION);
        QueryServiceImp.checkVersionCombination(requestedVersion, dbSemVer);
        SemVer newVersion = SemVerUtil.determineVersion(requestedVersion, dbSemVer);
        String tenantIdentifier = this.tenantService.getCurrentTenantIdentifier();
        StoredQueryAccess storedQueryAccess = new StoredQueryAccess(this.getDataAccess(), qualifiedName, newVersion, queryString, tenantIdentifier);
        boolean isUpdate = dbSemVer.isPreRelease();
        try {
            if (isUpdate) {
                storedQueryAccess.update(Timestamp.from(Instant.now()));
            } else {
                storedQueryAccess.commit();
            }
        }
        catch (DataAccessException e) {
            throw new GeneralRequestProcessingException("Data Access Error: " + e.getCause().getMessage(), (Throwable)e);
        }
        catch (VersionConflictException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return QueryServiceImp.mapToQueryDefinitionDto(storedQueryAccess);
    }

    private static void checkVersionCombination(SemVer requestSemVer, SemVer dbSemVer) {
        if (!dbSemVer.isNoVersion()) {
            if (dbSemVer.isPartial()) {
                throw new IllegalStateException("The database contains stored queries with partial versions");
            }
            if (dbSemVer.isPreRelease()) {
                if (!requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Pre-release " + dbSemVer + " was provided when " + requestSemVer + " was requested");
                }
            } else {
                if (requestSemVer.isPreRelease()) {
                    throw new RuntimeException("Version " + dbSemVer + " was provided when pre-release " + requestSemVer + " was requested");
                }
                if (requestSemVer.isRelease()) {
                    throw new StateConflictException("Version already exists");
                }
            }
        }
    }

    public QueryDefinitionResultDto deleteStoredQuery(String qualifiedName, String version) {
        SemVer requestedVersion = QueryServiceImp.parseRequestSemVer(version);
        if (requestedVersion.isNoVersion() || requestedVersion.isPartial()) {
            throw new InvalidApiParameterException("A qualified version has to be specified");
        }
        try {
            I_StoredQueryAccess storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName, requestedVersion).orElseThrow(() -> new ObjectNotFoundException("stored query", "Could not retrieve stored query for qualified name: " + qualifiedName + " version:" + version));
            storedQueryAccess.delete();
            return QueryServiceImp.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (ObjectNotFoundException e) {
            throw e;
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (RuntimeException e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    private static SemVer parseRequestSemVer(String version) {
        try {
            return SemVer.parse(version);
        }
        catch (InvalidVersionFormatException e) {
            throw new InvalidApiParameterException("Incorrect version. Use the SEMVER format.", (Throwable)e);
        }
    }

    private static QueryDefinitionResultDto mapToQueryDefinitionDto(I_StoredQueryAccess storedQueryAccess) {
        QueryDefinitionResultDto dto = new QueryDefinitionResultDto();
        dto.setSaved(storedQueryAccess.getCreationDate().toInstant().atZone(ZoneId.systemDefault()));
        dto.setQualifiedName(storedQueryAccess.getReverseDomainName() + "::" + storedQueryAccess.getSemanticId());
        dto.setVersion(storedQueryAccess.getSemver());
        dto.setQueryText(storedQueryAccess.getQueryText());
        dto.setType(storedQueryAccess.getQueryType());
        return dto;
    }
}

